/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IClass;
import org.testng.IInstanceInfo;
import org.testng.IObjectFactory;
import org.testng.ITestContext;
import org.testng.TestNGException;
import org.testng.annotations.IAnnotation;
import org.testng.annotations.IObjectFactoryAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.BaseClassFinder;
import org.testng.internal.ClassHelper;
import org.testng.internal.ClassInfoMap;
import org.testng.internal.FactoryMethod;
import org.testng.internal.ObjectFactoryImpl;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGClassFinder
extends BaseClassFinder {
    private ITestContext m_testContext = null;
    private Map<Class, List<Object>> m_instanceMap = Maps.newHashMap();

    public TestNGClassFinder(ClassInfoMap cim, Map<Class, List<Object>> instanceMap, XmlTest xmlTest, IAnnotationFinder annotationFinder, ITestContext testContext) {
        this.m_testContext = testContext;
        if (null == instanceMap) {
            instanceMap = Maps.newHashMap();
        }
        Set<Class<?>> allClasses = cim.getClasses();
        IObjectFactory objectFactory = testContext.getSuite().getObjectFactory();
        if (objectFactory == null) {
            objectFactory = new ObjectFactoryImpl();
            block4: for (Class<?> clazz : allClasses) {
                try {
                    if (null == clazz) continue;
                    for (Method m : clazz.getMethods()) {
                        IAnnotation a = annotationFinder.findAnnotation(m, IObjectFactoryAnnotation.class);
                        if (null == a) continue;
                        if (!IObjectFactory.class.isAssignableFrom(m.getReturnType())) {
                            throw new TestNGException("Return type of " + m + " is not IObjectFactory");
                        }
                        try {
                            Object instance = clazz.newInstance();
                            if (m.getParameterTypes().length > 0 && m.getParameterTypes()[0].equals(ITestContext.class)) {
                                objectFactory = (IObjectFactory)m.invoke(instance, testContext);
                                break block4;
                            }
                            objectFactory = (IObjectFactory)m.invoke(instance, new Object[0]);
                            break block4;
                        }
                        catch (Exception ex) {
                            throw new TestNGException("Error creating object factory", ex);
                        }
                    }
                }
                catch (NoClassDefFoundError e) {
                    Utils.log("[TestNGClassFinder]", 1, "Unable to read methods on class " + clazz.getName() + " - unable to resolve class reference " + e.getMessage());
                    for (XmlClass xmlClass : xmlTest.getXmlClasses()) {
                        if (xmlClass.getDeclaredClass() != Boolean.TRUE || !xmlClass.getName().equals(clazz.getName())) continue;
                        throw e;
                    }
                }
            }
        }
        for (Class<?> clazz : allClasses) {
            if (null == clazz) {
                TestNGClassFinder.ppp("FOUND NULL CLASS IN FOLLOWING ARRAY:");
                int i = 0;
                for (Class<?> c : allClasses) {
                    TestNGClassFinder.ppp("  " + i + ": " + c);
                }
                continue;
            }
            if (TestNGClassFinder.isTestNGClass(clazz, annotationFinder)) {
                Object thisInstance;
                List<Object> allInstances = instanceMap.get(clazz);
                Object object = thisInstance = null != allInstances ? allInstances.get(0) : null;
                if (null == thisInstance && Modifier.isAbstract(clazz.getModifiers())) {
                    Utils.log("", 5, "[WARN] Found an abstract class with no valid instance attached: " + clazz);
                    continue;
                }
                IClass ic = this.findOrCreateIClass(clazz, cim.getXmlClass(clazz), thisInstance, xmlTest, annotationFinder, objectFactory);
                if (null == ic) continue;
                Object[] theseInstances = ic.getInstances(false);
                if (theseInstances.length == 0) {
                    theseInstances = ic.getInstances(true);
                }
                Object instance = theseInstances[0];
                this.putIClass(clazz, ic);
                Method factoryMethod = ClassHelper.findFactoryMethod(clazz, annotationFinder);
                if (null == factoryMethod) continue;
                FactoryMethod fm = new FactoryMethod(factoryMethod, instance, xmlTest, annotationFinder, this.m_testContext);
                ClassInfoMap moreClasses = new ClassInfoMap();
                Object[] instances = fm.invoke();
                if (instances.length > 0) {
                    Class<?> elementClass = instances[0].getClass();
                    if (IInstanceInfo.class.isAssignableFrom(elementClass)) {
                        for (Object o : instances) {
                            IInstanceInfo ii = (IInstanceInfo)o;
                            this.addInstance(ii.getInstanceClass(), ii.getInstance());
                            moreClasses.addClass(ii.getInstanceClass());
                        }
                    } else {
                        for (Object o : instances) {
                            this.addInstance(o.getClass(), o);
                            if (this.classExists(o.getClass())) continue;
                            moreClasses.addClass(o.getClass());
                        }
                    }
                }
                if (moreClasses.getSize() <= 0) continue;
                TestNGClassFinder finder = new TestNGClassFinder(moreClasses, this.m_instanceMap, xmlTest, annotationFinder, this.m_testContext);
                IClass[] moreIClasses = finder.findTestClasses();
                for (IClass ic2 : moreIClasses) {
                    this.putIClass(ic2.getRealClass(), ic2);
                }
                continue;
            }
            Utils.log("TestNGClassFinder", 3, "SKIPPING CLASS " + clazz + " no TestNG annotations found");
        }
        for (Class<?> clazz : this.m_instanceMap.keySet()) {
            List<Object> instances = this.m_instanceMap.get(clazz);
            for (Object instance : instances) {
                IClass ic = this.getIClass(clazz);
                if (null == ic) continue;
                ic.addInstance(instance);
            }
        }
    }

    public static boolean isTestNGClass(Class cls, IAnnotationFinder annotationFinder) {
        Class[] allAnnotations = AnnotationHelper.getAllAnnotations();
        try {
            for (Class annotation : allAnnotations) {
                for (Method m : cls.getMethods()) {
                    IAnnotation ma = annotationFinder.findAnnotation(m, annotation);
                    if (null == ma) continue;
                    return true;
                }
                IAnnotation a = annotationFinder.findAnnotation(cls, annotation);
                if (null != a) {
                    return true;
                }
                for (Constructor<?> ctor : cls.getConstructors()) {
                    IAnnotation ca = annotationFinder.findAnnotation(ctor, annotation);
                    if (null == ca) continue;
                    return true;
                }
            }
            return false;
        }
        catch (NoClassDefFoundError e) {
            Utils.log("[TestNGClassFinder]", 1, "Unable to read methods on class " + cls.getName() + " - unable to resolve class reference " + e.getMessage());
            return false;
        }
    }

    private void addInstance(Class clazz, Object o) {
        List<Object> list = this.m_instanceMap.get(clazz);
        if (null == list) {
            list = Lists.newArrayList();
            this.m_instanceMap.put(clazz, list);
        }
        list.add(o);
    }

    public static void ppp(String s) {
        System.out.println("[TestNGClassFinder] " + s);
    }
}

