/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui.modeling;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.vecmath.AxisAngle4d;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.ui.modeling.PreviewPanel;
import replicatorg.app.ui.modeling.Tool;
import replicatorg.app.ui.modeling.ToolPanel;

public class RotationTool
extends Tool {
    JCheckBox lockZ;

    public RotationTool(ToolPanel parent) {
        super(parent);
    }

    Icon getButtonIcon() {
        return null;
    }

    String getButtonName() {
        return "Rotate";
    }

    JPanel getControls() {
        JPanel p = new JPanel((LayoutManager)new MigLayout("fillx,gap 0,wrap 2", "[50%]0[50%]"));
        JButton b = this.createToolButton("Z+", "images/center-object.png");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RotationTool.this.parent.getModel().rotateObject(new AxisAngle4d(0.0, 0.0, 1.0, 1.5707963267948966));
            }
        });
        p.add((Component)b, "growx");
        b = this.createToolButton("Z-", "images/center-object.png");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RotationTool.this.parent.getModel().rotateObject(new AxisAngle4d(0.0, 0.0, 1.0, -1.5707963267948966));
            }
        });
        p.add((Component)b, "growx");
        b = this.createToolButton("X+", "images/center-object.png");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RotationTool.this.parent.getModel().rotateObject(new AxisAngle4d(1.0, 0.0, 0.0, 1.5707963267948966));
            }
        });
        p.add((Component)b, "growx");
        b = this.createToolButton("X-", "images/center-object.png");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RotationTool.this.parent.getModel().rotateObject(new AxisAngle4d(1.0, 0.0, 0.0, -1.5707963267948966));
            }
        });
        p.add((Component)b, "growx");
        b = this.createToolButton("Y+", "images/center-object.png");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RotationTool.this.parent.getModel().rotateObject(new AxisAngle4d(0.0, 1.0, 0.0, 1.5707963267948966));
            }
        });
        p.add((Component)b, "growx");
        b = this.createToolButton("Y-", "images/center-object.png");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RotationTool.this.parent.getModel().rotateObject(new AxisAngle4d(0.0, 1.0, 0.0, -1.5707963267948966));
            }
        });
        p.add((Component)b, "growx");
        b = this.createToolButton("Lay flat", "images/center-object.png");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RotationTool.this.parent.getModel().layFlat();
            }
        });
        p.add((Component)b, "growx,spanx");
        this.lockZ = new JCheckBox("Rotate around Z");
        p.add((Component)this.lockZ, "growx,spanx");
        return p;
    }

    public String getInstructions() {
        return Base.isMacOS() ? "<html><body>Drag to rotate object<br>Shift-drag to rotate view<br>Mouse wheel to zoom</body></html>" : "<html><body>Left drag to rotate object<br>Right drag to rotate view<br>Mouse wheel to zoom</body></html>";
    }

    String getTitle() {
        return "Rotate Object";
    }

    public void mouseDragged(MouseEvent e) {
        if (this.startPoint == null) {
            return;
        }
        Point p = e.getPoint();
        PreviewPanel.DragMode mode = PreviewPanel.DragMode.NONE;
        if (Base.isMacOS()) {
            if (this.button == 1 && !e.isShiftDown()) {
                mode = PreviewPanel.DragMode.ROTATE_OBJECT;
            }
        } else if (this.button == 1) {
            mode = PreviewPanel.DragMode.ROTATE_OBJECT;
        }
        double xd = p.x - this.startPoint.x;
        double yd = -((double)(p.y - this.startPoint.y));
        if (this.lockZ.isSelected()) {
            yd = 0.0;
        }
        switch (mode) {
            case ROTATE_OBJECT: {
                this.parent.getModel().rotateObject(0.05 * xd, -0.05 * yd);
                break;
            }
            case NONE: {
                super.mouseDragged(e);
            }
        }
        this.startPoint = p;
    }
}

