/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui.modeling;

import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.util.logging.Level;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.MachineController;
import replicatorg.app.ui.MainWindow;
import replicatorg.app.ui.modeling.EditingModel;
import replicatorg.app.ui.modeling.Tool;
import replicatorg.app.ui.modeling.ToolPanel;
import replicatorg.machine.model.BuildVolume;
import replicatorg.machine.model.MachineModel;
import replicatorg.model.BuildModel;

public class PreviewPanel
extends JPanel {
    BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0);
    EditingModel model = null;
    BranchGroup scene;
    BuildVolume buildVol;
    MainWindow mainWindow;
    ToolPanel toolPanel;
    Tool currentTool = null;
    Canvas3D canvas;
    private SimpleUniverse univ = null;
    private boolean showEdges = false;
    final double[] wireBoxCoordinates = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0};
    Font3D labelFont = null;
    BranchGroup sceneGroup;
    BranchGroup objectBranch;
    static final Vector3d CAMERA_TRANSLATION_DEFAULT = new Vector3d(0.0, 0.0, 290.0);
    static final double ELEVATION_ANGLE_DEFAULT = 1.278;
    static final double TURNTABLE_ANGLE_DEFAULT = 0.214;
    static final double CAMERA_DISTANCE_DEFAULT = 300.0;
    Vector3d cameraTranslation = new Vector3d(CAMERA_TRANSLATION_DEFAULT);
    double elevationAngle = 1.278;
    double turntableAngle = 0.214;

    public EditingModel getModel() {
        return this.model;
    }

    public void setModel(BuildModel buildModel) {
        if (this.model == null || buildModel != this.model.getBuildModel()) {
            if (buildModel != null) {
                this.model = new EditingModel(buildModel, this.mainWindow);
                this.setScene(this.model);
            } else {
                this.model = null;
            }
        }
    }

    private void setScene(EditingModel model) {
        Base.logger.info(model.model.getPath());
        if (this.objectBranch != null) {
            this.sceneGroup.removeChild((Node)this.objectBranch);
        }
        this.objectBranch = model.getGroup();
        this.sceneGroup.addChild((Node)this.objectBranch);
    }

    public void rebuildScene() {
        if (this.objectBranch != null) {
            this.sceneGroup.removeChild((Node)this.objectBranch);
        }
        this.scene.detach();
        this.scene = this.createSTLScene();
        this.objectBranch = this.model.getGroup();
        this.sceneGroup.addChild((Node)this.objectBranch);
        this.univ.addBranchGraph(this.scene);
    }

    private void getBuildVolume() {
        Base.logger.fine("Resetting the build volume!");
        MachineController mc = this.mainWindow.getMachine();
        if (mc instanceof MachineController) {
            MachineModel mm = mc.getModel();
            this.buildVol = mm.getBuildVolume();
            Base.logger.fine("Dimensions:" + this.buildVol.getX() + ',' + this.buildVol.getY() + ',' + this.buildVol.getZ());
        }
    }

    void setTool(Tool tool) {
        if (this.currentTool == tool) {
            return;
        }
        if (this.currentTool != null) {
            if (this.currentTool instanceof MouseListener) {
                this.canvas.removeMouseListener((MouseListener)this.currentTool);
            }
            if (this.currentTool instanceof MouseMotionListener) {
                this.canvas.removeMouseMotionListener((MouseMotionListener)this.currentTool);
            }
            if (this.currentTool instanceof MouseWheelListener) {
                this.canvas.removeMouseWheelListener((MouseWheelListener)this.currentTool);
            }
            if (this.currentTool instanceof KeyListener) {
                this.canvas.removeKeyListener((KeyListener)((Object)this.currentTool));
            }
        }
        this.currentTool = tool;
        if (this.currentTool != null) {
            if (this.currentTool instanceof MouseListener) {
                this.canvas.addMouseListener((MouseListener)this.currentTool);
            }
            if (this.currentTool instanceof MouseMotionListener) {
                this.canvas.addMouseMotionListener((MouseMotionListener)this.currentTool);
            }
            if (this.currentTool instanceof MouseWheelListener) {
                this.canvas.addMouseWheelListener((MouseWheelListener)this.currentTool);
            }
            if (this.currentTool instanceof KeyListener) {
                this.canvas.addKeyListener((KeyListener)((Object)this.currentTool));
            }
        }
    }

    void adjustViewAngle(double deltaYaw, double deltaPitch) {
        this.turntableAngle += deltaYaw;
        this.elevationAngle += deltaPitch;
        this.updateVP();
    }

    void adjustViewTranslation(double deltaX, double deltaY) {
        this.cameraTranslation.x += deltaX;
        this.cameraTranslation.y += deltaY;
        this.updateVP();
    }

    void adjustZoom(double deltaZoom) {
        this.cameraTranslation.z += deltaZoom;
        this.updateVP();
    }

    public PreviewPanel(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.setLayout((LayoutManager)new MigLayout("fill,ins 0,gap 0"));
        this.canvas = this.createUniverse();
        this.add((Component)this.canvas, "growx,growy");
        this.toolPanel = new ToolPanel(this);
        if (Base.isMacOS()) {
            this.add((Component)this.toolPanel, "dock east,width max(300,25%)");
        } else {
            this.add((Component)this.toolPanel, "dock east,width max(200,20%)");
        }
        this.scene = this.createSTLScene();
        this.univ.addBranchGraph(this.scene);
        this.canvas.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() != 'e') {
                    return;
                }
                PreviewPanel.this.showEdges = !PreviewPanel.this.showEdges;
                PreviewPanel.this.model.showEdges(PreviewPanel.this.showEdges);
                PreviewPanel.this.updateVP();
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        this.addKeyListener(this.toolPanel);
    }

    public Node makeAmbientLight() {
        AmbientLight ambient = new AmbientLight();
        ambient.setColor(new Color3f(0.3f, 0.3f, 0.9f));
        ambient.setInfluencingBounds((Bounds)this.bounds);
        return ambient;
    }

    public Node makeDirectedLight1() {
        Color3f color = new Color3f(0.7f, 0.7f, 0.7f);
        Vector3f direction = new Vector3f(1.0f, 0.7f, -0.2f);
        DirectionalLight light = new DirectionalLight(color, direction);
        light.setInfluencingBounds((Bounds)this.bounds);
        return light;
    }

    public Node makeDirectedLight2() {
        Color3f color = new Color3f(0.5f, 0.5f, 0.5f);
        Vector3f direction = new Vector3f(-1.0f, -0.7f, 0.2f);
        DirectionalLight light = new DirectionalLight(color, direction);
        light.setInfluencingBounds((Bounds)this.bounds);
        return light;
    }

    public Shape3D makeBoxFrame(Point3d ll, Vector3d dim) {
        Appearance edges = new Appearance();
        edges.setLineAttributes(new LineAttributes(0.9f, 0, false));
        edges.setPolygonAttributes(new PolygonAttributes(1, 0, 0.0f));
        double[] coords = new double[this.wireBoxCoordinates.length];
        for (int i = 0; i < this.wireBoxCoordinates.length; ++i) {
            coords[i] = this.wireBoxCoordinates[i] * dim.x + ll.x;
            coords[++i] = this.wireBoxCoordinates[i] * dim.y + ll.y;
            coords[++i] = this.wireBoxCoordinates[i] * dim.z + ll.z;
        }
        LineArray wires = new LineArray(this.wireBoxCoordinates.length / 3, 1);
        wires.setCoordinates(0, coords);
        return new Shape3D((Geometry)wires, edges);
    }

    public Group makeLabel(String s, Vector3d where) {
        if (this.labelFont == null) {
            this.labelFont = new Font3D(Font.decode("Sans"), new FontExtrusion());
        }
        Text3D text = new Text3D(this.labelFont, s);
        TransformGroup tg = new TransformGroup();
        Transform3D transform = new Transform3D();
        transform.setTranslation(where);
        tg.setTransform(transform);
        OrientedShape3D os = new OrientedShape3D();
        os.setAlignmentAxis(0.0f, 0.0f, 1.0f);
        os.setAlignmentMode(1);
        os.setConstantScaleEnable(true);
        os.setScale(0.05);
        os.setGeometry((Geometry)text);
        tg.addChild((Node)os);
        return tg;
    }

    public Group makeAxes(Point3d origin) {
        Group g = new Group();
        g.addChild((Node)this.makeLabel("X", new Vector3d(57.0, 0.0, 0.0)));
        g.addChild((Node)this.makeLabel("Y", new Vector3d(0.0, 57.0, 0.0)));
        g.addChild((Node)this.makeLabel("Z", new Vector3d(0.0, 0.0, 107.0)));
        return g;
    }

    private void loadPoint(Point3d point, double[] array, int idx) {
        array[idx] = point.x;
        array[idx + 1] = point.y;
        array[idx + 2] = point.z;
    }

    private Shape3D makePlatform(Point3d lower, Point3d upper) {
        Color3f color = new Color3f(1.0f, 1.0f, 1.0f);
        Material m = new Material();
        m.setAmbientColor(color);
        m.setDiffuseColor(color);
        Appearance solid = new Appearance();
        solid.setTransparencyAttributes(new TransparencyAttributes(1, 0.6f));
        solid.setMaterial(m);
        PolygonAttributes pa = new PolygonAttributes();
        pa.setPolygonMode(2);
        pa.setCullFace(0);
        pa.setBackFaceNormalFlip(true);
        solid.setPolygonAttributes(pa);
        double[] coords = new double[12];
        this.loadPoint(lower, coords, 0);
        this.loadPoint(new Point3d(lower.x, upper.y, upper.z), coords, 3);
        this.loadPoint(upper, coords, 6);
        this.loadPoint(new Point3d(upper.x, lower.y, upper.z), coords, 9);
        QuadArray plat = new QuadArray(4, 1);
        plat.setCoordinates(0, coords);
        return new Shape3D((Geometry)plat, solid);
    }

    public Node makeBoundingBox() {
        Group boxGroup = new Group();
        if (this.buildVol == null) {
            Shape3D boxframe = this.makeBoxFrame(new Point3d(-50.0, -50.0, 0.0), new Vector3d(100.0, 100.0, 100.0));
            boxGroup.addChild((Node)boxframe);
            boxGroup.addChild((Node)this.makePlatform(new Point3d(-50.0, -50.0, -0.001), new Point3d(50.0, 50.0, -0.001)));
        } else {
            Vector3d boxdims = new Vector3d((double)this.buildVol.getX(), (double)this.buildVol.getY(), (double)this.buildVol.getZ());
            Shape3D boxframe = this.makeBoxFrame(new Point3d((double)(-this.buildVol.getX() / 2), (double)(-this.buildVol.getY() / 2), 0.0), boxdims);
            boxGroup.addChild((Node)boxframe);
            boxGroup.addChild((Node)this.makePlatform(new Point3d((double)(-this.buildVol.getX() / 2), (double)(-this.buildVol.getY() / 2), -0.001), new Point3d((double)(this.buildVol.getX() / 2), (double)(this.buildVol.getY() / 2), -0.001)));
        }
        return boxGroup;
    }

    public Node makeBackground() {
        Background bg = new Background(0.5f, 0.5f, 0.6f);
        bg.setApplicationBounds((Bounds)this.bounds);
        return bg;
    }

    public Node makeBaseGrid(boolean xOrY) {
        if (this.buildVol instanceof BuildVolume) {
            int idx;
            int i;
            int gridSpacing = 10;
            Appearance edges = new Appearance();
            edges.setLineAttributes(new LineAttributes(1.0f, 0, true));
            edges.setColoringAttributes(new ColoringAttributes(0.6f, 0.6f, 0.8f, 0));
            int lineCountX = 1 + this.buildVol.getX() / gridSpacing;
            int lineCountY = 1 + this.buildVol.getY() / gridSpacing;
            LineArray gridX = new LineArray(4 * lineCountX, 1);
            LineArray gridY = new LineArray(4 * lineCountY, 1);
            for (i = 1; i < lineCountX - 1; ++i) {
                double offsetX = -this.buildVol.getX() / 2 + this.buildVol.getX() / (lineCountX - 1) * i;
                idx = (i - 1) * 4;
                gridX.setCoordinate(idx++, new Point3d(offsetX, (double)(-this.buildVol.getY() / 2), 0.0));
                gridX.setCoordinate(idx++, new Point3d(offsetX, (double)(this.buildVol.getY() / 2), 0.0));
            }
            for (i = 1; i < lineCountY - 1; ++i) {
                double offsetY = -this.buildVol.getY() / 2 + this.buildVol.getY() / (lineCountY - 1) * i;
                idx = (i - 1) * 4;
                gridY.setCoordinate(idx++, new Point3d((double)(-this.buildVol.getX() / 2), offsetY, 0.0));
                gridY.setCoordinate(idx++, new Point3d((double)(this.buildVol.getX() / 2), offsetY, 0.0));
            }
            Base.logger.finer("LineCountX,Y:" + lineCountX + ',' + lineCountY);
            if (xOrY) {
                return new Shape3D((Geometry)gridX, edges);
            }
            return new Shape3D((Geometry)gridY, edges);
        }
        return null;
    }

    public void align() {
        this.model.center();
    }

    public BranchGroup createSTLScene() {
        this.getBuildVolume();
        BranchGroup objRoot = new BranchGroup();
        objRoot.setCapability(17);
        this.sceneGroup = new BranchGroup();
        this.sceneGroup.setCapability(14);
        this.sceneGroup.setCapability(13);
        this.sceneGroup.addChild(this.makeAmbientLight());
        this.sceneGroup.addChild(this.makeDirectedLight1());
        this.sceneGroup.addChild(this.makeDirectedLight2());
        this.sceneGroup.addChild(this.makeBoundingBox());
        this.sceneGroup.addChild(this.makeBackground());
        this.sceneGroup.addChild(this.makeBaseGrid(true));
        this.sceneGroup.addChild(this.makeBaseGrid(false));
        objRoot.addChild((Node)this.sceneGroup);
        objRoot.compile();
        return objRoot;
    }

    Transform3D getViewTransform() {
        TransformGroup viewTG = this.univ.getViewingPlatform().getViewPlatformTransform();
        Transform3D t = new Transform3D();
        viewTG.getTransform(t);
        return t;
    }

    private void updateVP() {
        TransformGroup viewTG = this.univ.getViewingPlatform().getViewPlatformTransform();
        Transform3D t3d = new Transform3D();
        Transform3D trans = new Transform3D();
        Transform3D rotZ = new Transform3D();
        Transform3D rotX = new Transform3D();
        trans.setTranslation(this.cameraTranslation);
        Transform3D drop = new Transform3D();
        Transform3D raise = new Transform3D();
        drop.setTranslation(new Vector3d(0.0, 0.0, 50.0));
        raise.invert(drop);
        rotX.rotX(this.elevationAngle);
        rotZ.rotZ(this.turntableAngle);
        t3d.mul(drop);
        t3d.mul(rotZ);
        t3d.mul(rotX);
        t3d.mul(raise);
        t3d.mul(trans);
        viewTG.setTransform(t3d);
        if (Base.logger.isLoggable(Level.FINE)) {
            Base.logger.fine("Camera Translation: " + this.cameraTranslation.toString());
            Base.logger.fine("Elevation " + Double.toString(this.elevationAngle) + ", turntable " + Double.toString(this.turntableAngle));
        }
    }

    private Canvas3D createUniverse() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config){

            public Dimension getMinimumSize() {
                return new Dimension(0, 0);
            }
        };
        this.univ = new SimpleUniverse(c);
        this.univ.getViewer().getView().setSceneAntialiasingEnable(true);
        this.univ.getViewer().getView().setFrontClipDistance(10.0);
        this.univ.getViewer().getView().setBackClipDistance(1000.0);
        this.updateVP();
        this.univ.getViewer().getView().setMinimumFrameCycleTime(5L);
        return c;
    }

    void resetView() {
        this.elevationAngle = 1.278;
        this.turntableAngle = 0.214;
        this.updateVP();
    }

    public void viewXY() {
        this.turntableAngle = 0.0;
        this.elevationAngle = 0.0;
        this.updateVP();
    }

    public void viewYZ() {
        this.turntableAngle = 0.0;
        this.elevationAngle = 1.5707963267948966;
        this.updateVP();
    }

    public void viewXZ() {
        this.elevationAngle = 1.5707963267948966;
        this.turntableAngle = 1.5707963267948966;
        this.updateVP();
    }

    public void usePerspective(boolean perspective) {
        this.univ.getViewer().getView().setProjectionPolicy(perspective ? 1 : 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DragMode {
        NONE,
        ROTATE_VIEW,
        TRANSLATE_VIEW,
        ROTATE_OBJECT,
        SCALE_OBJECT,
        TRANSLATE_OBJECT;

    }
}

