/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.MachineController;
import replicatorg.drivers.Driver;
import replicatorg.drivers.RealtimeControl;

public class RealtimePanel
extends JFrame
implements ChangeListener,
WindowListener {
    private static final long serialVersionUID = -6193762098842247273L;
    protected MachineController machine;
    protected Driver driver;
    private static RealtimePanel instance = null;
    JPanel mainPanel;
    ControlSlider feedrateControl;
    ControlSlider travelFeedrateControl;
    ControlSlider extrusionControl;

    public RealtimePanel(MachineController m) {
        super("Real time control and tuning");
        BufferedImage icon = Base.getImage("images/icon.gif", this);
        this.setIconImage(icon);
        this.machine = m;
        this.driver = this.machine.getDriver();
        ((RealtimeControl)((Object)this.driver)).enableRealtimeControl(true);
        JPanel speedPanel = new JPanel();
        JPanel extrusionPanel = new JPanel();
        this.add(new JLabel("Build speed (during extrusion)"));
        this.feedrateControl = new ControlSlider("Feedrate", "%", 5, 800, 100, speedPanel);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(10), new JLabel("Slow"));
        labelTable.put(new Integer(100), new JLabel(""));
        labelTable.put(new Integer(300), new JLabel("Fast"));
        labelTable.put(new Integer(500), new JLabel("Insane!"));
        this.feedrateControl.slider.setLabelTable(labelTable);
        this.travelFeedrateControl = new ControlSlider("Travel feedrate", "%", 5, 800, 100, speedPanel);
        this.travelFeedrateControl.slider.setLabelTable(labelTable);
        extrusionPanel.add((Component)new JLabel("Extrusion"), "growx,wrap");
        this.extrusionControl = new ControlSlider("Material muliplier", "%", 5, 500, 100, extrusionPanel);
        this.extrusionControl.slider.setEnabled(false);
        this.extrusionControl.field.setEnabled(false);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout((LayoutManager)new MigLayout());
        this.mainPanel.add((Component)speedPanel, "flowy,wrap");
        this.mainPanel.add((Component)extrusionPanel, "flowy,wrap");
        new SpeedLimit(this.mainPanel);
        JCheckBox showCommsDebug = new JCheckBox("Show communications");
        if (((RealtimeControl)((Object)this.driver)).getDebugLevel() >= 2) {
            showCommsDebug.setSelected(true);
        }
        showCommsDebug.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    ((RealtimeControl)((Object)RealtimePanel.this.driver)).setDebugLevel(2);
                } else {
                    ((RealtimeControl)((Object)RealtimePanel.this.driver)).setDebugLevel(1);
                }
            }
        });
        this.mainPanel.add((Component)showCommsDebug, "flowy,wrap");
        this.add(this.mainPanel);
    }

    public static synchronized RealtimePanel getRealtimePanel(MachineController m) {
        if (instance == null) {
            instance = new RealtimePanel(m);
        } else if (RealtimePanel.instance.machine != m) {
            instance.dispose();
            instance = new RealtimePanel(m);
        }
        return instance;
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
    }

    public void stateChanged(ChangeEvent arg0) {
    }

    public void windowActivated(WindowEvent arg0) {
    }

    public void windowClosed(WindowEvent arg0) {
    }

    public void windowClosing(WindowEvent arg0) {
    }

    public void windowDeactivated(WindowEvent arg0) {
    }

    public void windowDeiconified(WindowEvent arg0) {
    }

    public void windowIconified(WindowEvent arg0) {
    }

    public void windowOpened(WindowEvent arg0) {
    }

    private class SpeedLimit
    implements FocusListener {
        JTextField speedLimitField = new JTextField();

        public SpeedLimit(JPanel myPanel) {
            double frLimit = ((RealtimeControl)((Object)RealtimePanel.this.driver)).getFeedrateLimit();
            this.speedLimitField.setText("" + frLimit);
            this.speedLimitField.setSize(20, 220);
            this.speedLimitField.addFocusListener(this);
            myPanel.add((Component)new JLabel("Speed limit: "), "");
            myPanel.add((Component)this.speedLimitField, "flowy,wrap");
        }

        public Component getComponent() {
            return this.speedLimitField;
        }

        public void focusLost(FocusEvent e) {
            double limit = Double.parseDouble(((JTextField)e.getSource()).getText());
            Base.logger.info("Setting feedrate limit to " + limit);
            ((RealtimeControl)((Object)RealtimePanel.this.driver)).setFeedrateLimit(limit);
        }

        public void focusGained(FocusEvent e) {
        }
    }

    private class ControlSlider
    implements ActionListener,
    FocusListener,
    ChangeListener {
        final JSlider slider;
        final JTextField field;

        private ControlSlider(String labelText, String unitText, int minVal, int maxVal, int defaultVal, JPanel myParent) {
            JPanel sliderPanel = new JPanel();
            this.slider = new JSlider(0);
            this.field = new JTextField();
            sliderPanel.add(new JLabel(labelText));
            this.slider.setMinimum(minVal);
            this.slider.setMaximum(maxVal);
            this.slider.setValue(defaultVal);
            this.slider.addChangeListener(this);
            this.slider.setPaintLabels(true);
            this.slider.setPaintTicks(true);
            this.slider.setMajorTickSpacing(100);
            sliderPanel.add((Component)this.slider, "growx");
            this.field.setMinimumSize(new Dimension(75, 22));
            this.field.setEnabled(true);
            this.field.setText(Integer.toString(defaultVal));
            this.field.addFocusListener(this);
            this.field.addActionListener(this);
            sliderPanel.add((Component)this.field, "growx,wrap");
            sliderPanel.add((Component)new JLabel(unitText), "growx,wrap");
            myParent.add((Component)sliderPanel, "wrap");
        }

        public JSlider getSlider() {
            return this.slider;
        }

        public void actionPerformed(ActionEvent arg0) {
        }

        public void focusGained(FocusEvent arg0) {
        }

        public void focusLost(FocusEvent e) {
            try {
                Object s = e.getSource();
                if (s == this.field) {
                    int val = Integer.parseInt(this.field.getText());
                    this.slider.setValue(val);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void stateChanged(ChangeEvent e) {
            Object s = e.getSource();
            if (s instanceof JSlider) {
                int val = ((JSlider)s).getValue();
                this.field.setText(Integer.toString(val));
                if (s == RealtimePanel.this.feedrateControl.getSlider()) {
                    ((RealtimeControl)((Object)RealtimePanel.this.driver)).setFeedrateMultiplier((double)val / 100.0);
                } else if (s == RealtimePanel.this.extrusionControl.getSlider()) {
                    ((RealtimeControl)((Object)RealtimePanel.this.driver)).setExtrusionMultiplier((double)val / 100.0);
                } else if (s == RealtimePanel.this.travelFeedrateControl.getSlider()) {
                    ((RealtimeControl)((Object)RealtimePanel.this.driver)).setTravelFeedrateMultiplier((double)val / 100.0);
                }
            }
        }
    }
}

