/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJOpenDocumentHandler;
import com.apple.mrj.MRJPrefsHandler;
import com.apple.mrj.MRJQuitHandler;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.MRUList;
import replicatorg.app.MachineController;
import replicatorg.app.MachineFactory;
import replicatorg.app.exceptions.SerialException;
import replicatorg.app.syntax.JEditTextArea;
import replicatorg.app.syntax.PdeKeywords;
import replicatorg.app.syntax.PdeTextAreaDefaults;
import replicatorg.app.syntax.SyntaxDocument;
import replicatorg.app.syntax.TextAreaPainter;
import replicatorg.app.ui.BuildNamingDialog;
import replicatorg.app.ui.BuildSelectionDialog;
import replicatorg.app.ui.ControlPanelWindow;
import replicatorg.app.ui.EditorHeader;
import replicatorg.app.ui.ExtruderOnboardParameters;
import replicatorg.app.ui.FindReplace;
import replicatorg.app.ui.MachineOnboardParameters;
import replicatorg.app.ui.MachineStatusPanel;
import replicatorg.app.ui.MainButtonPanel;
import replicatorg.app.ui.MessagePanel;
import replicatorg.app.ui.PreferencesWindow;
import replicatorg.app.ui.RealtimePanel;
import replicatorg.app.ui.ToolheadIndexer;
import replicatorg.app.ui.modeling.PreviewPanel;
import replicatorg.app.util.PythonUtils;
import replicatorg.app.util.SwingPythonSelector;
import replicatorg.app.util.serial.Name;
import replicatorg.app.util.serial.Serial;
import replicatorg.drivers.EstimationDriver;
import replicatorg.drivers.MultiTool;
import replicatorg.drivers.OnboardParameters;
import replicatorg.drivers.RealtimeControl;
import replicatorg.drivers.SDCardCapture;
import replicatorg.drivers.UsesSerial;
import replicatorg.machine.MachineListener;
import replicatorg.machine.MachineProgressEvent;
import replicatorg.machine.MachineState;
import replicatorg.machine.MachineStateChangeEvent;
import replicatorg.machine.MachineToolStatusEvent;
import replicatorg.model.Build;
import replicatorg.model.BuildCode;
import replicatorg.model.BuildElement;
import replicatorg.model.BuildModel;
import replicatorg.model.JEditTextAreaSource;
import replicatorg.plugin.toolpath.ToolpathGenerator;
import replicatorg.plugin.toolpath.ToolpathGeneratorFactory;
import replicatorg.plugin.toolpath.ToolpathGeneratorThread;
import replicatorg.uploader.FirmwareUploader;

public class MainWindow
extends JFrame
implements MRJAboutHandler,
MRJQuitHandler,
MRJPrefsHandler,
MRJOpenDocumentHandler,
MachineListener,
ChangeListener,
ToolpathGenerator.GeneratorListener {
    private static final long serialVersionUID = 4144538738677712284L;
    static final String WINDOW_TITLE = "ReplicatorG - " + Base.VERSION_NAME;
    static final String MODEL_TAB_KEY = "MODEL";
    static final String GCODE_TAB_KEY = "GCODE";
    Image icon;
    MachineController machine;
    public static final KeyStroke WINDOW_CLOSE_KEYSTROKE = KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    static final int HANDLE_NEW = 1;
    static final int HANDLE_OPEN = 2;
    static final int HANDLE_QUIT = 3;
    int checkModifiedMode;
    String handleOpenPath;
    boolean handleNewShift;
    PageFormat pageFormat;
    PrinterJob printerJob;
    MainButtonPanel buttons;
    CardLayout cardLayout = new CardLayout();
    JPanel cardPanel = new JPanel(this.cardLayout);
    EditorHeader header = new EditorHeader(this);
    MachineStatusPanel machineStatusPanel;
    MessagePanel console;
    JSplitPane splitPane;
    JLabel lineNumberComponent;
    public Build build;
    public JEditTextArea textarea;
    public PreviewPanel previewPanel;
    public SimulationThread simulationThread;
    public EstimationThread estimationThread;
    JMenuItem saveMenuItem;
    JMenuItem saveAsMenuItem;
    JMenuItem stopItem;
    JMenuItem pauseItem;
    JMenuItem controlPanelItem;
    JMenuItem buildMenuItem;
    JMenu machineMenu;
    MachineMenuListener machineMenuListener;
    public boolean building;
    public boolean simulating;
    public boolean debugging;
    JMenuItem undoItem;
    JMenuItem redoItem;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    CompoundEdit compoundEdit;
    FindReplace find;
    private MRUList mruList;
    private JMenu serialMenu;
    private JMenu mruMenu;
    JMenuItem onboardParamsItem;
    JMenuItem extruderParamsItem;
    JMenuItem toolheadIndexingItem;
    JMenuItem realtimeControlItem;
    private Date buildStart;
    BuildElement currentElement;

    public void updateUndo() {
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
    }

    public Build getBuild() {
        return this.build;
    }

    private PreviewPanel getPreviewPanel() {
        if (this.previewPanel == null) {
            this.previewPanel = new PreviewPanel(this);
            this.cardPanel.add((Component)this.previewPanel, MODEL_TAB_KEY);
        }
        return this.previewPanel;
    }

    public MainWindow() {
        super(WINDOW_TITLE);
        this.header.setChangeListener(this);
        this.serialMenu = null;
        this.mruMenu = null;
        this.onboardParamsItem = new JMenuItem("Motherboard Onboard Preferences...");
        this.extruderParamsItem = new JMenuItem("Toolhead Onboard Preferences...");
        this.toolheadIndexingItem = new JMenuItem("Set Toolhead Index...");
        this.realtimeControlItem = new JMenuItem("Open real time controls window...");
        this.buildStart = null;
        this.setLocationByPlatform(true);
        MRJApplicationUtils.registerAboutHandler((MRJAboutHandler)this);
        MRJApplicationUtils.registerPrefsHandler((MRJPrefsHandler)this);
        MRJApplicationUtils.registerQuitHandler((MRJQuitHandler)this);
        MRJApplicationUtils.registerOpenDocumentHandler((MRJOpenDocumentHandler)this);
        PythonUtils.setSelector(new SwingPythonSelector(this));
        this.mruList = MRUList.getMRUList();
        this.icon = Base.getImage("images/icon.gif", this);
        this.setIconImage(this.icon);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainWindow.this.handleQuitInternal();
            }
        });
        this.setDefaultCloseOperation(0);
        JMenuBar menubar = new JMenuBar();
        menubar.add(this.buildFileMenu());
        menubar.add(this.buildEditMenu());
        menubar.add(this.buildGCodeMenu());
        menubar.add(this.buildMachineMenu());
        menubar.add(this.buildHelpMenu());
        this.setJMenuBar(menubar);
        Container pane = this.getContentPane();
        MigLayout layout = new MigLayout("nocache,fill,flowy,gap 0 0,ins 0");
        pane.setLayout((LayoutManager)layout);
        this.buttons = new MainButtonPanel(this);
        pane.add((Component)this.buttons, "growx,dock north");
        this.machineStatusPanel = new MachineStatusPanel();
        pane.add((Component)this.machineStatusPanel, "growx,dock north");
        pane.add((Component)this.header, "growx,dock north");
        this.textarea = new JEditTextArea(new PdeTextAreaDefaults());
        this.textarea.setRightClickPopup(new TextAreaPopup());
        this.textarea.setHorizontalOffset(6);
        this.cardPanel.add((Component)this.textarea, GCODE_TAB_KEY);
        this.console = new MessagePanel(this);
        this.console.setBorder(null);
        this.splitPane = new JSplitPane(0, this.cardPanel, this.console);
        this.splitPane.setResizeWeight(0.86);
        int dividerSize = Base.preferences.getInt("editor.divider.size", 5);
        if (dividerSize < 5) {
            dividerSize = 5;
        }
        if (dividerSize != 0) {
            this.splitPane.setDividerSize(dividerSize);
        }
        this.splitPane.setPreferredSize(new Dimension(600, 600));
        pane.add((Component)this.splitPane, "growx,growy,shrinkx,shrinky");
        this.pack();
        this.textarea.setTransferHandler(new TransferHandler(){
            private static final long serialVersionUID = 2093323078348794384L;

            public boolean canImport(JComponent dest, DataFlavor[] flavors) {
                return true;
            }

            public boolean importData(JComponent src, Transferable transferable) {
                DataFlavor[] flavors = transferable.getTransferDataFlavors();
                int successful = 0;
                for (int i = 0; i < flavors.length; ++i) {
                    try {
                        Object stuff = transferable.getTransferData(flavors[i]);
                        if (!(stuff instanceof List)) continue;
                        List list = (List)stuff;
                        for (int j = 0; j < list.size(); ++j) {
                            File file;
                            String filename;
                            Object item = list.get(j);
                            if (!(item instanceof File) || !(filename = (file = (File)item).getName()).endsWith(".gcode") && !filename.endsWith(".ngc")) continue;
                            MainWindow.this.handleOpenFile(file);
                            return true;
                        }
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                if (successful == 0) {
                    MainWindow.this.error("No files were added to the sketch.");
                } else if (successful == 1) {
                    MainWindow.this.message("One file added to the sketch.");
                } else {
                    MainWindow.this.message(successful + " files added to the sketch.");
                }
                return true;
            }
        });
    }

    public void restorePreferences() {
        if (Base.openedAtStartup != null) {
            this.handleOpen2(Base.openedAtStartup);
        } else {
            String prefName = "replicatorg.initialopenbehavior";
            int ordinal = Base.preferences.getInt("replicatorg.initialopenbehavior", Base.InitialOpenBehavior.OPEN_LAST.ordinal());
            Base.InitialOpenBehavior openBehavior = Base.InitialOpenBehavior.values()[ordinal];
            if (openBehavior == Base.InitialOpenBehavior.OPEN_NEW) {
                this.handleNew2(true);
            } else {
                Iterator<String> i = this.mruList.iterator();
                if (i.hasNext()) {
                    String lastOpened = i.next();
                    if (new File(lastOpened).exists()) {
                        this.handleOpen2(lastOpened);
                    } else {
                        this.handleNew2(true);
                    }
                } else {
                    this.handleNew2(true);
                }
            }
        }
        this.applyPreferences();
    }

    public void applyPreferences() {
        boolean external = Base.preferences.getBoolean("editor.external", false);
        this.textarea.setEditable(!external);
        this.saveMenuItem.setEnabled(!external);
        this.saveAsMenuItem.setEnabled(!external);
        TextAreaPainter painter = this.textarea.getPainter();
        if (external) {
            Color color = Base.getColorPref("editor.external.bgcolor", "#168299");
            painter.setBackground(color);
            painter.setLineHighlightEnabled(false);
            this.textarea.setCaretVisible(false);
        } else {
            Color color = Base.getColorPref("editor.bgcolor", "#ffffff");
            painter.setBackground(color);
            boolean highlight = Base.preferences.getBoolean("editor.linehighlight", true);
            painter.setLineHighlightEnabled(highlight);
            this.textarea.setCaretVisible(true);
        }
        painter.setFont(Base.getFontPref("editor.font", "Monospaced,plain,10"));
    }

    public void storePreferences() {
        String lastPath;
        Rectangle bounds = this.getBounds();
        Base.preferences.putInt("last.window.x", bounds.x);
        Base.preferences.putInt("last.window.y", bounds.y);
        Base.preferences.putInt("last.window.width", bounds.width);
        Base.preferences.putInt("last.window.height", bounds.height);
        if (this.build != null && (lastPath = this.build.getMainFilePath()) != null) {
            Base.preferences.put("last.sketch.path", this.build.getMainFilePath());
        }
        int location = this.splitPane.getDividerLocation();
        Base.preferences.putInt("last.divider.location", location);
        try {
            Base.preferences.flush();
        }
        catch (BackingStoreException bse) {
            bse.printStackTrace();
        }
    }

    public void runToolpathGenerator() {
        if (this.build.getModel().isModified()) {
            String message = "<html>You have made changes to this model.  Any unsaved changes will<br>not be reflected in the generated toolpath.<br>Save the model now?</html>";
            int option = JOptionPane.showConfirmDialog(this, "<html>You have made changes to this model.  Any unsaved changes will<br>not be reflected in the generated toolpath.<br>Save the model now?</html>", "Save model?", 1, 3);
            if (option == 2) {
                return;
            }
            if (option == 0) {
                this.handleSave(true);
            }
        }
        ToolpathGenerator generator = ToolpathGeneratorFactory.createSelectedGenerator();
        ToolpathGeneratorThread tgt = new ToolpathGeneratorThread(this, generator, this.build);
        tgt.addListener(this);
        tgt.start();
    }

    private void reloadSerialMenu() {
        JMenuItem item;
        if (this.serialMenu == null) {
            return;
        }
        this.serialMenu.removeAll();
        if (this.machine == null) {
            JMenuItem item2 = new JMenuItem("No machine selected.");
            item2.setEnabled(false);
            this.serialMenu.add(item2);
            return;
        }
        if (!(this.machine.driver instanceof UsesSerial)) {
            JMenuItem item3 = new JMenuItem("Currently selected machine does not use a serial port.");
            item3.setEnabled(false);
            this.serialMenu.add(item3);
            return;
        }
        String currentName = null;
        UsesSerial us = (UsesSerial)((Object)this.machine.driver);
        currentName = us.getSerial() != null ? us.getSerial().getName() : Base.preferences.get("serial.last_selected", null);
        Vector<Name> names = Serial.scanSerialNames();
        Collections.sort(names);
        ButtonGroup radiogroup = new ButtonGroup();
        for (Name name : names) {
            JRadioButtonMenuItem item4 = new JRadioButtonMenuItem(name.toString());
            item4.setEnabled(name.isAvailable());
            item4.setSelected(name.getName().equals(currentName));
            final String portName = name.getName();
            item4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Thread t = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            block5: {
                                try {
                                    UsesSerial us = (UsesSerial)((Object)MainWindow.this.machine.driver);
                                    if (us == null) break block5;
                                    UsesSerial usesSerial = us;
                                    synchronized (usesSerial) {
                                        us.setSerial(new Serial(portName, us));
                                        Base.preferences.put("serial.last_selected", portName);
                                        MainWindow.this.machine.reset();
                                    }
                                }
                                catch (SerialException se) {
                                    se.printStackTrace();
                                }
                            }
                        }
                    };
                    t.start();
                }
            });
            radiogroup.add(item4);
            this.serialMenu.add(item4);
        }
        if (names.isEmpty()) {
            item = new JMenuItem("No serial ports detected");
            item.setEnabled(false);
            this.serialMenu.add(item);
        }
        this.serialMenu.addSeparator();
        item = new JMenuItem("Rescan serial ports");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.reloadSerialMenu();
            }
        });
        this.serialMenu.add(item);
    }

    private void reloadMruMenu() {
        if (this.mruMenu == null) {
            return;
        }
        this.mruMenu.removeAll();
        if (this.mruList != null) {
            int index = 0;
            for (String fileName : this.mruList) {
                String entry = Integer.toString(index) + ". " + fileName.substring(fileName.lastIndexOf(47) + 1);
                JMenuItem item = new JMenuItem(entry, 48 + index);
                item.addActionListener(new FileOpenActionListener(fileName));
                this.mruMenu.add(item);
                if (++index < 9) continue;
                break;
            }
        }
    }

    protected JMenu buildFileMenu() {
        JMenu menu = new JMenu("File");
        JMenuItem item = MainWindow.newJMenuItem("New", 78);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.handleNew(false);
            }
        });
        menu.add(item);
        item = MainWindow.newJMenuItem("Open...", 79, false);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.handleOpen(null);
            }
        });
        menu.add(item);
        this.saveMenuItem = MainWindow.newJMenuItem("Save", 83);
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.handleSave(false);
            }
        });
        menu.add(this.saveMenuItem);
        this.saveAsMenuItem = MainWindow.newJMenuItem("Save As...", 83, true);
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.handleSaveAs();
            }
        });
        menu.add(this.saveAsMenuItem);
        menu.addSeparator();
        this.mruMenu = new JMenu("Recent");
        this.reloadMruMenu();
        menu.add(this.mruMenu);
        menu.addSeparator();
        menu.add(this.buildExamplesMenu());
        menu.add(this.buildScriptsMenu());
        menu.addSeparator();
        if (!Base.isMacOS()) {
            item = MainWindow.newJMenuItem("Preferences", 44);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainWindow.this.handlePrefs();
                }
            });
            menu.add(item);
            menu.addSeparator();
            item = MainWindow.newJMenuItem("Quit", 81);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainWindow.this.handleQuitInternal();
                }
            });
            menu.add(item);
        }
        return menu;
    }

    private JMenuItem buildMenuFromPath(File path, Pattern pattern) {
        if (!path.exists()) {
            return null;
        }
        if (path.isDirectory()) {
            File[] files = path.listFiles();
            Vector<JMenuItem> items = new Vector<JMenuItem>();
            for (File f : files) {
                JMenuItem i = this.buildMenuFromPath(f, pattern);
                if (i == null) continue;
                items.add(i);
            }
            Collections.sort(items, new Comparator<JMenuItem>(){

                @Override
                public int compare(JMenuItem o1, JMenuItem o2) {
                    if (o1 instanceof JMenu) {
                        if (!(o2 instanceof JMenu)) {
                            return 1;
                        }
                    } else if (o2 instanceof JMenu) {
                        return -1;
                    }
                    return o1.getText().compareTo(o2.getText());
                }
            });
            if (items.size() == 0) {
                return null;
            }
            JMenu menu = new JMenu(path.getName());
            for (JMenuItem i : items) {
                menu.add(i);
            }
            return menu;
        }
        Matcher m = pattern.matcher(path.getName());
        if (m.matches()) {
            try {
                FileOpenActionListener l = new FileOpenActionListener(path.getCanonicalPath());
                JMenuItem item = new JMenuItem(path.getName());
                item.addActionListener(l);
                return item;
            }
            catch (IOException ioe) {
                return null;
            }
        }
        return null;
    }

    private JMenuItem buildExamplesMenu() {
        Pattern p;
        File examplesDir = Base.getApplicationFile("examples");
        JMenuItem m = this.buildMenuFromPath(examplesDir, p = Pattern.compile("[^\\.]*\\.[sS][tT][lL]$"));
        if (m == null) {
            JMenu m2 = new JMenu("Examples");
            ((Container)m2).add(new JMenuItem("No example dirs found."));
            ((Container)m2).add(new JMenuItem("Check if this dir exists:" + Base.getApplicationFile("examples")));
            return m2;
        }
        m.setText("Examples");
        return m;
    }

    private JMenuItem buildScriptsMenu() {
        Pattern p;
        File examplesDir = Base.getApplicationFile("scripts");
        JMenuItem m = this.buildMenuFromPath(examplesDir, p = Pattern.compile("[^\\.]*\\.[gG][cC][oO][dD][eE]$"));
        if (m == null) {
            JMenu m2 = new JMenu("Scripts");
            ((Container)m2).add(new JMenuItem("No scripts found."));
            ((Container)m2).add(new JMenuItem("Check if this dir exists:" + Base.getApplicationFile("scripts")));
            return m2;
        }
        m.setText("Scripts");
        return m;
    }

    protected JMenu buildGCodeMenu() {
        JMenu menu = new JMenu("GCode");
        JMenuItem item = MainWindow.newJMenuItem("Estimate", 69);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.handleEstimate();
            }
        });
        menu.add(item);
        item = MainWindow.newJMenuItem("Simulate", 76);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.handleSimulate();
            }
        });
        menu.add(item);
        this.buildMenuItem = MainWindow.newJMenuItem("Build", 66);
        this.buildMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.handleBuild();
            }
        });
        menu.add(this.buildMenuItem);
        this.pauseItem = MainWindow.newJMenuItem("Pause", 69);
        this.pauseItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.handlePause();
            }
        });
        this.pauseItem.setEnabled(false);
        menu.add(this.pauseItem);
        this.stopItem = MainWindow.newJMenuItem("Stop", 46);
        this.stopItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.handleStop();
            }
        });
        this.stopItem.setEnabled(false);
        menu.add(this.stopItem);
        JMenu genMenu = new JMenu("Choose GCode generator");
        Vector<ToolpathGeneratorFactory.ToolpathGeneratorDescriptor> generators = ToolpathGeneratorFactory.getGeneratorList();
        String name = ToolpathGeneratorFactory.getSelectedName();
        ButtonGroup group = new ButtonGroup();
        for (ToolpathGeneratorFactory.ToolpathGeneratorDescriptor tgd : generators) {
            JRadioButtonMenuItem i = new JRadioButtonMenuItem(tgd.name);
            group.add(i);
            final String n = tgd.name;
            i.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ToolpathGeneratorFactory.setSelectedName(n);
                }
            });
            if (name.equals(tgd.name)) {
                i.setSelected(true);
            }
            genMenu.add(i);
        }
        menu.add(genMenu);
        return menu;
    }

    protected JMenu buildMachineMenu() {
        JMenu menu = new JMenu("Machine");
        this.machineMenu = new JMenu("Driver");
        this.populateMachineMenu();
        menu.add(this.machineMenu);
        menu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                MainWindow.this.populateMachineMenu();
            }
        });
        this.machineMenuListener = new MachineMenuListener();
        this.serialMenu = new JMenu("Serial Port");
        this.reloadSerialMenu();
        menu.add(this.serialMenu);
        this.controlPanelItem = new JMenuItem("Control Panel", 67);
        this.controlPanelItem.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.controlPanelItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.handleControlPanel();
            }
        });
        menu.add(this.controlPanelItem);
        this.onboardParamsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MainWindow.this.handleOnboardPrefs();
            }
        });
        this.onboardParamsItem.setVisible(false);
        menu.add(this.onboardParamsItem);
        this.extruderParamsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MainWindow.this.handleExtruderPrefs();
            }
        });
        this.extruderParamsItem.setVisible(false);
        menu.add(this.extruderParamsItem);
        this.toolheadIndexingItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MainWindow.this.handleToolheadIndexing();
            }
        });
        this.toolheadIndexingItem.setVisible(false);
        menu.add(this.toolheadIndexingItem);
        this.realtimeControlItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MainWindow.this.handleRealTimeControl();
            }
        });
        if (this.machine != null && this.machine.driver instanceof RealtimeControl) {
            this.realtimeControlItem.setVisible(false);
            menu.add(this.realtimeControlItem);
        }
        JMenuItem item = new JMenuItem("Upload new firmware...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FirmwareUploader.startUploader(MainWindow.this);
            }
        });
        menu.add(item);
        return menu;
    }

    protected void handleToolheadIndexing() {
        if (this.machine == null || !(this.machine.driver instanceof MultiTool)) {
            JOptionPane.showMessageDialog(this, "ReplicatorG can't connect to your machine or toolhead index setting is not supported.\nTry checking your settings and resetting your machine.", "Can't run toolhead indexing", 0);
        } else {
            ToolheadIndexer indexer = new ToolheadIndexer((Frame)this, this.machine.driver);
            indexer.setVisible(true);
        }
    }

    public boolean supportsRealTimeControl() {
        if (this.machine == null || !(this.machine.driver instanceof RealtimeControl)) {
            return false;
        }
        Base.logger.info("Supports RC");
        return true;
    }

    protected void handleRealTimeControl() {
        if (!this.supportsRealTimeControl()) {
            JOptionPane.showMessageDialog(this, "Real time control is not supported for your machine's driver.", "Can't enabled real time control", 0);
        } else {
            RealtimePanel window = RealtimePanel.getRealtimePanel(this.machine);
            if (window != null) {
                window.pack();
                window.setVisible(true);
                window.toFront();
            }
        }
    }

    protected void populateMachineMenu() {
        this.machineMenu.removeAll();
        boolean empty = true;
        try {
            for (String name : MachineFactory.getMachineNames()) {
                JCheckBoxMenuItem rbMenuItem = new JCheckBoxMenuItem(name, name.equals(Base.preferences.get("machine.name", null)));
                rbMenuItem.addActionListener(this.machineMenuListener);
                this.machineMenu.add(rbMenuItem);
                empty = false;
            }
            if (!empty) {
                this.machineMenu.setEnabled(true);
            }
        }
        catch (Exception exception) {
            System.out.println("error retrieving machine list");
            exception.printStackTrace();
        }
        if (this.machineMenu.getItemCount() == 0) {
            this.machineMenu.setEnabled(false);
        }
    }

    protected JMenu buildHelpMenu() {
        JMenuItem item;
        JMenu menu = new JMenu("Help");
        if (!Base.isLinux()) {
            item = MainWindow.newJMenuItem("Getting Started", 49);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Base.openURL("http://www.replicat.org/getting-started");
                }
            });
            menu.add(item);
        }
        item = MainWindow.newJMenuItem("Hardware Setup", 50);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openURL("http://www.replicat.org/hardware");
            }
        });
        menu.add(item);
        item = MainWindow.newJMenuItem("Troubleshooting", 51);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openURL("http://www.replicat.org/troubleshooting");
            }
        });
        menu.add(item);
        item = MainWindow.newJMenuItem("Reference", 52);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openURL("http://www.replicat.org/reference");
            }
        });
        menu.add(item);
        item = MainWindow.newJMenuItem("Frequently Asked Questions", 53);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openURL("http://www.replicat.org/faq");
            }
        });
        menu.add(item);
        item = MainWindow.newJMenuItem("Visit Replicat.orG", 54);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openURL("http://www.replicat.org/");
            }
        });
        menu.add(item);
        menu.addSeparator();
        JMenuItem aboutitem = new JMenuItem("About ReplicatorG");
        aboutitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.handleAbout();
            }
        });
        menu.add(aboutitem);
        return menu;
    }

    public JMenu buildEditMenu() {
        JMenu menu = new JMenu("Edit");
        this.undoItem = MainWindow.newJMenuItem("Undo", 90);
        this.undoAction = new UndoAction();
        this.undoItem.addActionListener(this.undoAction);
        menu.add(this.undoItem);
        this.redoItem = MainWindow.newJMenuItem("Redo", 89);
        this.redoAction = new RedoAction();
        this.redoItem.addActionListener(this.redoAction);
        menu.add(this.redoItem);
        menu.addSeparator();
        JMenuItem item = MainWindow.newJMenuItem("Cut", 88);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.textarea.cut();
                MainWindow.this.build.getCode().setModified(true);
            }
        });
        menu.add(item);
        item = MainWindow.newJMenuItem("Copy", 67);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.textarea.copy();
            }
        });
        menu.add(item);
        item = MainWindow.newJMenuItem("Paste", 86);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.textarea.paste();
                MainWindow.this.build.getCode().setModified(true);
            }
        });
        menu.add(item);
        item = MainWindow.newJMenuItem("Select All", 65);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.textarea.selectAll();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = MainWindow.newJMenuItem("Find...", 70);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MainWindow.this.find == null) {
                    MainWindow.this.find = new FindReplace(MainWindow.this);
                }
                MainWindow.this.find.setVisible(true);
            }
        });
        menu.add(item);
        item = MainWindow.newJMenuItem("Find Next", 71);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MainWindow.this.find != null) {
                    MainWindow.this.find.find(true);
                }
            }
        });
        menu.add(item);
        return menu;
    }

    public static JMenuItem newJMenuItem(String title, int what) {
        return MainWindow.newJMenuItem(title, what, false);
    }

    public static JMenuItem newJMenuItem(String title, int what, boolean shift) {
        JMenuItem menuItem = new JMenuItem(title);
        int modifiers = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (shift) {
            modifiers |= 1;
        }
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, modifiers));
        return menuItem;
    }

    public void handleAbout() {
        final BufferedImage image = Base.getImage("images/about.png", this);
        int w = ((Image)image).getWidth(this);
        int h = ((Image)image).getHeight(this);
        final Window window = new Window(this){

            public void paint(Graphics g) {
                g.drawImage(image, 0, 0, null);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g.setFont(new Font("SansSerif", 0, 13));
                g.setColor(Color.black);
                FontMetrics fm = g.getFontMetrics();
                String version = Base.VERSION_NAME;
                Rectangle2D r = fm.getStringBounds(version, g);
                g.drawString(version, (int)(364.0 - r.getWidth()), (int)(95.0 - r.getMinY()));
                AttributedString text = new AttributedString("\u00a9 2008, 2009, 2010 by Zach Smith, Adam Mayer, and numerous contributors. See Contributors.txt for a full list.  \n\rThis program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.");
                AttributedCharacterIterator iterator = text.getIterator();
                FontRenderContext frc = g2.getFontRenderContext();
                LineBreakMeasurer measurer = new LineBreakMeasurer(text.getIterator(), frc);
                measurer.setPosition(iterator.getBeginIndex());
                int margins = 32;
                float wrappingWidth = image.getWidth(this) - 64;
                float x = 32.0f;
                float y = 140.0f;
                while (measurer.getPosition() < iterator.getEndIndex()) {
                    TextLayout layout = measurer.nextLayout(wrappingWidth);
                    layout.draw(g2, x, y += layout.getAscent());
                    y += layout.getDescent() + layout.getLeading();
                }
            }
        };
        window.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                window.dispose();
            }
        });
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        window.setBounds((screen.width - w) / 2, (screen.height - h) / 2, w, h);
        window.setVisible(true);
    }

    public void handleControlPanel() {
        if (this.machine == null) {
            JOptionPane.showMessageDialog(this, "ReplicatorG can't connect to your machine.\nTry checking your settings and resetting your machine.", "Can't find machine", 0);
        } else {
            ControlPanelWindow window = ControlPanelWindow.getControlPanel(this.machine);
            if (window != null) {
                window.pack();
                window.setVisible(true);
                window.toFront();
            }
        }
    }

    public void handleDisconnect() {
        if (this.machine != null) {
            this.machine.disconnect();
        }
    }

    public void handleConnect() {
        String name;
        if ((this.machine == null || this.machine.getMachineState().getState() == MachineState.State.NOT_ATTACHED) && (name = Base.preferences.get("machine.name", null)) != null) {
            this.loadMachine(name, true);
        }
    }

    public void handleOnboardPrefs() {
        if (this.machine == null || !(this.machine.driver instanceof OnboardParameters)) {
            JOptionPane.showMessageDialog(this, "ReplicatorG can't connect to your machine or onboard preferences are not supported.\nTry checking your settings and resetting your machine.", "Can't run onboard prefs", 0);
        } else {
            MachineOnboardParameters moo = new MachineOnboardParameters((OnboardParameters)((Object)this.machine.driver), this.machine.driver);
            moo.setVisible(true);
        }
    }

    public void handleExtruderPrefs() {
        if (this.machine == null || !(this.machine.driver instanceof OnboardParameters)) {
            JOptionPane.showMessageDialog(this, "ReplicatorG can't connect to your machine or onboard preferences are not supported.\nTry checking your settings and resetting your machine.", "Can't run onboard prefs", 0);
        } else {
            ExtruderOnboardParameters eop = new ExtruderOnboardParameters((OnboardParameters)((Object)this.machine.driver));
            eop.setVisible(true);
        }
    }

    public void handlePrefs() {
        PreferencesWindow preferences = new PreferencesWindow();
        preferences.showFrame(this);
    }

    public String getText() {
        return this.textarea.getText();
    }

    public void setText(String what, int selectionStart, int selectionEnd) {
        this.beginCompoundEdit();
        this.textarea.setText(what);
        this.endCompoundEdit();
        selectionStart = Math.max(0, Math.min(selectionStart, this.textarea.getDocumentLength()));
        selectionEnd = Math.max(0, Math.min(selectionStart, this.textarea.getDocumentLength()));
        this.textarea.select(selectionStart, selectionEnd);
        this.textarea.requestFocus();
    }

    public void setCode(BuildCode code) {
        if (code == null) {
            return;
        }
        if (code.document == null) {
            code.document = new SyntaxDocument();
            code.document.setTokenMarker(new PdeKeywords());
            try {
                code.document.insertString(0, code.program, null);
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
            }
            final UndoManager undo = code.getUndoManager();
            code.document.addUndoableEditListener(new UndoableEditListener(){

                public void undoableEditHappened(UndoableEditEvent e) {
                    if (MainWindow.this.compoundEdit != null) {
                        MainWindow.this.compoundEdit.addEdit(e.getEdit());
                    } else if (undo != null) {
                        undo.addEdit(e.getEdit());
                        MainWindow.this.updateUndo();
                    }
                }
            });
        }
        this.textarea.setDocument(code.document, code.selectionStart, code.selectionStop, code.scrollPosition);
        this.textarea.requestFocus();
    }

    public void setModel(BuildModel model) {
        if (model != null) {
            this.getPreviewPanel().setModel(model);
        }
    }

    public void beginCompoundEdit() {
        this.compoundEdit = new CompoundEdit();
    }

    public void endCompoundEdit() {
        this.compoundEdit.end();
        this.currentElement.getUndoManager().addEdit(this.compoundEdit);
        this.updateUndo();
        this.compoundEdit = null;
    }

    public void handleEstimate() {
        if (this.building) {
            return;
        }
        if (this.simulating) {
            return;
        }
        this.estimationThread = new EstimationThread(this);
        this.estimationThread.start();
    }

    public void handleSimulate() {
        if (this.building) {
            return;
        }
        if (this.simulating) {
            return;
        }
        this.simulating = true;
        this.setEditorBusy(true);
        this.simulationThread = new SimulationThread(this);
        this.simulationThread.start();
    }

    public void simulationOver() {
        this.message("Done simulating.");
        this.simulating = false;
        this.setEditorBusy(false);
    }

    public void handleBuild() {
        if (this.building) {
            return;
        }
        if (this.simulating) {
            return;
        }
        if (this.machine == null) {
            Base.logger.severe("Not ready to build yet.");
        } else {
            this.doStop();
            this.building = true;
            this.setEditorBusy(true);
            this.message("Building...");
            this.buildStart = new Date();
            this.machine.execute();
        }
    }

    public void handleUpload() {
        if (this.building) {
            return;
        }
        if (this.simulating) {
            return;
        }
        if (this.machine == null || this.machine.driver == null || !(this.machine.driver instanceof SDCardCapture)) {
            Base.logger.severe("Not ready to build yet.");
        } else {
            BuildNamingDialog bsd = new BuildNamingDialog((Frame)this, this.build.getName());
            bsd.setVisible(true);
            String path = bsd.getPath();
            if (path != null) {
                this.building = true;
                this.setEditorBusy(true);
                this.message("Uploading...");
                this.buildStart = new Date();
                this.machine.upload(path);
            }
        }
    }

    private String selectOutputFile(String defaultName) {
        File directory = null;
        String loadDir = Base.preferences.get("ui.open_output_dir", null);
        if (loadDir != null) {
            directory = new File(loadDir);
        }
        JFileChooser fc = new JFileChooser(directory);
        fc.setFileFilter(new ExtensionFilter(".s3g", "Makerbot build file"));
        fc.setDialogTitle("Save Makerbot build as...");
        fc.setDialogType(1);
        fc.setFileHidingEnabled(false);
        fc.setSelectedFile(new File(directory, defaultName));
        int rv = fc.showSaveDialog(this);
        if (rv == 0) {
            fc.getSelectedFile().getName();
            Base.preferences.put("ui.open_output_dir", fc.getCurrentDirectory().getAbsolutePath());
            return fc.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public void handleBuildToFile() {
        if (this.building) {
            return;
        }
        if (this.simulating) {
            return;
        }
        if (this.machine == null || this.machine.driver == null || !(this.machine.driver instanceof SDCardCapture)) {
            Base.logger.severe("Not ready to build yet.");
        } else {
            String sourceName = this.build.getName() + ".s3g";
            String path = this.selectOutputFile(sourceName);
            if (path != null) {
                this.building = true;
                this.setEditorBusy(true);
                this.buildStart = new Date();
                this.machine.buildToFile(path);
            }
        }
    }

    public void handlePlayback() {
        if (this.building) {
            return;
        }
        if (this.simulating) {
            return;
        }
        if (this.machine == null || this.machine.driver == null || !(this.machine.driver instanceof SDCardCapture)) {
            Base.logger.severe("Not ready to build yet.");
        } else {
            SDCardCapture sdcc = (SDCardCapture)((Object)this.machine.driver);
            List<String> files = sdcc.getFileList();
            BuildSelectionDialog bsd = new BuildSelectionDialog((Frame)this, files);
            bsd.setVisible(true);
            String path = bsd.getSelectedPath();
            Base.logger.info("Selected path is " + path);
            if (path != null) {
                this.building = true;
                this.setEditorBusy(true);
                this.message("Building...");
                this.buildStart = new Date();
                this.machine.buildRemote(path);
            }
        }
    }

    public void machineStateChanged(MachineStateChangeEvent evt) {
        boolean showParams;
        boolean hasGcode;
        if (Base.logger.isLoggable(Level.FINE)) {
            Base.logger.finest("Machine state changed to " + (Object)((Object)evt.getState().getState()));
        }
        boolean bl = hasGcode = this.getBuild().getCode() != null;
        if (this.building) {
            if (evt.getState().isReady() || evt.getState().getState() == MachineState.State.STOPPING) {
                final MachineState endState = evt.getState();
                this.building = false;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (endState.isReady()) {
                            MainWindow.this.notifyBuildComplete(MainWindow.this.buildStart, new Date());
                        } else {
                            MainWindow.this.notifyBuildAborted(MainWindow.this.buildStart, new Date());
                        }
                        MainWindow.this.buildingOver();
                    }
                });
            } else if (evt.getState().getState() == MachineState.State.NOT_ATTACHED) {
                this.building = false;
            }
        }
        if (evt.getState().isReady()) {
            this.reloadSerialMenu();
        }
        boolean bl2 = showParams = evt.getState().isReady() && this.machine != null && this.machine.getDriver() instanceof OnboardParameters && ((OnboardParameters)((Object)this.machine.getDriver())).hasFeatureOnboardParameters();
        if (Base.logger.isLoggable(Level.FINE) && !showParams) {
            String cause = new String();
            if (evt.getState().isReady()) {
                if (this.machine == null) {
                    cause = cause + "[no machine] ";
                } else if (!(this.machine.getDriver() instanceof OnboardParameters)) {
                    cause = cause + "[driver doesn't implement onboard parameters] ";
                } else if (!this.machine.getDriver().isInitialized()) {
                    cause = cause + "[machine not initialized] ";
                } else if (!((OnboardParameters)((Object)this.machine.getDriver())).hasFeatureOnboardParameters()) {
                    cause = cause + "[firmware doesn't support onboard parameters]";
                }
                Base.logger.finest("Couldn't show onboard parameters: " + cause);
            }
        }
        this.controlPanelItem.setEnabled(evt.getState().isReady());
        this.buildMenuItem.setEnabled(hasGcode && evt.getState().isReady());
        this.onboardParamsItem.setVisible(showParams);
        this.extruderParamsItem.setVisible(showParams);
        boolean showIndexing = evt.getState().isReady() && this.machine != null && this.machine.getDriver() instanceof MultiTool && ((MultiTool)((Object)this.machine.getDriver())).toolsCanBeReindexed();
        this.toolheadIndexingItem.setVisible(showIndexing);
        boolean showRealtimeTuning = evt.getState().isReady() && this.machine != null && this.machine.getDriver() instanceof RealtimeControl && ((RealtimeControl)((Object)this.machine.getDriver())).hasFeatureRealtimeControl();
        this.realtimeControlItem.setVisible(showRealtimeTuning);
        this.realtimeControlItem.setEnabled(showRealtimeTuning);
        String name = "Not Connected";
        if (evt.getState().isConnected() && this.machine != null) {
            name = this.machine.getName();
        }
        if (name != null) {
            this.setTitle(name + " - " + WINDOW_TITLE);
        } else {
            this.setTitle(WINDOW_TITLE);
        }
    }

    public void setEditorBusy(boolean isBusy) {
        this.stopItem.setEnabled(isBusy);
        this.pauseItem.setEnabled(isBusy);
        if (isBusy && Base.preferences.getBoolean("console.auto_clear", true)) {
            this.console.clear();
        }
        this.setVisible(true);
        this.textarea.setEnabled(!isBusy);
        this.textarea.setEditable(!isBusy);
        if (isBusy) {
            this.textarea.selectNone();
            this.textarea.scrollTo(0, 0);
        }
    }

    private void notifyBuildComplete(Date started, Date finished) {
        assert (started != null);
        assert (finished != null);
        long elapsed = finished.getTime() - started.getTime();
        String message = "Build finished.\n\n";
        message = message + "Completed in " + EstimationDriver.getBuildTimeString(elapsed);
        Base.showMessage("Build finished", message);
    }

    private void notifyBuildAborted(Date started, Date aborted) {
        assert (started != null);
        assert (aborted != null);
        long elapsed = aborted.getTime() - started.getTime();
        String message = "Build aborted.\n\n";
        message = message + "Stopped after " + EstimationDriver.getBuildTimeString(elapsed);
        int atWhichLine = this.machine.getLinesProcessed();
        this.highlightLine(atWhichLine);
        Base.showMessage("Build aborted (line " + atWhichLine + ")", message);
    }

    public void buildingOver() {
        this.message("Done building.");
        this.textarea.setEnabled(true);
        this.building = false;
        if (this.machine != null && this.machine.getSimulatorDriver() != null) {
            this.machine.getSimulatorDriver().destroyWindow();
        }
        this.setEditorBusy(false);
    }

    public void handleStop() {
        this.doStop();
        this.setEditorBusy(false);
    }

    public void estimationOver() {
    }

    public void doStop() {
        if (this.machine != null) {
            this.machine.stop();
        }
        this.building = false;
        this.simulating = false;
    }

    public void handleReset() {
        if (this.machine != null) {
            this.machine.reset();
        }
    }

    public void handlePause() {
        this.doPause();
    }

    public void doPause() {
        if (this.machine.isPaused()) {
            this.machine.unpause();
            if (this.simulating) {
                this.message("Simulating...");
            } else if (this.building) {
                this.message("Building...");
            }
        } else {
            this.machine.pause();
            int atWhichLine = this.machine.getLinesProcessed();
            this.highlightLine(atWhichLine);
            this.message("Paused at line " + atWhichLine + ".");
        }
    }

    protected void checkModified(int checkModifiedMode) {
        this.checkModifiedMode = checkModifiedMode;
        if (this.build == null || !this.build.hasModifiedElements()) {
            this.checkModified2();
            return;
        }
        String prompt = "Save changes to " + this.build.getName() + "?  ";
        if (!Base.isMacOS() || Base.javaVersion < 1.5f) {
            int result = JOptionPane.showConfirmDialog(this, prompt, "Quit", 1, 3);
            if (result == 0) {
                this.handleSave(true);
                this.checkModified2();
            } else if (result == 1) {
                this.checkModified2();
            }
        } else {
            JOptionPane pane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>Do you want to save changes to this sketch<BR> before closing?</b><p>If you don't save, your changes will be lost.", 3);
            Object[] options = new String[]{"Save", "Cancel", "Don't Save"};
            pane.setOptions(options);
            pane.setInitialValue(options[0]);
            pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
            JDialog dialog = pane.createDialog(this, null);
            dialog.setVisible(true);
            Object result = pane.getValue();
            if (result == options[0]) {
                this.handleSave(true);
                this.checkModified2();
            } else if (result == options[2]) {
                this.checkModified2();
            }
        }
    }

    protected boolean confirmBuildAbort() {
        if (this.machine != null && this.machine.getMachineState().getState() == MachineState.State.BUILDING) {
            String message = "<html>You are currently printing from ReplicatorG! Your build will be stopped.<br>Continue and abort print?</html>";
            int option = JOptionPane.showConfirmDialog(this, "<html>You are currently printing from ReplicatorG! Your build will be stopped.<br>Continue and abort print?</html>", "Abort print?", 2, 3);
            if (option == 2) {
                return false;
            }
        }
        return true;
    }

    public void checkModified2() {
        if (!this.confirmBuildAbort()) {
            return;
        }
        this.doStop();
        switch (this.checkModifiedMode) {
            case 1: {
                this.handleNew2(false);
                break;
            }
            case 2: {
                this.handleOpen2(this.handleOpenPath);
                break;
            }
            case 3: {
                System.exit(0);
            }
        }
        this.checkModifiedMode = 0;
    }

    public void handleNew(final boolean shift) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainWindow.this.handleNewShift = shift;
                MainWindow.this.checkModified(1);
            }
        });
    }

    public void handleNewUnchecked() {
        this.handleNewShift = false;
        this.handleNew2(true);
    }

    protected void handleNew2(boolean noPrompt) {
        this.handleOpen2(null);
    }

    public void handleOpenFile(File file) {
        this.handleOpen(file.getAbsolutePath());
    }

    private String selectFile() {
        File directory = null;
        String loadDir = Base.preferences.get("ui.open_dir", null);
        if (loadDir != null) {
            directory = new File(loadDir);
        }
        JFileChooser fc = new JFileChooser(directory);
        String[] extensions = new String[]{".gcode", ".ngc", ".stl"};
        ExtensionFilter defaultFilter = new ExtensionFilter(extensions, "GCode or STL files");
        fc.addChoosableFileFilter(defaultFilter);
        String[] gcodeExtensions = new String[]{".gcode", ".ngc"};
        fc.addChoosableFileFilter(new ExtensionFilter(gcodeExtensions, "GCode files"));
        fc.addChoosableFileFilter(new ExtensionFilter(".stl", "STL files"));
        fc.addChoosableFileFilter(new ExtensionFilter(".obj", "OBJ files (experimental)"));
        fc.addChoosableFileFilter(new ExtensionFilter(".dae", "Collada files (experimental)"));
        fc.setAcceptAllFileFilterUsed(true);
        fc.setFileFilter(defaultFilter);
        fc.setDialogTitle("Open a gcode or model file...");
        fc.setDialogType(0);
        fc.setFileHidingEnabled(false);
        int rv = fc.showOpenDialog(this);
        if (rv == 0) {
            fc.getSelectedFile().getName();
            Base.preferences.put("ui.open_dir", fc.getCurrentDirectory().getAbsolutePath());
            return fc.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public void handleOpen(final String ipath) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String path = ipath;
                if (path == null && (path = MainWindow.this.selectFile()) == null) {
                    return;
                }
                Base.logger.info("Loading " + path);
                MainWindow.this.handleOpenPath = path;
                MainWindow.this.checkModified(2);
            }
        });
    }

    public void handleOpenUnchecked(String path, int codeIndex, int selStart, int selStop, int scrollPos) {
        this.handleOpen2(path);
        this.setCode(this.build.getCode());
        this.textarea.select(selStart, selStop);
        this.textarea.setScrollPosition(scrollPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleOpen2(String path) {
        if (path != null && !new File(path).exists()) {
            JOptionPane.showMessageDialog(this, "The file " + path + " could not be found.", "File not found", 0);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.build = new Build(this, path);
            this.setCode(this.build.getCode());
            this.setModel(this.build.getModel());
            this.updateBuild();
            this.buttons.updateFromMachine(this.machine);
            if (null != path) {
                this.handleOpenPath = path;
                this.mruList.update(path);
                this.reloadMruMenu();
            }
            if (Base.preferences.getBoolean("console.auto_clear", false)) {
                this.console.clear();
            }
        }
        catch (Exception e) {
            this.error(e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void handleSave(boolean force) {
        Runnable saveWork = new Runnable(){

            public void run() {
                Base.logger.info("Saving...");
                try {
                    if (MainWindow.this.build.save()) {
                        Base.logger.info("Save operation complete.");
                    } else {
                        Base.logger.info("Save operation aborted.");
                    }
                }
                catch (IOException e) {
                    MainWindow.this.error(e);
                    MainWindow.this.checkModifiedMode = 0;
                }
            }
        };
        if (force) {
            saveWork.run();
        } else {
            SwingUtilities.invokeLater(saveWork);
        }
    }

    public void handleSaveAs() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Base.logger.info("Saving...");
                try {
                    if (MainWindow.this.build.saveAs()) {
                        MainWindow.this.updateBuild();
                        Base.logger.info("Save operation complete.");
                        MainWindow.this.mruList.update(MainWindow.this.build.getMainFilePath());
                    } else {
                        Base.logger.info("Save operation aborted.");
                    }
                }
                catch (IOException e) {
                    MainWindow.this.error(e);
                }
            }
        });
    }

    public void handleQuitInternal() {
        block6: {
            if (!this.confirmBuildAbort()) {
                return;
            }
            try {
                if (this.simulationThread != null) {
                    this.simulationThread.interrupt();
                    this.simulationThread.join();
                }
                if (this.estimationThread != null) {
                    this.estimationThread.interrupt();
                    this.estimationThread.join();
                }
            }
            catch (InterruptedException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        if (this.machine != null) {
            this.machine.dispose();
            this.machine = null;
        }
        this.checkModified(3);
    }

    public void handleQuit() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainWindow.this.handleQuitInternal();
            }
        });
        throw new IllegalStateException("Quit Pending User Confirmation");
    }

    public void onShutdown() {
        this.storePreferences();
        this.console.handleQuit();
    }

    protected void handleReference() {
        String text = this.textarea.getSelectedText().trim();
        if (text.length() == 0) {
            this.message("First select a word to find in the reference.");
        } else {
            String referenceFile = PdeKeywords.getReference(text);
            if (referenceFile == null) {
                this.message("No reference available for \"" + text + "\"");
            } else {
                Base.showReference(referenceFile + ".html");
            }
        }
    }

    public void highlightLine(int lnum) {
        if (lnum < 0) {
            this.textarea.select(0, 0);
            return;
        }
        String s = this.textarea.getText();
        int len = s.length();
        int st = -1;
        int ii = 0;
        int end2 = -1;
        int lc = 0;
        if (lnum == 0) {
            st = 0;
        }
        for (int i = 0; i < len; ++i) {
            ++ii;
            boolean newline = false;
            if (s.charAt(i) == '\r') {
                if (i != len - 1 && s.charAt(i + 1) == '\n') {
                    ++i;
                }
                ++lc;
                newline = true;
            } else if (s.charAt(i) == '\n') {
                ++lc;
                newline = true;
            }
            if (!newline) continue;
            if (lc == lnum) {
                st = ii;
                continue;
            }
            if (lc != lnum + 1) continue;
            end2 = ii - 1;
            break;
        }
        if (end2 == -1) {
            end2 = len;
        }
        if (st == -1) {
            st = len;
        }
        this.textarea.select(st, end2);
    }

    public void error(String what) {
        Base.logger.severe(what);
    }

    public void error(Exception e) {
        if (e == null) {
            Base.logger.severe("MainWindow.error() was passed a null exception.");
            return;
        }
        String mess = e.getMessage();
        if (mess != null) {
            String javaLang;
            String rxString = "RuntimeException: ";
            if (mess.indexOf(rxString) == 0) {
                mess = mess.substring(rxString.length());
            }
            if (mess.indexOf(javaLang = "java.lang.") == 0) {
                mess = mess.substring(javaLang.length());
            }
        }
        Base.logger.log(Level.SEVERE, mess, e);
    }

    public void message(String msg) {
        Base.logger.info(msg);
    }

    protected void setMachine(MachineController machine) {
        if (this.machine != machine) {
            if (this.machine != null) {
                this.machine.dispose();
            }
            this.machine = machine;
            if (machine != null) {
                machine.setCodeSource(new JEditTextAreaSource(this.textarea));
                machine.setMainWindow(this);
                machine.addMachineStateListener(this);
                machine.addMachineStateListener(this.machineStatusPanel);
                machine.addMachineStateListener(this.buttons);
            }
        }
        if (machine == null) {
            this.buttons.machineStateChanged(new MachineStateChangeEvent(null, new MachineState()));
        }
        this.machineStatusPanel.setMachine(this.machine);
    }

    public MachineController getMachine() {
        return this.machine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMachine(String name, Boolean connect) {
        this.setMachine(Base.loadMachine(name));
        if (this.getMachine() == null) {
            return;
        }
        this.reloadSerialMenu();
        if (this.previewPanel != null) {
            Base.logger.fine("RELOADING the machine... removing previewPanel...");
            this.getPreviewPanel().rebuildScene();
            this.updateBuild();
        }
        if (!connect.booleanValue()) {
            return;
        }
        if (this.machine.driver instanceof UsesSerial) {
            UsesSerial us = (UsesSerial)((Object)this.machine.driver);
            String targetPort = Base.preferences.getBoolean("serial.use_machines", true) && us.isExplicit() ? us.getPortName() : Base.preferences.get("serial.last_selected", null);
            if (targetPort != null) {
                try {
                    UsesSerial usesSerial = us;
                    synchronized (usesSerial) {
                        Serial current = us.getSerial();
                        System.err.println("Current serial port: " + (current == null ? "null" : current.getName()) + ", specified " + targetPort);
                        if (current == null || !current.getName().equals(targetPort)) {
                            us.setSerial(new Serial(targetPort, us));
                        }
                        this.machine.connect();
                    }
                }
                catch (SerialException e) {
                    String msg = e.getMessage();
                    msg = msg == null ? "." : ": " + msg;
                    Base.logger.log(Level.WARNING, "Could not use specified serial port (" + targetPort + ")" + msg);
                }
            }
        }
    }

    public void machineProgress(MachineProgressEvent event) {
    }

    public void toolStatusChanged(MachineToolStatusEvent event) {
    }

    public void setCurrentElement(BuildElement e) {
        this.currentElement = e;
        if (this.currentElement != null) {
            CardLayout cl = (CardLayout)this.cardPanel.getLayout();
            if (this.currentElement.getType() == BuildElement.Type.MODEL) {
                cl.show(this.cardPanel, MODEL_TAB_KEY);
            } else {
                cl.show(this.cardPanel, GCODE_TAB_KEY);
            }
        }
        this.updateUndo();
    }

    private void updateBuild() {
        this.header.setBuild(this.build);
        this.header.repaint();
        this.updateUndo();
    }

    public void stateChanged(ChangeEvent e) {
        this.setCurrentElement(this.header.getSelectedElement());
    }

    public void generationComplete(ToolpathGenerator.GeneratorListener.Completion completion, Object details) {
        if (completion == ToolpathGenerator.GeneratorListener.Completion.SUCCESS) {
            if (this.build.getCode() != null) {
                this.setCode(this.build.getCode());
            }
            this.buttons.updateFromMachine(this.machine);
            this.updateBuild();
        }
    }

    public void updateGenerator(String message) {
    }

    class TextAreaPopup
    extends JPopupMenu {
        String referenceFile = null;
        JMenuItem cutItem = new JMenuItem("Cut");
        JMenuItem copyItem;
        JMenuItem referenceItem;

        public TextAreaPopup() {
            this.cutItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainWindow.this.textarea.cut();
                    MainWindow.this.build.getCode().setModified(true);
                }
            });
            this.add(this.cutItem);
            this.copyItem = new JMenuItem("Copy");
            this.copyItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainWindow.this.textarea.copy();
                }
            });
            this.add(this.copyItem);
            JMenuItem item = new JMenuItem("Paste");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainWindow.this.textarea.paste();
                    MainWindow.this.build.getCode().setModified(true);
                }
            });
            this.add(item);
            item = new JMenuItem("Select All");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainWindow.this.textarea.selectAll();
                }
            });
            this.add(item);
            this.addSeparator();
            this.referenceItem = new JMenuItem("Find in Reference");
            this.referenceItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainWindow.this.handleReference();
                }
            });
            this.add(this.referenceItem);
        }

        public void show(Component component, int x, int y) {
            if (MainWindow.this.textarea.isSelectionActive()) {
                this.cutItem.setEnabled(true);
                this.copyItem.setEnabled(true);
                String sel = MainWindow.this.textarea.getSelectedText().trim();
                this.referenceFile = PdeKeywords.getReference(sel);
                this.referenceItem.setEnabled(this.referenceFile != null);
            } else {
                this.cutItem.setEnabled(false);
                this.copyItem.setEnabled(false);
                this.referenceItem.setEnabled(false);
            }
            super.show(component, x, y);
        }
    }

    class EstimationThread
    extends Thread {
        MainWindow editor;

        public EstimationThread(MainWindow edit) {
            super("Estimation Thread");
            this.editor = edit;
        }

        public void run() {
            MainWindow.this.message("Estimating...");
            MainWindow.this.machine.estimate();
            this.editor.estimationOver();
        }
    }

    class SimulationThread
    extends Thread {
        MainWindow editor;

        public SimulationThread(MainWindow edit) {
            super("Simulation Thread");
            this.editor = edit;
        }

        public void run() {
            MainWindow.this.message("Simulating...");
            MainWindow.this.machine.simulate();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    MainWindow.this.simulationOver();
                }
            });
        }
    }

    private class ExtensionFilter
    extends FileFilter {
        private LinkedList<String> extensions = new LinkedList();
        private String description;

        public ExtensionFilter(String extension, String description) {
            this.extensions.add(extension);
            this.description = description;
        }

        public ExtensionFilter(String[] extensions, String description) {
            for (String e : extensions) {
                this.extensions.add(e);
            }
            this.description = description;
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return !f.isHidden();
            }
            for (String extension : this.extensions) {
                if (!f.getPath().toLowerCase().endsWith(extension)) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return this.description;
        }
    }

    class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -2427139178653072745L;

        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainWindow.this.currentElement.getUndoManager().redo();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
            MainWindow.this.updateUndo();
        }

        protected void updateRedoState() {
            if (MainWindow.this.currentElement == null) {
                return;
            }
            UndoManager undo = MainWindow.this.currentElement.getUndoManager();
            if (undo.canRedo()) {
                MainWindow.this.redoItem.setEnabled(true);
                MainWindow.this.redoItem.setText(undo.getRedoPresentationName());
                this.putValue("Name", undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                MainWindow.this.redoItem.setEnabled(false);
                MainWindow.this.redoItem.setText("Redo");
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 7800704765553895387L;

        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (MainWindow.this.currentElement == null) {
                    return;
                }
                MainWindow.this.currentElement.getUndoManager().undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            MainWindow.this.updateUndo();
        }

        protected void updateUndoState() {
            if (MainWindow.this.currentElement == null) {
                return;
            }
            UndoManager undo = MainWindow.this.currentElement.getUndoManager();
            boolean canUndo = undo.canUndo();
            this.setEnabled(canUndo);
            MainWindow.this.undoItem.setEnabled(canUndo);
            MainWindow.this.currentElement.setModified(canUndo);
            if (canUndo) {
                MainWindow.this.undoItem.setText(undo.getUndoPresentationName());
                this.putValue("Name", undo.getUndoPresentationName());
            } else {
                MainWindow.this.undoItem.setText("Undo");
                this.putValue("Name", "Undo");
            }
        }
    }

    class MachineMenuListener
    implements ActionListener {
        MachineMenuListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (MainWindow.this.machineMenu == null) {
                System.out.println("machineMenu is null");
                return;
            }
            int count = MainWindow.this.machineMenu.getItemCount();
            for (int i = 0; i < count; ++i) {
                ((JCheckBoxMenuItem)MainWindow.this.machineMenu.getItem(i)).setState(false);
            }
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
            item.setState(true);
            final String name = item.getText();
            Base.preferences.put("machine.name", name);
            Thread t = new Thread(){

                public void run() {
                    MainWindow.this.loadMachine(name, MainWindow.this.machine != null && MainWindow.this.machine.getMachineState().isConnected());
                }
            };
            t.start();
        }
    }

    private class FileOpenActionListener
    implements ActionListener {
        public String path;

        FileOpenActionListener(String path) {
            this.path = path;
        }

        public void actionPerformed(ActionEvent e) {
            MainWindow.this.handleOpen(this.path);
        }
    }
}

