/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.syntax;

import replicatorg.app.Base;
import replicatorg.app.syntax.DefaultInputHandler;
import replicatorg.app.syntax.InputHandler;
import replicatorg.app.syntax.SyntaxDocument;
import replicatorg.app.syntax.SyntaxUtilities;
import replicatorg.app.syntax.TextAreaDefaults;

public class PdeTextAreaDefaults
extends TextAreaDefaults {
    public PdeTextAreaDefaults() {
        this.inputHandler = new DefaultInputHandler();
        this.inputHandler.addDefaultKeyBindings();
        String mod = Base.isMacOS() ? "A" : "C";
        this.inputHandler.addKeyBinding("BACK_SPACE", InputHandler.BACKSPACE);
        this.inputHandler.addKeyBinding("DELETE", InputHandler.DELETE);
        this.inputHandler.addKeyBinding("S+BACK_SPACE", InputHandler.DELETE);
        this.inputHandler.addKeyBinding("S+DELETE", InputHandler.DELETE);
        this.inputHandler.addKeyBinding(mod + "+BACK_SPACE", InputHandler.BACKSPACE_WORD);
        this.inputHandler.addKeyBinding(mod + "+DELETE", InputHandler.DELETE_WORD);
        this.inputHandler.addKeyBinding("INSERT", InputHandler.OVERWRITE);
        if (Base.isMacOS()) {
            this.inputHandler.addKeyBinding("HOME", InputHandler.DOCUMENT_HOME);
            this.inputHandler.addKeyBinding("END", InputHandler.DOCUMENT_END);
            this.inputHandler.addKeyBinding("S+HOME", InputHandler.SELECT_DOC_HOME);
            this.inputHandler.addKeyBinding("S+END", InputHandler.SELECT_DOC_END);
        } else {
            this.inputHandler.addKeyBinding("HOME", InputHandler.HOME);
            this.inputHandler.addKeyBinding("END", InputHandler.END);
            this.inputHandler.addKeyBinding("S+HOME", InputHandler.SELECT_HOME);
            this.inputHandler.addKeyBinding("S+END", InputHandler.SELECT_END);
            this.inputHandler.addKeyBinding("C+HOME", InputHandler.DOCUMENT_HOME);
            this.inputHandler.addKeyBinding("C+END", InputHandler.DOCUMENT_END);
            this.inputHandler.addKeyBinding("CS+HOME", InputHandler.SELECT_DOC_HOME);
            this.inputHandler.addKeyBinding("CS+END", InputHandler.SELECT_DOC_END);
        }
        if (Base.isMacOS()) {
            this.inputHandler.addKeyBinding("M+LEFT", InputHandler.HOME);
            this.inputHandler.addKeyBinding("M+RIGHT", InputHandler.END);
            this.inputHandler.addKeyBinding("MS+LEFT", InputHandler.SELECT_HOME);
            this.inputHandler.addKeyBinding("MS+RIGHT", InputHandler.SELECT_END);
        } else {
            this.inputHandler.addKeyBinding("C+LEFT", InputHandler.HOME);
            this.inputHandler.addKeyBinding("C+RIGHT", InputHandler.END);
            this.inputHandler.addKeyBinding("CS+HOME", InputHandler.SELECT_HOME);
            this.inputHandler.addKeyBinding("CS+END", InputHandler.SELECT_END);
        }
        this.inputHandler.addKeyBinding("PAGE_UP", InputHandler.PREV_PAGE);
        this.inputHandler.addKeyBinding("PAGE_DOWN", InputHandler.NEXT_PAGE);
        this.inputHandler.addKeyBinding("S+PAGE_UP", InputHandler.SELECT_PREV_PAGE);
        this.inputHandler.addKeyBinding("S+PAGE_DOWN", InputHandler.SELECT_NEXT_PAGE);
        this.inputHandler.addKeyBinding("LEFT", InputHandler.PREV_CHAR);
        this.inputHandler.addKeyBinding("S+LEFT", InputHandler.SELECT_PREV_CHAR);
        this.inputHandler.addKeyBinding(mod + "+LEFT", InputHandler.PREV_WORD);
        this.inputHandler.addKeyBinding(mod + "S+LEFT", InputHandler.SELECT_PREV_WORD);
        this.inputHandler.addKeyBinding("RIGHT", InputHandler.NEXT_CHAR);
        this.inputHandler.addKeyBinding("S+RIGHT", InputHandler.SELECT_NEXT_CHAR);
        this.inputHandler.addKeyBinding(mod + "+RIGHT", InputHandler.NEXT_WORD);
        this.inputHandler.addKeyBinding(mod + "S+RIGHT", InputHandler.SELECT_NEXT_WORD);
        this.inputHandler.addKeyBinding("UP", InputHandler.PREV_LINE);
        this.inputHandler.addKeyBinding(mod + "+UP", InputHandler.PREV_LINE);
        this.inputHandler.addKeyBinding("S+UP", InputHandler.SELECT_PREV_LINE);
        this.inputHandler.addKeyBinding("DOWN", InputHandler.NEXT_LINE);
        this.inputHandler.addKeyBinding(mod + "+DOWN", InputHandler.NEXT_LINE);
        this.inputHandler.addKeyBinding("S+DOWN", InputHandler.SELECT_NEXT_LINE);
        this.inputHandler.addKeyBinding("MS+UP", InputHandler.SELECT_DOC_HOME);
        this.inputHandler.addKeyBinding("CS+UP", InputHandler.SELECT_DOC_HOME);
        this.inputHandler.addKeyBinding("MS+DOWN", InputHandler.SELECT_DOC_END);
        this.inputHandler.addKeyBinding("CS+DOWN", InputHandler.SELECT_DOC_END);
        this.inputHandler.addKeyBinding(mod + "+ENTER", InputHandler.REPEAT);
        this.document = new SyntaxDocument();
        this.editable = true;
        this.electricScroll = 3;
        this.cols = 80;
        this.rows = 15;
        this.styles = SyntaxUtilities.getDefaultSyntaxStyles();
        this.font = Base.getFontPref("editor.font", "Monospaced,plain,12");
        this.fgcolor = Base.getColorPref("editor.fgcolor", "#000000");
        this.bgcolor = Base.getColorPref("editor.bgcolor", "#ffffff");
        this.caretVisible = true;
        this.caretBlinks = Base.preferences.getBoolean("editor.caret.blink", true);
        this.caretColor = Base.getColorPref("editor.caret.color", "#333300");
        this.selectionColor = Base.getColorPref("editor.selection.color", "#ffcc00");
        this.lineHighlight = Base.preferences.getBoolean("editor.linehighlight", true);
        this.lineHighlightColor = Base.getColorPref("editor.linehighlight.color", "#ddddbb");
        this.bracketHighlight = Base.preferences.getBoolean("editor.brackethighlight", true);
        this.bracketHighlightColor = Base.getColorPref("editor.brackethighlight.color", "#000000");
        this.eolMarkers = Base.preferences.getBoolean("editor.eolmarkers", false);
        this.eolMarkerColor = Base.getColorPref("editor.eolmarkers.color", "#99991A");
        this.paintInvalid = Base.preferences.getBoolean("editor.invalid", false);
    }
}

