/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.stl;

import java.io.IOException;
import java.io.InputStream;

public class LittleEndianConverter {
    public static int convertToBigEndian(byte[] srcBuffer, short[] destBuffer, int srcLength, int destOffset, int destLength) {
        return LittleEndianConverter.convertToBigEndian(srcBuffer, destBuffer, srcLength, destOffset, destLength, (short)255);
    }

    public static int convertToBigEndian(byte[] srcBuffer, short[] destBuffer, int srcLength, int destOffset, int destLength, short mask) {
        int length = Math.min(destLength * 2, srcLength / 2 * 2);
        for (int i = 0; i < length; i += 2) {
            int tmp = (srcBuffer[i] & 0xFF | srcBuffer[i + 1] << 8) & mask;
            destBuffer[i / 2 + destOffset] = (short)tmp;
        }
        return length;
    }

    public static int convertToBigEndian(byte[] srcBuffer, int[] destBuffer, int srcLength, int destOffset, int destLength) {
        return LittleEndianConverter.convertToBigEndian(srcBuffer, destBuffer, srcLength, destOffset, destLength, -1);
    }

    public static int convertToBigEndian(byte[] srcBuffer, int[] destBuffer, int srcLength, int destOffset, int destLength, int mask) {
        int length = Math.min(destLength * 4, srcLength / 4 * 4);
        for (int i = 0; i < length; i += 4) {
            destBuffer[i / 4 + destOffset] = (srcBuffer[i] & 0xFF | srcBuffer[i + 1] << 8 & 0xFF00 | srcBuffer[i + 2] << 16 & 0xFF0000 | srcBuffer[i + 3] << 24) & mask;
        }
        return length;
    }

    public static int convertToBigEndian(int blockSize, byte[] srcBuffer, int[] destBuffer, int srcLength, int destOffset, int destLength) {
        return LittleEndianConverter.convertToBigEndian(blockSize, srcBuffer, destBuffer, srcLength, destOffset, destLength, -1);
    }

    public static int convertToBigEndian(int blockSize, byte[] srcBuffer, int[] destBuffer, int srcLength, int destOffset, int destLength, int mask) {
        int length = Math.min(destLength * blockSize, srcLength / blockSize * blockSize);
        if (blockSize == 2) {
            for (int i = 0; i < length; i += 2) {
                destBuffer[i / 2 + destOffset] = (srcBuffer[i] & 0xFF | srcBuffer[i + 1] << 8) & mask;
            }
            return length;
        }
        if (blockSize == 3) {
            for (int i = 0; i < length; i += 3) {
                destBuffer[i / 3 + destOffset] = (srcBuffer[i] & 0xFF | srcBuffer[i + 1] << 8 & 0xFF00 | srcBuffer[i + 2] << 24) & mask;
            }
            return length;
        }
        if (blockSize == 4) {
            return LittleEndianConverter.convertToBigEndian(srcBuffer, destBuffer, srcLength, destOffset, destLength, mask);
        }
        return 0;
    }

    public static int read(byte[] readBuffer, short[] destBuffer, int destOffset, int destLength, InputStream stream) throws IOException {
        return LittleEndianConverter.read(readBuffer, destBuffer, destOffset, destLength, stream, (short)255);
    }

    public static int read(byte[] readBuffer, short[] destBuffer, int destOffset, int destLength, InputStream stream, short mask) throws IOException {
        int numOfData;
        int numOfProcessedBytes;
        int numOfBytesRead = 0;
        int offset = 0;
        int length = readBuffer.length / 2 * 2;
        for (numOfData = 0; numOfBytesRead >= 0 && numOfData < destLength; numOfData += numOfProcessedBytes / 2) {
            int maxBytesToRead = Math.min((destLength - numOfData) * 2, length);
            numOfBytesRead = stream.read(readBuffer, offset, maxBytesToRead - offset);
            if (numOfBytesRead - (numOfProcessedBytes = LittleEndianConverter.convertToBigEndian(readBuffer, destBuffer, numOfBytesRead + offset, destOffset + numOfData, destLength - numOfData, mask)) == 1) {
                offset = 1;
                readBuffer[0] = readBuffer[numOfProcessedBytes];
                continue;
            }
            offset = 0;
        }
        return numOfData;
    }

    public static int read(byte[] readBuffer, int[] destBuffer, int destOffset, int destLength, InputStream stream) throws IOException {
        return LittleEndianConverter.read(readBuffer, destBuffer, destOffset, destLength, stream, -1);
    }

    public static int read(byte[] readBuffer, int[] destBuffer, int destOffset, int destLength, InputStream stream, int mask) throws IOException {
        int numOfData;
        int numOfProcessedBytes;
        int numOfBytesRead = 0;
        int offset = 0;
        int length = readBuffer.length / 4 * 4;
        for (numOfData = 0; numOfBytesRead >= 0 && numOfData < destLength; numOfData += numOfProcessedBytes / 4) {
            int maxBytesToRead = Math.min((destLength - numOfData) * 4, length);
            numOfBytesRead = stream.read(readBuffer, offset, maxBytesToRead - offset);
            numOfProcessedBytes = LittleEndianConverter.convertToBigEndian(readBuffer, destBuffer, numOfBytesRead + offset, destOffset + numOfData, destLength - numOfData, mask);
            int diff = numOfBytesRead - numOfProcessedBytes;
            offset = 0;
            if (diff == 1) {
                offset = 1;
                readBuffer[0] = readBuffer[numOfProcessedBytes];
            }
            if (diff == 2) {
                offset = 2;
                readBuffer[1] = readBuffer[numOfProcessedBytes + 1];
            }
            if (diff != 3) continue;
            offset = 3;
            readBuffer[2] = readBuffer[numOfProcessedBytes + 2];
        }
        return numOfData;
    }

    public static int read(int blockSize, byte[] readBuffer, int[] destBuffer, int destOffset, int destLength, InputStream stream) throws IOException {
        return LittleEndianConverter.read(blockSize, readBuffer, destBuffer, destOffset, destLength, stream, -1);
    }

    public static int read(int blockSize, byte[] readBuffer, int[] destBuffer, int destOffset, int destLength, InputStream stream, int mask) throws IOException {
        if (blockSize == 2) {
            return LittleEndianConverter.read2ByteBlock(readBuffer, destBuffer, destOffset, destLength, stream, mask);
        }
        if (blockSize == 3) {
            return LittleEndianConverter.read3ByteBlock(readBuffer, destBuffer, destOffset, destLength, stream, mask);
        }
        if (blockSize == 4) {
            return LittleEndianConverter.read(readBuffer, destBuffer, destOffset, destLength, stream, mask);
        }
        return 0;
    }

    public static int read4ByteBlock(InputStream stream) throws IOException {
        return LittleEndianConverter.read(stream) & 0xFF | LittleEndianConverter.read(stream) << 8 & 0xFF00 | LittleEndianConverter.read(stream) << 16 & 0xFF0000 | LittleEndianConverter.read(stream) << 24;
    }

    public static int read2ByteBlock(InputStream stream) throws IOException {
        return LittleEndianConverter.read(stream) & 0xFF | LittleEndianConverter.read(stream) << 8;
    }

    public static int read3ByteBlock(InputStream stream) throws IOException {
        return LittleEndianConverter.read(stream) & 0xFF | LittleEndianConverter.read(stream) << 8 & 0xFF00 | LittleEndianConverter.read(stream) << 16;
    }

    private static int read2ByteBlock(byte[] readBuffer, int[] destBuffer, int destOffset, int destLength, InputStream stream, int mask) throws IOException {
        int numOfData;
        int numOfProcessedBytes;
        int numOfBytesRead = 0;
        int offset = 0;
        int length = readBuffer.length / 2 * 2;
        for (numOfData = 0; numOfBytesRead >= 0 && numOfData < destLength; numOfData += numOfProcessedBytes / 2) {
            int maxBytesToRead = Math.max((destLength - numOfData) * 2, length);
            numOfBytesRead = stream.read(readBuffer, offset, maxBytesToRead - offset);
            if (numOfBytesRead - (numOfProcessedBytes = LittleEndianConverter.convertToBigEndian(2, readBuffer, destBuffer, numOfBytesRead + offset, destOffset + numOfData, destLength - numOfData, mask)) == 1) {
                offset = 1;
                readBuffer[0] = readBuffer[numOfProcessedBytes];
                continue;
            }
            offset = 0;
        }
        return numOfData;
    }

    private static int read3ByteBlock(byte[] readBuffer, int[] destBuffer, int destOffset, int destLength, InputStream stream, int mask) throws IOException {
        int numOfData;
        int numOfProcessedBytes;
        int numOfBytesRead = 0;
        int offset = 0;
        int length = readBuffer.length / 3 * 3;
        for (numOfData = 0; numOfBytesRead >= 0 && numOfData < destLength; numOfData += numOfProcessedBytes / 3) {
            int maxBytesToRead = Math.max((destLength - numOfData) * 3, length);
            numOfBytesRead = stream.read(readBuffer, offset, maxBytesToRead - offset);
            numOfProcessedBytes = LittleEndianConverter.convertToBigEndian(3, readBuffer, destBuffer, numOfBytesRead + offset, destOffset + numOfData, destLength - numOfData, mask);
            int diff = numOfBytesRead - numOfProcessedBytes;
            offset = 0;
            if (diff == 1) {
                offset = 1;
                readBuffer[0] = readBuffer[numOfProcessedBytes];
            }
            if (diff != 2) continue;
            offset = 2;
            readBuffer[1] = readBuffer[numOfProcessedBytes + 1];
        }
        return numOfData;
    }

    private static int read(InputStream stream) throws IOException {
        int tempValue = stream.read();
        if (tempValue == -1) {
            throw new IOException("Filesize does not match blocksize");
        }
        return tempValue;
    }
}

