/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Internal;
import com.google.protobuf.MessageLite;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FieldSet<FieldDescriptorType extends FieldDescriptorLite<FieldDescriptorType>> {
    private Map<FieldDescriptorType, Object> fields;
    private static final FieldSet DEFAULT_INSTANCE = new FieldSet(true);

    private FieldSet() {
        this.fields = new TreeMap<FieldDescriptorType, Object>();
    }

    private FieldSet(boolean bl) {
        this.fields = Collections.emptyMap();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> newFieldSet() {
        return new FieldSet();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> emptySet() {
        return DEFAULT_INSTANCE;
    }

    public void makeImmutable() {
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.entrySet()) {
            if (!((FieldDescriptorLite)entry.getKey()).isRepeated()) continue;
            List list = (List)entry.getValue();
            this.fields.put(entry.getKey(), Collections.unmodifiableList(list));
        }
        this.fields = Collections.unmodifiableMap(this.fields);
    }

    public void clear() {
        this.fields.clear();
    }

    public Map<FieldDescriptorType, Object> getAllFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    public Iterator<Map.Entry<FieldDescriptorType, Object>> iterator() {
        return this.fields.entrySet().iterator();
    }

    public boolean hasField(FieldDescriptorType FieldDescriptorType) {
        if (FieldDescriptorType.isRepeated()) {
            throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
        }
        return this.fields.get(FieldDescriptorType) != null;
    }

    public Object getField(FieldDescriptorType FieldDescriptorType) {
        return this.fields.get(FieldDescriptorType);
    }

    public void setField(FieldDescriptorType FieldDescriptorType, Object arrayList) {
        if (FieldDescriptorType.isRepeated()) {
            if (!(arrayList instanceof List)) {
                throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            }
            ArrayList arrayList2 = new ArrayList();
            arrayList2.addAll(arrayList);
            for (Object e : arrayList2) {
                FieldSet.verifyType(FieldDescriptorType.getLiteType(), e);
            }
            arrayList = arrayList2;
        } else {
            FieldSet.verifyType(FieldDescriptorType.getLiteType(), arrayList);
        }
        this.fields.put(FieldDescriptorType, arrayList);
    }

    public void clearField(FieldDescriptorType FieldDescriptorType) {
        this.fields.remove(FieldDescriptorType);
    }

    public int getRepeatedFieldCount(FieldDescriptorType FieldDescriptorType) {
        if (!FieldDescriptorType.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object object = this.fields.get(FieldDescriptorType);
        if (object == null) {
            return 0;
        }
        return ((List)object).size();
    }

    public Object getRepeatedField(FieldDescriptorType FieldDescriptorType, int n) {
        if (!FieldDescriptorType.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object object = this.fields.get(FieldDescriptorType);
        if (object == null) {
            throw new IndexOutOfBoundsException();
        }
        return ((List)object).get(n);
    }

    public void setRepeatedField(FieldDescriptorType FieldDescriptorType, int n, Object object) {
        if (!FieldDescriptorType.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object object2 = this.fields.get(FieldDescriptorType);
        if (object2 == null) {
            throw new IndexOutOfBoundsException();
        }
        FieldSet.verifyType(FieldDescriptorType.getLiteType(), object);
        ((List)object2).set(n, object);
    }

    public void addRepeatedField(FieldDescriptorType FieldDescriptorType, Object object) {
        ArrayList<Object> arrayList;
        if (!FieldDescriptorType.isRepeated()) {
            throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
        }
        FieldSet.verifyType(FieldDescriptorType.getLiteType(), object);
        Object object2 = this.fields.get(FieldDescriptorType);
        if (object2 == null) {
            arrayList = new ArrayList<Object>();
            this.fields.put(FieldDescriptorType, arrayList);
        } else {
            arrayList = (ArrayList<Object>)object2;
        }
        arrayList.add(object);
    }

    private static void verifyType(WireFormat.FieldType fieldType, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        boolean bl = false;
        switch (fieldType.getJavaType()) {
            case INT: {
                bl = object instanceof Integer;
                break;
            }
            case LONG: {
                bl = object instanceof Long;
                break;
            }
            case FLOAT: {
                bl = object instanceof Float;
                break;
            }
            case DOUBLE: {
                bl = object instanceof Double;
                break;
            }
            case BOOLEAN: {
                bl = object instanceof Boolean;
                break;
            }
            case STRING: {
                bl = object instanceof String;
                break;
            }
            case BYTE_STRING: {
                bl = object instanceof ByteString;
                break;
            }
            case ENUM: {
                bl = object instanceof Internal.EnumLite;
                break;
            }
            case MESSAGE: {
                bl = object instanceof MessageLite;
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
        }
    }

    public boolean isInitialized() {
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.entrySet()) {
            FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
            if (fieldDescriptorLite.getLiteJavaType() != WireFormat.JavaType.MESSAGE) continue;
            if (fieldDescriptorLite.isRepeated()) {
                for (MessageLite messageLite : (List)entry.getValue()) {
                    if (messageLite.isInitialized()) continue;
                    return false;
                }
                continue;
            }
            if (((MessageLite)entry.getValue()).isInitialized()) continue;
            return false;
        }
        return true;
    }

    static int getWireFormatForFieldType(WireFormat.FieldType fieldType, boolean bl) {
        if (bl) {
            return 2;
        }
        return fieldType.getWireType();
    }

    public void mergeFrom(FieldSet<FieldDescriptorType> fieldSet) {
        for (Map.Entry<FieldDescriptorType, Object> entry : fieldSet.fields.entrySet()) {
            Object object;
            FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
            Object object2 = entry.getValue();
            if (fieldDescriptorLite.isRepeated()) {
                object = this.fields.get(fieldDescriptorLite);
                if (object == null) {
                    this.fields.put(fieldDescriptorLite, new ArrayList((List)object2));
                    continue;
                }
                ((List)object).addAll((List)object2);
                continue;
            }
            if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
                object = this.fields.get(fieldDescriptorLite);
                if (object == null) {
                    this.fields.put(fieldDescriptorLite, object2);
                    continue;
                }
                this.fields.put(fieldDescriptorLite, fieldDescriptorLite.internalMergeFrom(((MessageLite)object).toBuilder(), (MessageLite)object2).build());
                continue;
            }
            this.fields.put(fieldDescriptorLite, object2);
        }
    }

    public static Object readPrimitiveField(CodedInputStream codedInputStream, WireFormat.FieldType fieldType) throws IOException {
        switch (fieldType) {
            case DOUBLE: {
                return codedInputStream.readDouble();
            }
            case FLOAT: {
                return Float.valueOf(codedInputStream.readFloat());
            }
            case INT64: {
                return codedInputStream.readInt64();
            }
            case UINT64: {
                return codedInputStream.readUInt64();
            }
            case INT32: {
                return codedInputStream.readInt32();
            }
            case FIXED64: {
                return codedInputStream.readFixed64();
            }
            case FIXED32: {
                return codedInputStream.readFixed32();
            }
            case BOOL: {
                return codedInputStream.readBool();
            }
            case STRING: {
                return codedInputStream.readString();
            }
            case BYTES: {
                return codedInputStream.readBytes();
            }
            case UINT32: {
                return codedInputStream.readUInt32();
            }
            case SFIXED32: {
                return codedInputStream.readSFixed32();
            }
            case SFIXED64: {
                return codedInputStream.readSFixed64();
            }
            case SINT32: {
                return codedInputStream.readSInt32();
            }
            case SINT64: {
                return codedInputStream.readSInt64();
            }
            case GROUP: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle nested groups.");
            }
            case MESSAGE: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle embedded messages.");
            }
            case ENUM: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle enums.");
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    public void writeTo(CodedOutputStream codedOutputStream) throws IOException {
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.entrySet()) {
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), codedOutputStream);
        }
    }

    public void writeMessageSetTo(CodedOutputStream codedOutputStream) throws IOException {
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.entrySet()) {
            FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
            if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !fieldDescriptorLite.isRepeated() && !fieldDescriptorLite.isPacked()) {
                codedOutputStream.writeMessageSetExtension(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)entry.getValue());
                continue;
            }
            FieldSet.writeField(fieldDescriptorLite, entry.getValue(), codedOutputStream);
        }
    }

    private static void writeElement(CodedOutputStream codedOutputStream, WireFormat.FieldType fieldType, int n, Object object) throws IOException {
        if (fieldType == WireFormat.FieldType.GROUP) {
            codedOutputStream.writeGroup(n, (MessageLite)object);
        } else {
            codedOutputStream.writeTag(n, FieldSet.getWireFormatForFieldType(fieldType, false));
            FieldSet.writeElementNoTag(codedOutputStream, fieldType, object);
        }
    }

    private static void writeElementNoTag(CodedOutputStream codedOutputStream, WireFormat.FieldType fieldType, Object object) throws IOException {
        switch (fieldType) {
            case DOUBLE: {
                codedOutputStream.writeDoubleNoTag((Double)object);
                break;
            }
            case FLOAT: {
                codedOutputStream.writeFloatNoTag(((Float)object).floatValue());
                break;
            }
            case INT64: {
                codedOutputStream.writeInt64NoTag((Long)object);
                break;
            }
            case UINT64: {
                codedOutputStream.writeUInt64NoTag((Long)object);
                break;
            }
            case INT32: {
                codedOutputStream.writeInt32NoTag((Integer)object);
                break;
            }
            case FIXED64: {
                codedOutputStream.writeFixed64NoTag((Long)object);
                break;
            }
            case FIXED32: {
                codedOutputStream.writeFixed32NoTag((Integer)object);
                break;
            }
            case BOOL: {
                codedOutputStream.writeBoolNoTag((Boolean)object);
                break;
            }
            case STRING: {
                codedOutputStream.writeStringNoTag((String)object);
                break;
            }
            case GROUP: {
                codedOutputStream.writeGroupNoTag((MessageLite)object);
                break;
            }
            case MESSAGE: {
                codedOutputStream.writeMessageNoTag((MessageLite)object);
                break;
            }
            case BYTES: {
                codedOutputStream.writeBytesNoTag((ByteString)object);
                break;
            }
            case UINT32: {
                codedOutputStream.writeUInt32NoTag((Integer)object);
                break;
            }
            case SFIXED32: {
                codedOutputStream.writeSFixed32NoTag((Integer)object);
                break;
            }
            case SFIXED64: {
                codedOutputStream.writeSFixed64NoTag((Long)object);
                break;
            }
            case SINT32: {
                codedOutputStream.writeSInt32NoTag((Integer)object);
                break;
            }
            case SINT64: {
                codedOutputStream.writeSInt64NoTag((Long)object);
                break;
            }
            case ENUM: {
                codedOutputStream.writeEnumNoTag(((Internal.EnumLite)object).getNumber());
            }
        }
    }

    public static void writeField(FieldDescriptorLite<?> fieldDescriptorLite, Object object, CodedOutputStream codedOutputStream) throws IOException {
        WireFormat.FieldType fieldType = fieldDescriptorLite.getLiteType();
        int n = fieldDescriptorLite.getNumber();
        if (fieldDescriptorLite.isRepeated()) {
            List list = (List)object;
            if (fieldDescriptorLite.isPacked()) {
                codedOutputStream.writeTag(n, 2);
                int n2 = 0;
                for (Object e : list) {
                    n2 += FieldSet.computeElementSizeNoTag(fieldType, e);
                }
                codedOutputStream.writeRawVarint32(n2);
                for (Object e : list) {
                    FieldSet.writeElementNoTag(codedOutputStream, fieldType, e);
                }
            } else {
                for (Object e : list) {
                    FieldSet.writeElement(codedOutputStream, fieldType, n, e);
                }
            }
        } else {
            FieldSet.writeElement(codedOutputStream, fieldType, n, object);
        }
    }

    public int getSerializedSize() {
        int n = 0;
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.entrySet()) {
            n += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        return n;
    }

    public int getMessageSetSerializedSize() {
        int n = 0;
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.entrySet()) {
            FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
            if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !fieldDescriptorLite.isRepeated() && !fieldDescriptorLite.isPacked()) {
                n += CodedOutputStream.computeMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)entry.getValue());
                continue;
            }
            n += FieldSet.computeFieldSize(fieldDescriptorLite, entry.getValue());
        }
        return n;
    }

    private static int computeElementSize(WireFormat.FieldType fieldType, int n, Object object) {
        int n2 = CodedOutputStream.computeTagSize(n);
        if (fieldType == WireFormat.FieldType.GROUP) {
            n2 *= 2;
        }
        return n2 + FieldSet.computeElementSizeNoTag(fieldType, object);
    }

    private static int computeElementSizeNoTag(WireFormat.FieldType fieldType, Object object) {
        switch (fieldType) {
            case DOUBLE: {
                return CodedOutputStream.computeDoubleSizeNoTag((Double)object);
            }
            case FLOAT: {
                return CodedOutputStream.computeFloatSizeNoTag(((Float)object).floatValue());
            }
            case INT64: {
                return CodedOutputStream.computeInt64SizeNoTag((Long)object);
            }
            case UINT64: {
                return CodedOutputStream.computeUInt64SizeNoTag((Long)object);
            }
            case INT32: {
                return CodedOutputStream.computeInt32SizeNoTag((Integer)object);
            }
            case FIXED64: {
                return CodedOutputStream.computeFixed64SizeNoTag((Long)object);
            }
            case FIXED32: {
                return CodedOutputStream.computeFixed32SizeNoTag((Integer)object);
            }
            case BOOL: {
                return CodedOutputStream.computeBoolSizeNoTag((Boolean)object);
            }
            case STRING: {
                return CodedOutputStream.computeStringSizeNoTag((String)object);
            }
            case GROUP: {
                return CodedOutputStream.computeGroupSizeNoTag((MessageLite)object);
            }
            case MESSAGE: {
                return CodedOutputStream.computeMessageSizeNoTag((MessageLite)object);
            }
            case BYTES: {
                return CodedOutputStream.computeBytesSizeNoTag((ByteString)object);
            }
            case UINT32: {
                return CodedOutputStream.computeUInt32SizeNoTag((Integer)object);
            }
            case SFIXED32: {
                return CodedOutputStream.computeSFixed32SizeNoTag((Integer)object);
            }
            case SFIXED64: {
                return CodedOutputStream.computeSFixed64SizeNoTag((Long)object);
            }
            case SINT32: {
                return CodedOutputStream.computeSInt32SizeNoTag((Integer)object);
            }
            case SINT64: {
                return CodedOutputStream.computeSInt64SizeNoTag((Long)object);
            }
            case ENUM: {
                return CodedOutputStream.computeEnumSizeNoTag(((Internal.EnumLite)object).getNumber());
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    public static int computeFieldSize(FieldDescriptorLite<?> fieldDescriptorLite, Object object) {
        WireFormat.FieldType fieldType = fieldDescriptorLite.getLiteType();
        int n = fieldDescriptorLite.getNumber();
        if (fieldDescriptorLite.isRepeated()) {
            if (fieldDescriptorLite.isPacked()) {
                int n2 = 0;
                for (Object e : (List)object) {
                    n2 += FieldSet.computeElementSizeNoTag(fieldType, e);
                }
                return n2 + CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeRawVarint32Size(n2);
            }
            int n3 = 0;
            for (Object e : (List)object) {
                n3 += FieldSet.computeElementSize(fieldType, n, e);
            }
            return n3;
        }
        return FieldSet.computeElementSize(fieldType, n, object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface FieldDescriptorLite<T extends FieldDescriptorLite<T>>
    extends Comparable<T> {
        public int getNumber();

        public WireFormat.FieldType getLiteType();

        public WireFormat.JavaType getLiteJavaType();

        public boolean isRepeated();

        public boolean isPacked();

        public Internal.EnumLiteMap<?> getEnumType();

        public MessageLite.Builder internalMergeFrom(MessageLite.Builder var1, MessageLite var2);
    }
}

