/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TextFormat {
    private static final int BUFFER_SIZE = 4096;

    private TextFormat() {
    }

    public static void print(Message message, Appendable appendable) throws IOException {
        TextGenerator textGenerator = new TextGenerator(appendable);
        TextFormat.print(message, textGenerator);
    }

    public static void print(UnknownFieldSet unknownFieldSet, Appendable appendable) throws IOException {
        TextGenerator textGenerator = new TextGenerator(appendable);
        TextFormat.printUnknownFields(unknownFieldSet, textGenerator);
    }

    public static String printToString(Message message) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat.print(message, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Writing to a StringBuilder threw an IOException (should never happen).", iOException);
        }
    }

    public static String printToString(UnknownFieldSet unknownFieldSet) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat.print(unknownFieldSet, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Writing to a StringBuilder threw an IOException (should never happen).", iOException);
        }
    }

    private static void print(Message message, TextGenerator textGenerator) throws IOException {
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : message.getAllFields().entrySet()) {
            TextFormat.printField(entry.getKey(), entry.getValue(), textGenerator);
        }
        TextFormat.printUnknownFields(message.getUnknownFields(), textGenerator);
    }

    public static void printField(Descriptors.FieldDescriptor fieldDescriptor, Object object, Appendable appendable) throws IOException {
        TextGenerator textGenerator = new TextGenerator(appendable);
        TextFormat.printField(fieldDescriptor, object, textGenerator);
    }

    public static String printFieldToString(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat.printField(fieldDescriptor, object, stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Writing to a StringBuilder threw an IOException (should never happen).", iOException);
        }
    }

    private static void printField(Descriptors.FieldDescriptor fieldDescriptor, Object object, TextGenerator textGenerator) throws IOException {
        if (fieldDescriptor.isRepeated()) {
            for (Object e : (List)object) {
                TextFormat.printSingleField(fieldDescriptor, e, textGenerator);
            }
        } else {
            TextFormat.printSingleField(fieldDescriptor, object, textGenerator);
        }
    }

    private static void printSingleField(Descriptors.FieldDescriptor fieldDescriptor, Object object, TextGenerator textGenerator) throws IOException {
        if (fieldDescriptor.isExtension()) {
            textGenerator.print("[");
            if (fieldDescriptor.getContainingType().getOptions().getMessageSetWireFormat() && fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && fieldDescriptor.isOptional() && fieldDescriptor.getExtensionScope() == fieldDescriptor.getMessageType()) {
                textGenerator.print(fieldDescriptor.getMessageType().getFullName());
            } else {
                textGenerator.print(fieldDescriptor.getFullName());
            }
            textGenerator.print("]");
        } else if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
            textGenerator.print(fieldDescriptor.getMessageType().getName());
        } else {
            textGenerator.print(fieldDescriptor.getName());
        }
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            textGenerator.print(" {\n");
            textGenerator.indent();
        } else {
            textGenerator.print(": ");
        }
        TextFormat.printFieldValue(fieldDescriptor, object, textGenerator);
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            textGenerator.outdent();
            textGenerator.print("}");
        }
        textGenerator.print("\n");
    }

    private static void printFieldValue(Descriptors.FieldDescriptor fieldDescriptor, Object object, TextGenerator textGenerator) throws IOException {
        switch (fieldDescriptor.getType()) {
            case INT32: 
            case INT64: 
            case SINT32: 
            case SINT64: 
            case SFIXED32: 
            case SFIXED64: 
            case FLOAT: 
            case DOUBLE: 
            case BOOL: {
                textGenerator.print(object.toString());
                break;
            }
            case UINT32: 
            case FIXED32: {
                textGenerator.print(TextFormat.unsignedToString((Integer)object));
                break;
            }
            case UINT64: 
            case FIXED64: {
                textGenerator.print(TextFormat.unsignedToString((Long)object));
                break;
            }
            case STRING: {
                textGenerator.print("\"");
                textGenerator.print(TextFormat.escapeText((String)object));
                textGenerator.print("\"");
                break;
            }
            case BYTES: {
                textGenerator.print("\"");
                textGenerator.print(TextFormat.escapeBytes((ByteString)object));
                textGenerator.print("\"");
                break;
            }
            case ENUM: {
                textGenerator.print(((Descriptors.EnumValueDescriptor)object).getName());
                break;
            }
            case MESSAGE: 
            case GROUP: {
                TextFormat.print((Message)object, textGenerator);
            }
        }
    }

    private static void printUnknownFields(UnknownFieldSet unknownFieldSet, TextGenerator textGenerator) throws IOException {
        for (Map.Entry<Integer, UnknownFieldSet.Field> entry : unknownFieldSet.asMap().entrySet()) {
            String string = entry.getKey().toString() + ": ";
            UnknownFieldSet.Field field = entry.getValue();
            Iterator<Object> iterator = field.getVarintList().iterator();
            while (iterator.hasNext()) {
                long l = iterator.next();
                textGenerator.print(entry.getKey().toString());
                textGenerator.print(": ");
                textGenerator.print(TextFormat.unsignedToString(l));
                textGenerator.print("\n");
            }
            iterator = field.getFixed32List().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                textGenerator.print(entry.getKey().toString());
                textGenerator.print(": ");
                textGenerator.print(String.format((Locale)null, "0x%08x", n));
                textGenerator.print("\n");
            }
            iterator = field.getFixed64List().iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                textGenerator.print(entry.getKey().toString());
                textGenerator.print(": ");
                textGenerator.print(String.format((Locale)null, "0x%016x", l));
                textGenerator.print("\n");
            }
            for (ByteString byteString : field.getLengthDelimitedList()) {
                textGenerator.print(entry.getKey().toString());
                textGenerator.print(": \"");
                textGenerator.print(TextFormat.escapeBytes(byteString));
                textGenerator.print("\"\n");
            }
            for (UnknownFieldSet unknownFieldSet2 : field.getGroupList()) {
                textGenerator.print(entry.getKey().toString());
                textGenerator.print(" {\n");
                textGenerator.indent();
                TextFormat.printUnknownFields(unknownFieldSet2, textGenerator);
                textGenerator.outdent();
                textGenerator.print("}\n");
            }
        }
    }

    private static String unsignedToString(int n) {
        if (n >= 0) {
            return Integer.toString(n);
        }
        return Long.toString((long)n & 0xFFFFFFFFL);
    }

    private static String unsignedToString(long l) {
        if (l >= 0L) {
            return Long.toString(l);
        }
        return BigInteger.valueOf(l & Long.MAX_VALUE).setBit(63).toString();
    }

    public static void merge(Readable readable, Message.Builder builder) throws IOException {
        TextFormat.merge(readable, ExtensionRegistry.getEmptyRegistry(), builder);
    }

    public static void merge(CharSequence charSequence, Message.Builder builder) throws ParseException {
        TextFormat.merge(charSequence, ExtensionRegistry.getEmptyRegistry(), builder);
    }

    public static void merge(Readable readable, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        TextFormat.merge(TextFormat.toStringBuilder(readable), extensionRegistry, builder);
    }

    private static StringBuilder toStringBuilder(Readable readable) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        CharBuffer charBuffer = CharBuffer.allocate(4096);
        while ((n = readable.read(charBuffer)) != -1) {
            charBuffer.flip();
            stringBuilder.append(charBuffer, 0, n);
        }
        return stringBuilder;
    }

    public static void merge(CharSequence charSequence, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
        Tokenizer tokenizer = new Tokenizer(charSequence);
        while (!tokenizer.atEnd()) {
            TextFormat.mergeField(tokenizer, extensionRegistry, builder);
        }
    }

    private static void mergeField(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
        Object object;
        Descriptors.FieldDescriptor fieldDescriptor;
        Object object2;
        Descriptors.Descriptor descriptor = builder.getDescriptorForType();
        ExtensionRegistry.ExtensionInfo extensionInfo = null;
        if (tokenizer.tryConsume("[")) {
            object2 = new StringBuilder(tokenizer.consumeIdentifier());
            while (tokenizer.tryConsume(".")) {
                ((StringBuilder)object2).append('.');
                ((StringBuilder)object2).append(tokenizer.consumeIdentifier());
            }
            extensionInfo = extensionRegistry.findExtensionByName(((StringBuilder)object2).toString());
            if (extensionInfo == null) {
                throw tokenizer.parseExceptionPreviousToken("Extension \"" + object2 + "\" not found in the ExtensionRegistry.");
            }
            if (extensionInfo.descriptor.getContainingType() != descriptor) {
                throw tokenizer.parseExceptionPreviousToken("Extension \"" + object2 + "\" does not extend message type \"" + descriptor.getFullName() + "\".");
            }
            tokenizer.consume("]");
            fieldDescriptor = extensionInfo.descriptor;
        } else {
            object2 = tokenizer.consumeIdentifier();
            fieldDescriptor = descriptor.findFieldByName((String)object2);
            if (fieldDescriptor == null && (fieldDescriptor = descriptor.findFieldByName((String)(object = ((String)object2).toLowerCase(Locale.US)))) != null && fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.GROUP) {
                fieldDescriptor = null;
            }
            if (fieldDescriptor != null && fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.GROUP && !fieldDescriptor.getMessageType().getName().equals(object2)) {
                fieldDescriptor = null;
            }
            if (fieldDescriptor == null) {
                throw tokenizer.parseExceptionPreviousToken("Message type \"" + descriptor.getFullName() + "\" has no field named \"" + (String)object2 + "\".");
            }
        }
        object2 = null;
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            tokenizer.tryConsume(":");
            if (tokenizer.tryConsume("<")) {
                object = ">";
            } else {
                tokenizer.consume("{");
                object = "}";
            }
            Message.Builder builder2 = extensionInfo == null ? builder.newBuilderForField(fieldDescriptor) : extensionInfo.defaultInstance.newBuilderForType();
            while (!tokenizer.tryConsume((String)object)) {
                if (tokenizer.atEnd()) {
                    throw tokenizer.parseException("Expected \"" + (String)object + "\".");
                }
                TextFormat.mergeField(tokenizer, extensionRegistry, builder2);
            }
            object2 = builder2.build();
        } else {
            tokenizer.consume(":");
            switch (fieldDescriptor.getType()) {
                case INT32: 
                case SINT32: 
                case SFIXED32: {
                    object2 = tokenizer.consumeInt32();
                    break;
                }
                case INT64: 
                case SINT64: 
                case SFIXED64: {
                    object2 = tokenizer.consumeInt64();
                    break;
                }
                case UINT32: 
                case FIXED32: {
                    object2 = tokenizer.consumeUInt32();
                    break;
                }
                case UINT64: 
                case FIXED64: {
                    object2 = tokenizer.consumeUInt64();
                    break;
                }
                case FLOAT: {
                    object2 = Float.valueOf(tokenizer.consumeFloat());
                    break;
                }
                case DOUBLE: {
                    object2 = tokenizer.consumeDouble();
                    break;
                }
                case BOOL: {
                    object2 = tokenizer.consumeBoolean();
                    break;
                }
                case STRING: {
                    object2 = tokenizer.consumeString();
                    break;
                }
                case BYTES: {
                    object2 = tokenizer.consumeByteString();
                    break;
                }
                case ENUM: {
                    object = fieldDescriptor.getEnumType();
                    if (tokenizer.lookingAtInteger()) {
                        int n = tokenizer.consumeInt32();
                        object2 = ((Descriptors.EnumDescriptor)object).findValueByNumber(n);
                        if (object2 != null) break;
                        throw tokenizer.parseExceptionPreviousToken("Enum type \"" + ((Descriptors.EnumDescriptor)object).getFullName() + "\" has no value with number " + n + '.');
                    }
                    String string = tokenizer.consumeIdentifier();
                    object2 = ((Descriptors.EnumDescriptor)object).findValueByName(string);
                    if (object2 != null) break;
                    throw tokenizer.parseExceptionPreviousToken("Enum type \"" + ((Descriptors.EnumDescriptor)object).getFullName() + "\" has no value named \"" + string + "\".");
                }
                case MESSAGE: 
                case GROUP: {
                    throw new RuntimeException("Can't get here.");
                }
            }
        }
        if (fieldDescriptor.isRepeated()) {
            builder.addRepeatedField(fieldDescriptor, object2);
        } else {
            builder.setField(fieldDescriptor, object2);
        }
    }

    static String escapeBytes(ByteString byteString) {
        StringBuilder stringBuilder = new StringBuilder(byteString.size());
        block12: for (int i = 0; i < byteString.size(); ++i) {
            byte by = byteString.byteAt(i);
            switch (by) {
                case 7: {
                    stringBuilder.append("\\a");
                    continue block12;
                }
                case 8: {
                    stringBuilder.append("\\b");
                    continue block12;
                }
                case 12: {
                    stringBuilder.append("\\f");
                    continue block12;
                }
                case 10: {
                    stringBuilder.append("\\n");
                    continue block12;
                }
                case 13: {
                    stringBuilder.append("\\r");
                    continue block12;
                }
                case 9: {
                    stringBuilder.append("\\t");
                    continue block12;
                }
                case 11: {
                    stringBuilder.append("\\v");
                    continue block12;
                }
                case 92: {
                    stringBuilder.append("\\\\");
                    continue block12;
                }
                case 39: {
                    stringBuilder.append("\\'");
                    continue block12;
                }
                case 34: {
                    stringBuilder.append("\\\"");
                    continue block12;
                }
                default: {
                    if (by >= 32) {
                        stringBuilder.append((char)by);
                        continue block12;
                    }
                    stringBuilder.append('\\');
                    stringBuilder.append((char)(48 + (by >>> 6 & 3)));
                    stringBuilder.append((char)(48 + (by >>> 3 & 7)));
                    stringBuilder.append((char)(48 + (by & 7)));
                }
            }
        }
        return stringBuilder.toString();
    }

    static ByteString unescapeBytes(CharSequence charSequence) throws InvalidEscapeSequenceException {
        byte[] byArray = new byte[charSequence.length()];
        int n = 0;
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c == '\\') {
                if (i + 1 < charSequence.length()) {
                    int n2;
                    if (TextFormat.isOctal(c = charSequence.charAt(++i))) {
                        n2 = TextFormat.digitValue(c);
                        if (i + 1 < charSequence.length() && TextFormat.isOctal(charSequence.charAt(i + 1))) {
                            n2 = n2 * 8 + TextFormat.digitValue(charSequence.charAt(++i));
                        }
                        if (i + 1 < charSequence.length() && TextFormat.isOctal(charSequence.charAt(i + 1))) {
                            n2 = n2 * 8 + TextFormat.digitValue(charSequence.charAt(++i));
                        }
                        byArray[n++] = (byte)n2;
                        continue;
                    }
                    switch (c) {
                        case 'a': {
                            byArray[n++] = 7;
                            break;
                        }
                        case 'b': {
                            byArray[n++] = 8;
                            break;
                        }
                        case 'f': {
                            byArray[n++] = 12;
                            break;
                        }
                        case 'n': {
                            byArray[n++] = 10;
                            break;
                        }
                        case 'r': {
                            byArray[n++] = 13;
                            break;
                        }
                        case 't': {
                            byArray[n++] = 9;
                            break;
                        }
                        case 'v': {
                            byArray[n++] = 11;
                            break;
                        }
                        case '\\': {
                            byArray[n++] = 92;
                            break;
                        }
                        case '\'': {
                            byArray[n++] = 39;
                            break;
                        }
                        case '\"': {
                            byArray[n++] = 34;
                            break;
                        }
                        case 'x': {
                            n2 = 0;
                            if (i + 1 >= charSequence.length() || !TextFormat.isHex(charSequence.charAt(i + 1))) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\x' with no digits");
                            }
                            n2 = TextFormat.digitValue(charSequence.charAt(++i));
                            if (i + 1 < charSequence.length() && TextFormat.isHex(charSequence.charAt(i + 1))) {
                                n2 = n2 * 16 + TextFormat.digitValue(charSequence.charAt(++i));
                            }
                            byArray[n++] = (byte)n2;
                            break;
                        }
                        default: {
                            throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\" + c + '\'');
                        }
                    }
                    continue;
                }
                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\' at end of string.");
            }
            byArray[n++] = (byte)c;
        }
        return ByteString.copyFrom(byArray, 0, n);
    }

    static String escapeText(String string) {
        return TextFormat.escapeBytes(ByteString.copyFromUtf8(string));
    }

    static String unescapeText(String string) throws InvalidEscapeSequenceException {
        return TextFormat.unescapeBytes(string).toStringUtf8();
    }

    private static boolean isOctal(char c) {
        return '0' <= c && c <= '7';
    }

    private static boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    private static int digitValue(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'z') {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }

    static int parseInt32(String string) throws NumberFormatException {
        return (int)TextFormat.parseInteger(string, true, false);
    }

    static int parseUInt32(String string) throws NumberFormatException {
        return (int)TextFormat.parseInteger(string, false, false);
    }

    static long parseInt64(String string) throws NumberFormatException {
        return TextFormat.parseInteger(string, true, true);
    }

    static long parseUInt64(String string) throws NumberFormatException {
        return TextFormat.parseInteger(string, false, true);
    }

    private static long parseInteger(String string, boolean bl, boolean bl2) throws NumberFormatException {
        int n = 0;
        boolean bl3 = false;
        if (string.startsWith("-", n)) {
            if (!bl) {
                throw new NumberFormatException("Number must be positive: " + string);
            }
            ++n;
            bl3 = true;
        }
        int n2 = 10;
        if (string.startsWith("0x", n)) {
            n += 2;
            n2 = 16;
        } else if (string.startsWith("0", n)) {
            n2 = 8;
        }
        String string2 = string.substring(n);
        long l = 0L;
        if (string2.length() < 16) {
            l = Long.parseLong(string2, n2);
            if (bl3) {
                l = -l;
            }
            if (!bl2) {
                if (bl) {
                    if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + string);
                    }
                } else if (l >= 0x100000000L || l < 0L) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + string);
                }
            }
        } else {
            BigInteger bigInteger = new BigInteger(string2, n2);
            if (bl3) {
                bigInteger = bigInteger.negate();
            }
            if (!bl2) {
                if (bl) {
                    if (bigInteger.bitLength() > 31) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + string);
                    }
                } else if (bigInteger.bitLength() > 32) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + string);
                }
            } else if (bl) {
                if (bigInteger.bitLength() > 63) {
                    throw new NumberFormatException("Number out of range for 64-bit signed integer: " + string);
                }
            } else if (bigInteger.bitLength() > 64) {
                throw new NumberFormatException("Number out of range for 64-bit unsigned integer: " + string);
            }
            l = bigInteger.longValue();
        }
        return l;
    }

    static class InvalidEscapeSequenceException
    extends IOException {
        private static final long serialVersionUID = -8164033650142593304L;

        InvalidEscapeSequenceException(String string) {
            super(string);
        }
    }

    public static class ParseException
    extends IOException {
        private static final long serialVersionUID = 3196188060225107702L;

        public ParseException(String string) {
            super(string);
        }
    }

    private static final class Tokenizer {
        private final CharSequence text;
        private final Matcher matcher;
        private String currentToken;
        private int pos = 0;
        private int line = 0;
        private int column = 0;
        private int previousLine = 0;
        private int previousColumn = 0;
        private static final Pattern WHITESPACE = Pattern.compile("(\\s|(#.*$))++", 8);
        private static final Pattern TOKEN = Pattern.compile("[a-zA-Z_][0-9a-zA-Z_+-]*+|[0-9+-][0-9a-zA-Z_.+-]*+|\"([^\"\n\\\\]|\\\\.)*+(\"|\\\\?$)|'([^\"\n\\\\]|\\\\.)*+('|\\\\?$)", 8);
        private static final Pattern DOUBLE_INFINITY = Pattern.compile("-?inf(inity)?", 2);
        private static final Pattern FLOAT_INFINITY = Pattern.compile("-?inf(inity)?f?", 2);
        private static final Pattern FLOAT_NAN = Pattern.compile("nanf?", 2);

        private Tokenizer(CharSequence charSequence) {
            this.text = charSequence;
            this.matcher = WHITESPACE.matcher(charSequence);
            this.skipWhitespace();
            this.nextToken();
        }

        public boolean atEnd() {
            return this.currentToken.length() == 0;
        }

        public void nextToken() {
            this.previousLine = this.line;
            this.previousColumn = this.column;
            while (this.pos < this.matcher.regionStart()) {
                if (this.text.charAt(this.pos) == '\n') {
                    ++this.line;
                    this.column = 0;
                } else {
                    ++this.column;
                }
                ++this.pos;
            }
            if (this.matcher.regionStart() == this.matcher.regionEnd()) {
                this.currentToken = "";
            } else {
                this.matcher.usePattern(TOKEN);
                if (this.matcher.lookingAt()) {
                    this.currentToken = this.matcher.group();
                    this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
                } else {
                    this.currentToken = String.valueOf(this.text.charAt(this.pos));
                    this.matcher.region(this.pos + 1, this.matcher.regionEnd());
                }
                this.skipWhitespace();
            }
        }

        private void skipWhitespace() {
            this.matcher.usePattern(WHITESPACE);
            if (this.matcher.lookingAt()) {
                this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
            }
        }

        public boolean tryConsume(String string) {
            if (this.currentToken.equals(string)) {
                this.nextToken();
                return true;
            }
            return false;
        }

        public void consume(String string) throws ParseException {
            if (!this.tryConsume(string)) {
                throw this.parseException("Expected \"" + string + "\".");
            }
        }

        public boolean lookingAtInteger() {
            if (this.currentToken.length() == 0) {
                return false;
            }
            char c = this.currentToken.charAt(0);
            return '0' <= c && c <= '9' || c == '-' || c == '+';
        }

        public String consumeIdentifier() throws ParseException {
            for (int i = 0; i < this.currentToken.length(); ++i) {
                char c = this.currentToken.charAt(i);
                if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_' || c == '.') continue;
                throw this.parseException("Expected identifier.");
            }
            String string = this.currentToken;
            this.nextToken();
            return string;
        }

        public int consumeInt32() throws ParseException {
            try {
                int n = TextFormat.parseInt32(this.currentToken);
                this.nextToken();
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.integerParseException(numberFormatException);
            }
        }

        public int consumeUInt32() throws ParseException {
            try {
                int n = TextFormat.parseUInt32(this.currentToken);
                this.nextToken();
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.integerParseException(numberFormatException);
            }
        }

        public long consumeInt64() throws ParseException {
            try {
                long l = TextFormat.parseInt64(this.currentToken);
                this.nextToken();
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.integerParseException(numberFormatException);
            }
        }

        public long consumeUInt64() throws ParseException {
            try {
                long l = TextFormat.parseUInt64(this.currentToken);
                this.nextToken();
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.integerParseException(numberFormatException);
            }
        }

        public double consumeDouble() throws ParseException {
            if (DOUBLE_INFINITY.matcher(this.currentToken).matches()) {
                boolean bl = this.currentToken.startsWith("-");
                this.nextToken();
                return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (this.currentToken.equalsIgnoreCase("nan")) {
                this.nextToken();
                return Double.NaN;
            }
            try {
                double d = Double.parseDouble(this.currentToken);
                this.nextToken();
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.floatParseException(numberFormatException);
            }
        }

        public float consumeFloat() throws ParseException {
            if (FLOAT_INFINITY.matcher(this.currentToken).matches()) {
                boolean bl = this.currentToken.startsWith("-");
                this.nextToken();
                return bl ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
            if (FLOAT_NAN.matcher(this.currentToken).matches()) {
                this.nextToken();
                return Float.NaN;
            }
            try {
                float f = Float.parseFloat(this.currentToken);
                this.nextToken();
                return f;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.floatParseException(numberFormatException);
            }
        }

        public boolean consumeBoolean() throws ParseException {
            if (this.currentToken.equals("true")) {
                this.nextToken();
                return true;
            }
            if (this.currentToken.equals("false")) {
                this.nextToken();
                return false;
            }
            throw this.parseException("Expected \"true\" or \"false\".");
        }

        public String consumeString() throws ParseException {
            return this.consumeByteString().toStringUtf8();
        }

        public ByteString consumeByteString() throws ParseException {
            char c;
            char c2 = c = this.currentToken.length() > 0 ? this.currentToken.charAt(0) : (char)'\u0000';
            if (c != '\"' && c != '\'') {
                throw this.parseException("Expected string.");
            }
            if (this.currentToken.length() < 2 || this.currentToken.charAt(this.currentToken.length() - 1) != c) {
                throw this.parseException("String missing ending quote.");
            }
            try {
                String string = this.currentToken.substring(1, this.currentToken.length() - 1);
                ByteString byteString = TextFormat.unescapeBytes(string);
                this.nextToken();
                return byteString;
            }
            catch (InvalidEscapeSequenceException invalidEscapeSequenceException) {
                throw this.parseException(invalidEscapeSequenceException.getMessage());
            }
        }

        public ParseException parseException(String string) {
            return new ParseException(this.line + 1 + ":" + (this.column + 1) + ": " + string);
        }

        public ParseException parseExceptionPreviousToken(String string) {
            return new ParseException(this.previousLine + 1 + ":" + (this.previousColumn + 1) + ": " + string);
        }

        private ParseException integerParseException(NumberFormatException numberFormatException) {
            return this.parseException("Couldn't parse integer: " + numberFormatException.getMessage());
        }

        private ParseException floatParseException(NumberFormatException numberFormatException) {
            return this.parseException("Couldn't parse number: " + numberFormatException.getMessage());
        }
    }

    private static final class TextGenerator {
        private Appendable output;
        private boolean atStartOfLine = true;
        private final StringBuilder indent = new StringBuilder();

        private TextGenerator(Appendable appendable) {
            this.output = appendable;
        }

        public void indent() {
            this.indent.append("  ");
        }

        public void outdent() {
            int n = this.indent.length();
            if (n == 0) {
                throw new IllegalArgumentException(" Outdent() without matching Indent().");
            }
            this.indent.delete(n - 2, n);
        }

        public void print(CharSequence charSequence) throws IOException {
            int n = charSequence.length();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (charSequence.charAt(i) != '\n') continue;
                this.write(charSequence.subSequence(n2, n), i - n2 + 1);
                n2 = i + 1;
                this.atStartOfLine = true;
            }
            this.write(charSequence.subSequence(n2, n), n - n2);
        }

        private void write(CharSequence charSequence, int n) throws IOException {
            if (n == 0) {
                return;
            }
            if (this.atStartOfLine) {
                this.atStartOfLine = false;
                this.output.append(this.indent);
            }
            this.output.append(charSequence);
        }
    }
}

