/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public final class CodedOutputStream {
    private final byte[] buffer;
    private final int limit;
    private int position;
    private final OutputStream output;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int LITTLE_ENDIAN_32_SIZE = 4;
    public static final int LITTLE_ENDIAN_64_SIZE = 8;

    private CodedOutputStream(byte[] byArray, int n, int n2) {
        this.output = null;
        this.buffer = byArray;
        this.position = n;
        this.limit = n + n2;
    }

    private CodedOutputStream(OutputStream outputStream, byte[] byArray) {
        this.output = outputStream;
        this.buffer = byArray;
        this.position = 0;
        this.limit = byArray.length;
    }

    public static CodedOutputStream newInstance(OutputStream outputStream) {
        return CodedOutputStream.newInstance(outputStream, 4096);
    }

    public static CodedOutputStream newInstance(OutputStream outputStream, int n) {
        return new CodedOutputStream(outputStream, new byte[n]);
    }

    public static CodedOutputStream newInstance(byte[] byArray) {
        return CodedOutputStream.newInstance(byArray, 0, byArray.length);
    }

    public static CodedOutputStream newInstance(byte[] byArray, int n, int n2) {
        return new CodedOutputStream(byArray, n, n2);
    }

    public void writeDouble(int n, double d) throws IOException {
        this.writeTag(n, 1);
        this.writeDoubleNoTag(d);
    }

    public void writeFloat(int n, float f) throws IOException {
        this.writeTag(n, 5);
        this.writeFloatNoTag(f);
    }

    public void writeUInt64(int n, long l) throws IOException {
        this.writeTag(n, 0);
        this.writeUInt64NoTag(l);
    }

    public void writeInt64(int n, long l) throws IOException {
        this.writeTag(n, 0);
        this.writeInt64NoTag(l);
    }

    public void writeInt32(int n, int n2) throws IOException {
        this.writeTag(n, 0);
        this.writeInt32NoTag(n2);
    }

    public void writeFixed64(int n, long l) throws IOException {
        this.writeTag(n, 1);
        this.writeFixed64NoTag(l);
    }

    public void writeFixed32(int n, int n2) throws IOException {
        this.writeTag(n, 5);
        this.writeFixed32NoTag(n2);
    }

    public void writeBool(int n, boolean bl) throws IOException {
        this.writeTag(n, 0);
        this.writeBoolNoTag(bl);
    }

    public void writeString(int n, String string) throws IOException {
        this.writeTag(n, 2);
        this.writeStringNoTag(string);
    }

    public void writeGroup(int n, MessageLite messageLite) throws IOException {
        this.writeTag(n, 3);
        this.writeGroupNoTag(messageLite);
        this.writeTag(n, 4);
    }

    @Deprecated
    public void writeUnknownGroup(int n, MessageLite messageLite) throws IOException {
        this.writeGroup(n, messageLite);
    }

    public void writeMessage(int n, MessageLite messageLite) throws IOException {
        this.writeTag(n, 2);
        this.writeMessageNoTag(messageLite);
    }

    public void writeBytes(int n, ByteString byteString) throws IOException {
        this.writeTag(n, 2);
        this.writeBytesNoTag(byteString);
    }

    public void writeUInt32(int n, int n2) throws IOException {
        this.writeTag(n, 0);
        this.writeUInt32NoTag(n2);
    }

    public void writeEnum(int n, int n2) throws IOException {
        this.writeTag(n, 0);
        this.writeEnumNoTag(n2);
    }

    public void writeSFixed32(int n, int n2) throws IOException {
        this.writeTag(n, 5);
        this.writeSFixed32NoTag(n2);
    }

    public void writeSFixed64(int n, long l) throws IOException {
        this.writeTag(n, 1);
        this.writeSFixed64NoTag(l);
    }

    public void writeSInt32(int n, int n2) throws IOException {
        this.writeTag(n, 0);
        this.writeSInt32NoTag(n2);
    }

    public void writeSInt64(int n, long l) throws IOException {
        this.writeTag(n, 0);
        this.writeSInt64NoTag(l);
    }

    public void writeMessageSetExtension(int n, MessageLite messageLite) throws IOException {
        this.writeTag(1, 3);
        this.writeUInt32(2, n);
        this.writeMessage(3, messageLite);
        this.writeTag(1, 4);
    }

    public void writeRawMessageSetExtension(int n, ByteString byteString) throws IOException {
        this.writeTag(1, 3);
        this.writeUInt32(2, n);
        this.writeBytes(3, byteString);
        this.writeTag(1, 4);
    }

    public void writeDoubleNoTag(double d) throws IOException {
        this.writeRawLittleEndian64(Double.doubleToRawLongBits(d));
    }

    public void writeFloatNoTag(float f) throws IOException {
        this.writeRawLittleEndian32(Float.floatToRawIntBits(f));
    }

    public void writeUInt64NoTag(long l) throws IOException {
        this.writeRawVarint64(l);
    }

    public void writeInt64NoTag(long l) throws IOException {
        this.writeRawVarint64(l);
    }

    public void writeInt32NoTag(int n) throws IOException {
        if (n >= 0) {
            this.writeRawVarint32(n);
        } else {
            this.writeRawVarint64(n);
        }
    }

    public void writeFixed64NoTag(long l) throws IOException {
        this.writeRawLittleEndian64(l);
    }

    public void writeFixed32NoTag(int n) throws IOException {
        this.writeRawLittleEndian32(n);
    }

    public void writeBoolNoTag(boolean bl) throws IOException {
        this.writeRawByte(bl ? 1 : 0);
    }

    public void writeStringNoTag(String string) throws IOException {
        byte[] byArray = string.getBytes("UTF-8");
        this.writeRawVarint32(byArray.length);
        this.writeRawBytes(byArray);
    }

    public void writeGroupNoTag(MessageLite messageLite) throws IOException {
        messageLite.writeTo(this);
    }

    @Deprecated
    public void writeUnknownGroupNoTag(MessageLite messageLite) throws IOException {
        this.writeGroupNoTag(messageLite);
    }

    public void writeMessageNoTag(MessageLite messageLite) throws IOException {
        this.writeRawVarint32(messageLite.getSerializedSize());
        messageLite.writeTo(this);
    }

    public void writeBytesNoTag(ByteString byteString) throws IOException {
        byte[] byArray = byteString.toByteArray();
        this.writeRawVarint32(byArray.length);
        this.writeRawBytes(byArray);
    }

    public void writeUInt32NoTag(int n) throws IOException {
        this.writeRawVarint32(n);
    }

    public void writeEnumNoTag(int n) throws IOException {
        this.writeRawVarint32(n);
    }

    public void writeSFixed32NoTag(int n) throws IOException {
        this.writeRawLittleEndian32(n);
    }

    public void writeSFixed64NoTag(long l) throws IOException {
        this.writeRawLittleEndian64(l);
    }

    public void writeSInt32NoTag(int n) throws IOException {
        this.writeRawVarint32(CodedOutputStream.encodeZigZag32(n));
    }

    public void writeSInt64NoTag(long l) throws IOException {
        this.writeRawVarint64(CodedOutputStream.encodeZigZag64(l));
    }

    public static int computeDoubleSize(int n, double d) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeDoubleSizeNoTag(d);
    }

    public static int computeFloatSize(int n, float f) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeFloatSizeNoTag(f);
    }

    public static int computeUInt64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeUInt64SizeNoTag(l);
    }

    public static int computeInt64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeInt64SizeNoTag(l);
    }

    public static int computeInt32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeInt32SizeNoTag(n2);
    }

    public static int computeFixed64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeFixed64SizeNoTag(l);
    }

    public static int computeFixed32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeFixed32SizeNoTag(n2);
    }

    public static int computeBoolSize(int n, boolean bl) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeBoolSizeNoTag(bl);
    }

    public static int computeStringSize(int n, String string) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeStringSizeNoTag(string);
    }

    public static int computeGroupSize(int n, MessageLite messageLite) {
        return CodedOutputStream.computeTagSize(n) * 2 + CodedOutputStream.computeGroupSizeNoTag(messageLite);
    }

    @Deprecated
    public static int computeUnknownGroupSize(int n, MessageLite messageLite) {
        return CodedOutputStream.computeGroupSize(n, messageLite);
    }

    public static int computeMessageSize(int n, MessageLite messageLite) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeMessageSizeNoTag(messageLite);
    }

    public static int computeBytesSize(int n, ByteString byteString) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeBytesSizeNoTag(byteString);
    }

    public static int computeUInt32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeUInt32SizeNoTag(n2);
    }

    public static int computeEnumSize(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeEnumSizeNoTag(n2);
    }

    public static int computeSFixed32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeSFixed32SizeNoTag(n2);
    }

    public static int computeSFixed64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeSFixed64SizeNoTag(l);
    }

    public static int computeSInt32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeSInt32SizeNoTag(n2);
    }

    public static int computeSInt64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeSInt64SizeNoTag(l);
    }

    public static int computeMessageSetExtensionSize(int n, MessageLite messageLite) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, n) + CodedOutputStream.computeMessageSize(3, messageLite);
    }

    public static int computeRawMessageSetExtensionSize(int n, ByteString byteString) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, n) + CodedOutputStream.computeBytesSize(3, byteString);
    }

    public static int computeDoubleSizeNoTag(double d) {
        return 8;
    }

    public static int computeFloatSizeNoTag(float f) {
        return 4;
    }

    public static int computeUInt64SizeNoTag(long l) {
        return CodedOutputStream.computeRawVarint64Size(l);
    }

    public static int computeInt64SizeNoTag(long l) {
        return CodedOutputStream.computeRawVarint64Size(l);
    }

    public static int computeInt32SizeNoTag(int n) {
        if (n >= 0) {
            return CodedOutputStream.computeRawVarint32Size(n);
        }
        return 10;
    }

    public static int computeFixed64SizeNoTag(long l) {
        return 8;
    }

    public static int computeFixed32SizeNoTag(int n) {
        return 4;
    }

    public static int computeBoolSizeNoTag(boolean bl) {
        return 1;
    }

    public static int computeStringSizeNoTag(String string) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            return CodedOutputStream.computeRawVarint32Size(byArray.length) + byArray.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 not supported.", unsupportedEncodingException);
        }
    }

    public static int computeGroupSizeNoTag(MessageLite messageLite) {
        return messageLite.getSerializedSize();
    }

    @Deprecated
    public static int computeUnknownGroupSizeNoTag(MessageLite messageLite) {
        return CodedOutputStream.computeGroupSizeNoTag(messageLite);
    }

    public static int computeMessageSizeNoTag(MessageLite messageLite) {
        int n = messageLite.getSerializedSize();
        return CodedOutputStream.computeRawVarint32Size(n) + n;
    }

    public static int computeBytesSizeNoTag(ByteString byteString) {
        return CodedOutputStream.computeRawVarint32Size(byteString.size()) + byteString.size();
    }

    public static int computeUInt32SizeNoTag(int n) {
        return CodedOutputStream.computeRawVarint32Size(n);
    }

    public static int computeEnumSizeNoTag(int n) {
        return CodedOutputStream.computeRawVarint32Size(n);
    }

    public static int computeSFixed32SizeNoTag(int n) {
        return 4;
    }

    public static int computeSFixed64SizeNoTag(long l) {
        return 8;
    }

    public static int computeSInt32SizeNoTag(int n) {
        return CodedOutputStream.computeRawVarint32Size(CodedOutputStream.encodeZigZag32(n));
    }

    public static int computeSInt64SizeNoTag(long l) {
        return CodedOutputStream.computeRawVarint64Size(CodedOutputStream.encodeZigZag64(l));
    }

    private void refreshBuffer() throws IOException {
        if (this.output == null) {
            throw new OutOfSpaceException();
        }
        this.output.write(this.buffer, 0, this.position);
        this.position = 0;
    }

    public void flush() throws IOException {
        if (this.output != null) {
            this.refreshBuffer();
        }
    }

    public int spaceLeft() {
        if (this.output == null) {
            return this.limit - this.position;
        }
        throw new UnsupportedOperationException("spaceLeft() can only be called on CodedOutputStreams that are writing to a flat array.");
    }

    public void checkNoSpaceLeft() {
        if (this.spaceLeft() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public void writeRawByte(byte by) throws IOException {
        if (this.position == this.limit) {
            this.refreshBuffer();
        }
        this.buffer[this.position++] = by;
    }

    public void writeRawByte(int n) throws IOException {
        this.writeRawByte((byte)n);
    }

    public void writeRawBytes(byte[] byArray) throws IOException {
        this.writeRawBytes(byArray, 0, byArray.length);
    }

    public void writeRawBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this.limit - this.position >= n2) {
            System.arraycopy(byArray, n, this.buffer, this.position, n2);
            this.position += n2;
        } else {
            int n3 = this.limit - this.position;
            System.arraycopy(byArray, n, this.buffer, this.position, n3);
            n += n3;
            this.position = this.limit;
            this.refreshBuffer();
            if ((n2 -= n3) <= this.limit) {
                System.arraycopy(byArray, n, this.buffer, 0, n2);
                this.position = n2;
            } else {
                this.output.write(byArray, n, n2);
            }
        }
    }

    public void writeTag(int n, int n2) throws IOException {
        this.writeRawVarint32(WireFormat.makeTag(n, n2));
    }

    public static int computeTagSize(int n) {
        return CodedOutputStream.computeRawVarint32Size(WireFormat.makeTag(n, 0));
    }

    public void writeRawVarint32(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.writeRawByte(n);
                return;
            }
            this.writeRawByte(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int computeRawVarint32Size(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void writeRawVarint64(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeRawByte((int)l);
                return;
            }
            this.writeRawByte((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int computeRawVarint64Size(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void writeRawLittleEndian32(int n) throws IOException {
        this.writeRawByte(n & 0xFF);
        this.writeRawByte(n >> 8 & 0xFF);
        this.writeRawByte(n >> 16 & 0xFF);
        this.writeRawByte(n >> 24 & 0xFF);
    }

    public void writeRawLittleEndian64(long l) throws IOException {
        this.writeRawByte((int)l & 0xFF);
        this.writeRawByte((int)(l >> 8) & 0xFF);
        this.writeRawByte((int)(l >> 16) & 0xFF);
        this.writeRawByte((int)(l >> 24) & 0xFF);
        this.writeRawByte((int)(l >> 32) & 0xFF);
        this.writeRawByte((int)(l >> 40) & 0xFF);
        this.writeRawByte((int)(l >> 48) & 0xFF);
        this.writeRawByte((int)(l >> 56) & 0xFF);
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long l) {
        return l << 1 ^ l >> 63;
    }

    public static class OutOfSpaceException
    extends IOException {
        private static final long serialVersionUID = -6947486886997889499L;

        OutOfSpaceException() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }
    }
}

