/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jni.registry;

import com.ice.jni.registry.RegistryKey;
import com.ice.jni.registry.RegistryValue;
import java.io.PrintWriter;

public class RegMultiStringValue
extends RegistryValue {
    String[] data;
    int dataLen;

    public RegMultiStringValue(RegistryKey key, String name) {
        super(key, name, 7);
        this.data = null;
        this.dataLen = 0;
    }

    public RegMultiStringValue(RegistryKey key, String name, int type) {
        super(key, name, type);
        this.data = null;
        this.dataLen = 0;
    }

    public RegMultiStringValue(RegistryKey key, String name, String[] data) {
        super(key, name, 7);
        this.setData(data);
    }

    public String[] getData() {
        return this.data;
    }

    public int getLength() {
        return this.dataLen;
    }

    public void setData(String[] data) {
        this.data = data;
        this.dataLen = data.length;
    }

    public byte[] getByteData() {
        int len = this.getByteLength();
        int ri = 0;
        byte[] result = new byte[len];
        int i = 0;
        while (i < this.dataLen) {
            byte[] strBytes = this.data[i].getBytes();
            int j = 0;
            while (j < strBytes.length) {
                result[ri++] = strBytes[j];
                ++j;
            }
            result[ri++] = 0;
            ++i;
        }
        return result;
    }

    public int getByteLength() {
        int len = 0;
        int i = 0;
        while (i < this.dataLen) {
            len += this.data[i].length() + 1;
            ++i;
        }
        return len;
    }

    public void setByteData(byte[] data) {
        int count = 0;
        int i = 0;
        while (i < data.length) {
            if (data[i] == 0) {
                ++count;
            }
            ++i;
        }
        int si = 0;
        String[] newData = new String[count];
        int start = 0;
        int i2 = 0;
        while (i2 < data.length) {
            if (data[i2] == 0) {
                newData[si] = new String(data, start, i2 - start);
                start = si;
            }
            ++i2;
        }
        this.setData(newData);
    }

    public void export(PrintWriter out) {
        int dataLen = 0;
        out.println("\"" + this.getName() + "\"=hex(7):\\");
        int i = 0;
        while (i < this.data.length) {
            dataLen += this.data[i].length() + 1;
            ++i;
        }
        int idx = 0;
        byte[] hexData = new byte[++dataLen];
        int i2 = 0;
        while (i2 < this.data.length) {
            int strLen = this.data[i2].length();
            byte[] strBytes = this.data[i2].getBytes();
            System.arraycopy(strBytes, 0, hexData, idx, strLen);
            idx += strLen;
            hexData[idx++] = 0;
            ++i2;
        }
        hexData[idx++] = 0;
        RegistryValue.exportHexData(out, hexData);
    }
}

