/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath.skeinforge;

import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.util.PythonUtils;
import replicatorg.app.util.StreamLoggerThread;
import replicatorg.model.BuildCode;
import replicatorg.plugin.toolpath.ToolpathGenerator;
import replicatorg.plugin.toolpath.skeinforge.ConfigurationDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SkeinforgeGenerator
extends ToolpathGenerator {
    boolean configSuccess = false;
    String profile = null;
    List<SkeinforgePreference> preferences = this.getPreferences();

    public static String getSelectedProfile() {
        String name = Base.preferences.get("replicatorg.skeinforge.profile", "");
        return name;
    }

    public static void setSelectedProfile(String name) {
        Base.preferences.put("replicatorg.skeinforge.profile", name);
    }

    void getProfilesIn(File dir, List<Profile> profiles) {
        if (dir.exists() && dir.isDirectory()) {
            for (String subpath : dir.list()) {
                File subDir = new File(dir, subpath);
                if (!subDir.isDirectory()) continue;
                profiles.add(new Profile(subDir.getAbsolutePath()));
            }
        }
    }

    public abstract File getUserProfilesDir();

    List<Profile> getProfiles() {
        LinkedList<Profile> profiles = new LinkedList<Profile>();
        File dir = new File(this.getSkeinforgeDir(), "prefs");
        this.getProfilesIn(dir, profiles);
        dir = this.getUserProfilesDir();
        this.getProfilesIn(dir, profiles);
        Collections.sort(profiles);
        return profiles;
    }

    @Override
    public boolean visualConfigure(Frame parent) {
        boolean hasPython = PythonUtils.interactiveCheckVersion(parent, "Generating gcode", new PythonUtils.Version(2, 5, 0), new PythonUtils.Version(3, 0, 0));
        if (!hasPython) {
            return false;
        }
        boolean hasTkInter = PythonUtils.interactiveCheckTkInter(parent, "Generating gcode");
        if (!hasTkInter) {
            return false;
        }
        ConfigurationDialog cd = new ConfigurationDialog(parent, this);
        double x = parent.getBounds().getCenterX();
        double y = parent.getBounds().getCenterY();
        cd.pack();
        cd.setLocation((int)(x -= (double)cd.getWidth() / 2.0), (int)(y -= (double)cd.getHeight() / 2.0));
        cd.setVisible(true);
        return this.configSuccess;
    }

    public abstract File getDefaultSkeinforgeDir();

    public File getSkeinforgeDir() {
        String skeinforgePath = System.getProperty("replicatorg.skeinforge.path");
        if (skeinforgePath == null || skeinforgePath.length() == 0) {
            return this.getDefaultSkeinforgeDir();
        }
        return new File(skeinforgePath);
    }

    public Profile duplicateProfile(Profile originalProfile, String newName) {
        File newProfDir = new File(this.getUserProfilesDir(), newName);
        File oldProfDir = new File(originalProfile.getFullPath());
        try {
            Base.copyDir(oldProfDir, newProfDir);
            Profile newProf = new Profile(newProfDir.getAbsolutePath());
            this.editProfile(newProf);
            return newProf;
        }
        catch (IOException ioe) {
            Base.logger.log(Level.SEVERE, "Couldn't copy directory", ioe);
            return null;
        }
    }

    public void editProfile(Profile profile) {
        block4: {
            String[] arguments = new String[]{PythonUtils.getPythonPath(), "skeinforge.py", "-p", profile.getFullPath()};
            ProcessBuilder pb = new ProcessBuilder(arguments);
            File skeinforgeDir = this.getSkeinforgeDir();
            pb.directory(skeinforgeDir);
            Process process = null;
            try {
                process = pb.start();
                int value = process.waitFor();
                if (value != 0) {
                    Base.logger.severe("Unrecognized error code returned by Skeinforge.");
                }
            }
            catch (IOException ioe) {
                Base.logger.log(Level.SEVERE, "Could not run skeinforge.", ioe);
            }
            catch (InterruptedException e) {
                if (process == null) break block4;
                process.destroy();
            }
        }
    }

    public abstract List<SkeinforgePreference> getPreferences();

    @Override
    public BuildCode generateToolpath() {
        String[] baseArguments;
        String path = this.model.getPath();
        LinkedList<String> arguments = new LinkedList<String>();
        for (String arg : baseArguments = new String[]{PythonUtils.getPythonPath(), "-u", "skeinforge.py", "-p", this.profile}) {
            arguments.add(arg);
        }
        for (SkeinforgePreference preference : this.preferences) {
            List<SkeinforgeOption> options = preference.getOptions();
            if (options == null) continue;
            for (SkeinforgeOption option : options) {
                arguments.add(option.getParameter());
                String arg = option.getArgument();
                if (arg.length() <= 0) continue;
                arguments.add(arg);
            }
        }
        arguments.add(path);
        ProcessBuilder pb = new ProcessBuilder(arguments);
        pb.directory(this.getSkeinforgeDir());
        Process process = null;
        try {
            process = pb.start();
            StreamLoggerThread ist = new StreamLoggerThread(process.getInputStream()){

                protected void logMessage(String line) {
                    SkeinforgeGenerator.this.emitUpdate(line);
                    super.logMessage(line);
                }
            };
            StreamLoggerThread est = new StreamLoggerThread(process.getErrorStream());
            est.setDefaultLevel(Level.SEVERE);
            ist.setDefaultLevel(Level.FINE);
            ist.start();
            est.start();
            int value = process.waitFor();
            if (value != 0) {
                Base.logger.severe("Unrecognized error code returned by Skeinforge.");
                return null;
            }
        }
        catch (IOException ioe) {
            Base.logger.log(Level.SEVERE, "Could not run skeinforge.", ioe);
            return null;
        }
        catch (InterruptedException e) {
            if (process != null) {
                process.destroy();
            }
            return null;
        }
        int lastIdx = path.lastIndexOf(46);
        String root = lastIdx >= 0 ? path.substring(0, lastIdx) : path;
        return new BuildCode(root, new File(root + ".gcode"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SkeinforgeBooleanPreference
    implements SkeinforgePreference {
        private boolean isSet;
        private JCheckBox component;
        private List<SkeinforgeOption> trueOptions = new LinkedList<SkeinforgeOption>();
        private List<SkeinforgeOption> falseOptions = new LinkedList<SkeinforgeOption>();

        public SkeinforgeBooleanPreference(String name, final String preferenceName, boolean defaultState, String toolTip) {
            this.isSet = defaultState;
            if (preferenceName != null) {
                this.isSet = Base.preferences.getBoolean(preferenceName, defaultState);
            }
            this.component = new JCheckBox(name, this.isSet);
            this.component.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SkeinforgeBooleanPreference.this.isSet = SkeinforgeBooleanPreference.this.component.isSelected();
                    if (preferenceName != null) {
                        Base.preferences.putBoolean(preferenceName, SkeinforgeBooleanPreference.this.isSet);
                    }
                }
            });
            if (toolTip != null) {
                this.component.setToolTipText(toolTip);
            }
        }

        @Override
        public JComponent getUI() {
            return this.component;
        }

        public void addTrueOption(SkeinforgeOption o) {
            this.trueOptions.add(o);
        }

        public void addFalseOption(SkeinforgeOption o) {
            this.falseOptions.add(o);
        }

        public void addNegateableOption(SkeinforgeOption o) {
            this.trueOptions.add(o);
            String negated = o.value.equalsIgnoreCase("true") ? "false" : "true";
            this.falseOptions.add(new SkeinforgeOption(o.module, o.preference, negated));
        }

        @Override
        public List<SkeinforgeOption> getOptions() {
            return this.isSet ? this.trueOptions : this.falseOptions;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SkeinforgeChoicePreference
    implements SkeinforgePreference {
        private Map<String, List<SkeinforgeOption>> optionsMap = new HashMap<String, List<SkeinforgeOption>>();
        private JPanel component = new JPanel((LayoutManager)new MigLayout());
        private DefaultComboBoxModel model;
        private String chosen;

        public SkeinforgeChoicePreference(String name, final String preferenceName, String defaultState, String toolTip) {
            this.chosen = defaultState;
            if (preferenceName != null) {
                this.chosen = Base.preferences.get(preferenceName, defaultState);
            }
            this.model = new DefaultComboBoxModel();
            this.model.setSelectedItem(this.chosen);
            this.component.add(new JLabel(name));
            JComboBox cb = new JComboBox(this.model);
            this.component.add(cb);
            cb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SkeinforgeChoicePreference.this.chosen = (String)SkeinforgeChoicePreference.this.model.getSelectedItem();
                    if (preferenceName != null) {
                        Base.preferences.put(preferenceName, SkeinforgeChoicePreference.this.chosen);
                    }
                }
            });
            if (toolTip != null) {
                this.component.setToolTipText(toolTip);
            }
        }

        @Override
        public JComponent getUI() {
            return this.component;
        }

        public void addOption(String name, SkeinforgeOption o) {
            if (!this.optionsMap.containsKey(name)) {
                this.model.addElement(name);
                this.optionsMap.put(name, new LinkedList());
                if (name.equals(this.chosen)) {
                    this.model.setSelectedItem(name);
                }
            }
            List<SkeinforgeOption> list = this.optionsMap.get(name);
            list.add(o);
        }

        @Override
        public List<SkeinforgeOption> getOptions() {
            if (this.optionsMap.containsKey(this.chosen)) {
                List<SkeinforgeOption> l = this.optionsMap.get(this.chosen);
                for (SkeinforgeOption o : l) {
                    System.err.println(o.getArgument());
                }
                return this.optionsMap.get(this.chosen);
            }
            return new LinkedList<SkeinforgeOption>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface SkeinforgePreference {
        public JComponent getUI();

        public List<SkeinforgeOption> getOptions();
    }

    protected static class SkeinforgeOption {
        final String parameter;
        final String module;
        final String preference;
        final String value;

        public SkeinforgeOption(String module, String preference, String value) {
            this.parameter = "--option";
            this.module = module;
            this.preference = preference;
            this.value = value;
        }

        public SkeinforgeOption(String parameter) {
            this.parameter = parameter;
            this.module = null;
            this.preference = null;
            this.value = "";
        }

        public String getParameter() {
            return this.parameter;
        }

        public String getArgument() {
            return (this.module != null ? this.module + ":" : "") + (this.preference != null ? this.preference + "=" : "") + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Profile
    implements Comparable<Profile> {
        private String fullPath;
        private String name;

        public Profile(String fullPath) {
            this.fullPath = fullPath;
            int idx = fullPath.lastIndexOf(File.separatorChar);
            this.name = idx >= 0 ? fullPath.substring(idx + 1) : fullPath;
        }

        public String getFullPath() {
            return this.fullPath;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(Profile o) {
            return this.name.compareTo(o.name);
        }
    }
}

