/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath.skeinforge;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.logging.Level;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.plugin.toolpath.skeinforge.ProfileUtils;
import replicatorg.plugin.toolpath.skeinforge.SkeinforgeGenerator;

class ConfigurationDialog
extends JDialog {
    final String manageStr = "Manage profiles...";
    final String profilePref = "replicatorg.skeinforge.profilePref";
    JButton editButton = new JButton("Edit...");
    JButton duplicateButton = new JButton("Duplicate...");
    JButton deleteButton = new JButton("Delete");
    JButton generate = new JButton("Generate...");
    private WeakReference<SkeinforgeGenerator> parentGenerator;
    private List<SkeinforgeGenerator.Profile> profiles = null;
    final JList prefList = new JList();

    private void loadList(JList list) {
        list.removeAll();
        this.profiles = ((SkeinforgeGenerator)this.parentGenerator.get()).getProfiles();
        DefaultListModel<String> model = new DefaultListModel<String>();
        int i = 0;
        int foundLastProfile = -1;
        for (SkeinforgeGenerator.Profile p : this.profiles) {
            model.addElement(p.toString());
            if (p.toString().equals(Base.preferences.get("lastGeneratorProfileSelected", "---"))) {
                Base.logger.fine("Selecting last used element: " + p);
                foundLastProfile = i;
            }
            ++i;
        }
        list.setModel(model);
        list.clearSelection();
        if (foundLastProfile != -1) {
            list.setSelectedIndex(foundLastProfile);
            this.generate.setEnabled(true);
            this.generate.requestFocusInWindow();
            this.generate.setFocusPainted(true);
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        this.parentGenerator = null;
    }

    private SkeinforgeGenerator.Profile getListedProfile(int idx) {
        return this.profiles.get(idx);
    }

    public ConfigurationDialog(final Frame parent, SkeinforgeGenerator parentGeneratorIn) {
        super(parent, true);
        this.parentGenerator = new WeakReference<SkeinforgeGenerator>(parentGeneratorIn);
        this.setTitle("Choose a skeinforge profile");
        this.setLayout((LayoutManager)new MigLayout("aligny top"));
        this.editButton.setToolTipText("Click to edit this profile's properties.");
        this.deleteButton.setToolTipText("Click to remove this profile. Note that this can not be undone.");
        this.duplicateButton.setToolTipText("This will make a copy of the currently selected profile, with a new name that you provide.");
        this.generate.setEnabled(false);
        this.editButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.duplicateButton.setEnabled(false);
        this.add((Component)new JLabel("Select a printing profile:"), "wrap");
        this.prefList.setSelectionMode(0);
        this.prefList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent selectionEvent) {
                boolean selected = !((JList)selectionEvent.getSource()).isSelectionEmpty();
                ConfigurationDialog.this.generate.setEnabled(selected);
                ConfigurationDialog.this.editButton.setEnabled(selected);
                ConfigurationDialog.this.deleteButton.setEnabled(selected);
                ConfigurationDialog.this.duplicateButton.setEnabled(selected);
            }
        });
        this.prefList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2) {
                    int idx = list.locationToIndex(evt.getPoint());
                    SkeinforgeGenerator.Profile p = ConfigurationDialog.this.getListedProfile(idx);
                    Base.preferences.put("lastGeneratorProfileSelected", p.toString());
                    ((SkeinforgeGenerator)((ConfigurationDialog)ConfigurationDialog.this).parentGenerator.get()).configSuccess = true;
                    ((SkeinforgeGenerator)((ConfigurationDialog)ConfigurationDialog.this).parentGenerator.get()).profile = p.getFullPath();
                    ConfigurationDialog.this.setVisible(false);
                }
            }
        });
        this.loadList(this.prefList);
        this.add((Component)this.prefList, "growy");
        this.prefList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Base.logger.fine("key pressed event: " + e);
                if (e.getKeyCode() == 10) {
                    int idx = ConfigurationDialog.this.prefList.getSelectedIndex();
                    Base.logger.fine("idx=" + idx);
                    SkeinforgeGenerator.Profile p = ConfigurationDialog.this.getListedProfile(idx);
                    Base.preferences.put("lastGeneratorProfileSelected", p.toString());
                    ((SkeinforgeGenerator)((ConfigurationDialog)ConfigurationDialog.this).parentGenerator.get()).configSuccess = true;
                    ((SkeinforgeGenerator)((ConfigurationDialog)ConfigurationDialog.this).parentGenerator.get()).profile = p.getFullPath();
                    ConfigurationDialog.this.setVisible(false);
                } else if (e.getKeyCode() == 27) {
                    ConfigurationDialog.this.setVisible(false);
                }
            }
        });
        this.add((Component)this.editButton, "split,flowy,growx");
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int idx = ConfigurationDialog.this.prefList.getSelectedIndex();
                if (idx == -1) {
                    JOptionPane.showMessageDialog(parent, "Select a profile to edit.");
                } else {
                    SkeinforgeGenerator.Profile p = ConfigurationDialog.this.getListedProfile(idx);
                    ((SkeinforgeGenerator)ConfigurationDialog.this.parentGenerator.get()).editProfile(p);
                }
            }
        });
        this.add((Component)this.duplicateButton, "growx,flowy");
        this.duplicateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int idx = ConfigurationDialog.this.prefList.getSelectedIndex();
                String newName = JOptionPane.showInputDialog(parent, (Object)"Name your new profile:");
                if (newName != null) {
                    SkeinforgeGenerator.Profile p = ConfigurationDialog.this.getListedProfile(idx);
                    SkeinforgeGenerator.Profile newp = ((SkeinforgeGenerator)ConfigurationDialog.this.parentGenerator.get()).duplicateProfile(p, newName);
                    ConfigurationDialog.this.loadList(ConfigurationDialog.this.prefList);
                    if (newp != null) {
                        ConfigurationDialog.this.prefList.setSelectedValue(newp.toString(), true);
                    }
                    ConfigurationDialog.this.pack();
                }
            }
        });
        this.add((Component)this.deleteButton, "wrap,growx");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int idx = ConfigurationDialog.this.prefList.getSelectedIndex();
                SkeinforgeGenerator.Profile p = ConfigurationDialog.this.getListedProfile(idx);
                boolean result = new ProfileUtils().delete(p);
                ConfigurationDialog.this.loadList(ConfigurationDialog.this.prefList);
                ConfigurationDialog.this.pack();
                Base.logger.log(Level.INFO, "Profile " + p.getFullPath() + " deleted: " + result);
            }
        });
        for (SkeinforgeGenerator.SkeinforgePreference preference : ((SkeinforgeGenerator)this.parentGenerator.get()).preferences) {
            this.add((Component)preference.getUI(), "wrap");
        }
        this.add((Component)this.generate, "tag ok");
        JButton cancel = new JButton("Cancel");
        this.add((Component)cancel, "tag cancel");
        this.generate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                int idx = ConfigurationDialog.this.prefList.getSelectedIndex();
                SkeinforgeGenerator.Profile p = ConfigurationDialog.this.getListedProfile(idx);
                Base.preferences.put("lastGeneratorProfileSelected", p.toString());
                ((SkeinforgeGenerator)((ConfigurationDialog)ConfigurationDialog.this).parentGenerator.get()).configSuccess = true;
                ((SkeinforgeGenerator)((ConfigurationDialog)ConfigurationDialog.this).parentGenerator.get()).profile = p.getFullPath();
                ConfigurationDialog.this.setVisible(false);
                SkeinforgeGenerator.setSelectedProfile(p.toString());
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ((SkeinforgeGenerator)((ConfigurationDialog)ConfigurationDialog.this).parentGenerator.get()).configSuccess = false;
                ConfigurationDialog.this.setVisible(false);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                ConfigurationDialog.this.profiles = null;
                super.windowClosed(e);
            }
        });
    }
}

