/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers.reprap;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Node;
import replicatorg.app.Base;
import replicatorg.app.util.serial.Serial;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.SerialDriver;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.ToolModel;
import replicatorg.util.Point5d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRepRap5DDriver
extends SerialDriver {
    private Queue<Integer> commands;
    private int maxBufferSize = 128;
    private int bufferSize = 0;
    private String result = "";
    private DecimalFormat df;
    private byte[] responsebuffer = new byte[512];

    public SimpleRepRap5DDriver() {
        this.commands = new LinkedList<Integer>();
        this.setInitialized(false);
        this.df = new DecimalFormat("#.######");
    }

    @Override
    public void loadXML(Node xml) {
        super.loadXML(xml);
    }

    @Override
    public void initialize() {
        if (this.serial == null) {
            Base.logger.severe("No Serial Port found.\n");
            return;
        }
        if (!this.isInitialized()) {
            try {
                Date date = new Date();
                long end2 = date.getTime() + 10000L;
                Base.logger.info("Initializing Serial.");
                while (!this.isInitialized()) {
                    this.readResponse();
                    date = new Date();
                    long now = date.getTime();
                    if (now <= end2) continue;
                    Base.logger.warning("Serial link non-responsive.");
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Base.logger.info("Ready.");
        }
        this.sendCommand("G90");
    }

    @Override
    public void execute() {
        this.sendCommand(this.getParser().getCommand());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCommand(String next) {
        assert (this.isInitialized());
        assert (this.serial != null);
        next = this.clean(next);
        if ((next = this.fix(next)).length() == 0) {
            return;
        }
        while (this.bufferSize + next.length() + 1 > this.maxBufferSize) {
            this.readResponse();
        }
        Serial serial = this.serial;
        synchronized (serial) {
            this.serial.write(next + "\n");
        }
        int cmdlen = next.length() + 1;
        this.commands.add(cmdlen);
        this.bufferSize += cmdlen;
        System.out.println("Sent: " + next);
    }

    public String clean(String str) {
        String clean = str;
        clean = clean.trim();
        return clean;
    }

    public String fix(String str) {
        String fixed = str;
        Pattern r = Pattern.compile("M10[123](.*)");
        Matcher m = r.matcher(fixed);
        if (m.find()) {
            return "";
        }
        r = Pattern.compile("^(.*)(F[0-9\\.]*)\\s?E([0-9\\.]*)$");
        m = r.matcher(fixed);
        if (m.find()) {
            fixed = m.group(1) + " E" + m.group(3) + " " + m.group(2);
        }
        return fixed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readResponse() {
        assert (this.serial != null);
        Serial serial = this.serial;
        synchronized (serial) {
            try {
                int index;
                int numread = this.serial.read(this.responsebuffer);
                if (numread < 0) {
                    Base.logger.severe("SerialPassthroughDriver.readResponse(): EOF occured");
                    return;
                }
                this.result = this.result + new String(this.responsebuffer, 0, numread, "US-ASCII");
                while ((index = this.result.indexOf(10)) >= 0) {
                    String line = this.result.substring(0, index).trim();
                    Base.logger.info(line);
                    this.result = this.result.substring(index + 1);
                    if (line.length() == 0) continue;
                    if (line.startsWith("ok")) {
                        this.bufferSize -= this.commands.remove().intValue();
                        Base.logger.info(line);
                        if (!line.startsWith("ok T:")) continue;
                        Pattern r = Pattern.compile("^ok T:([0-9\\.]+)[^0-9]");
                        Matcher m = r.matcher(line);
                        if (m.find()) {
                            String temp = m.group(1);
                            this.machine.currentTool().setCurrentTemperature(Double.parseDouble(temp));
                        }
                        if (!(m = (r = Pattern.compile("^ok.*B:([0-9\\.]+)$")).matcher(line)).find()) continue;
                        String bedTemp = m.group(1);
                        this.machine.currentTool().setPlatformCurrentTemperature(Double.parseDouble(bedTemp));
                        continue;
                    }
                    if (line.startsWith("start")) {
                        this.setInitialized(true);
                        Base.logger.info(line);
                        continue;
                    }
                    if (line.startsWith("Extruder Fail")) {
                        this.setError("Extruder failed:  cannot extrude as this rate.");
                        Base.logger.severe(line);
                        continue;
                    }
                    Base.logger.severe("Unknown: " + line);
                }
            }
            catch (IOException e) {
                Base.logger.severe("inputstream.read() failed: " + e.toString());
            }
        }
    }

    @Override
    public boolean isFinished() {
        return this.isBufferEmpty();
    }

    @Override
    public boolean isBufferEmpty() {
        try {
            this.readResponse();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.bufferSize == 0;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.commands = null;
    }

    @Override
    public void queuePoint(Point5d p) throws RetryException {
        String cmd = "G1 F" + this.df.format(this.getCurrentFeedrate());
        this.sendCommand(cmd);
        cmd = "G1 X" + this.df.format(p.x()) + " Y" + this.df.format(p.y()) + " Z" + this.df.format(p.z()) + " F" + this.df.format(this.getCurrentFeedrate());
        this.sendCommand(cmd);
        super.queuePoint(p);
    }

    @Override
    public void setCurrentPosition(Point5d p) throws RetryException {
        this.sendCommand("G92 X" + this.df.format(p.x()) + " Y" + this.df.format(p.y()) + " Z" + this.df.format(p.z()));
        super.setCurrentPosition(p);
    }

    @Override
    public void homeAxes(EnumSet<AxisId> axes, boolean positive, double feedrate) throws RetryException {
        Base.logger.info("homing " + axes.toString());
        StringBuffer buf = new StringBuffer("G28");
        for (AxisId axis : axes) {
            buf.append(" " + (Object)((Object)axis));
        }
        this.sendCommand(buf.toString());
        super.homeAxes(axes, false, 0.0);
    }

    @Override
    public void delay(long millis) {
        int seconds = Math.round(millis / 1000L);
        this.sendCommand("G4 P" + seconds);
    }

    @Override
    public void openClamp(int clampIndex) {
        this.sendCommand("M11 Q" + clampIndex);
        super.openClamp(clampIndex);
    }

    @Override
    public void closeClamp(int clampIndex) {
        this.sendCommand("M10 Q" + clampIndex);
        super.closeClamp(clampIndex);
    }

    @Override
    public void enableDrives() throws RetryException {
        this.sendCommand("M17");
        super.enableDrives();
    }

    @Override
    public void disableDrives() throws RetryException {
        this.sendCommand("M18");
        super.disableDrives();
    }

    @Override
    public void changeGearRatio(int ratioIndex) {
        int code = 40 + ratioIndex;
        code = Math.max(40, code);
        code = Math.min(46, code);
        this.sendCommand("M" + code);
        super.changeGearRatio(ratioIndex);
    }

    protected String _getToolCode() {
        return "T" + this.machine.currentTool().getIndex() + " ";
    }

    @Override
    public void setMotorRPM(double rpm) throws RetryException {
        this.sendCommand(this._getToolCode() + "M108 R" + this.df.format(rpm));
        super.setMotorRPM(rpm);
    }

    @Override
    public void setMotorSpeedPWM(int pwm) throws RetryException {
        this.sendCommand(this._getToolCode() + "M108 S" + this.df.format(pwm));
        super.setMotorSpeedPWM(pwm);
    }

    @Override
    public void enableMotor() throws RetryException {
        String command = this._getToolCode();
        command = this.machine.currentTool().getMotorDirection() == ToolModel.MOTOR_CLOCKWISE ? command + "M101" : command + "M102";
        this.sendCommand(command);
        super.enableMotor();
    }

    @Override
    public void disableMotor() throws RetryException {
        this.sendCommand(this._getToolCode() + "M103");
        super.disableMotor();
    }

    @Override
    public void setSpindleRPM(double rpm) throws RetryException {
        this.sendCommand(this._getToolCode() + "S" + this.df.format(rpm));
        super.setSpindleRPM(rpm);
    }

    @Override
    public void enableSpindle() throws RetryException {
        String command = this._getToolCode();
        command = this.machine.currentTool().getSpindleDirection() == ToolModel.MOTOR_CLOCKWISE ? command + "M3" : command + "M4";
        this.sendCommand(command);
        super.enableSpindle();
    }

    @Override
    public void disableSpindle() throws RetryException {
        this.sendCommand(this._getToolCode() + "M5");
        super.disableSpindle();
    }

    @Override
    public void setTemperature(double temperature) throws RetryException {
        this.sendCommand(this._getToolCode() + "M104 S" + this.df.format(temperature));
        super.setTemperature(temperature);
    }

    @Override
    public void readTemperature() {
        this.sendCommand(this._getToolCode() + "M105");
        super.readTemperature();
    }

    @Override
    public double getPlatformTemperature() {
        return this.machine.currentTool().getPlatformCurrentTemperature();
    }

    @Override
    public void enableFloodCoolant() {
        this.sendCommand(this._getToolCode() + "M7");
        super.enableFloodCoolant();
    }

    @Override
    public void disableFloodCoolant() {
        this.sendCommand(this._getToolCode() + "M9");
        super.disableFloodCoolant();
    }

    @Override
    public void enableMistCoolant() {
        this.sendCommand(this._getToolCode() + "M8");
        super.enableMistCoolant();
    }

    @Override
    public void disableMistCoolant() {
        this.sendCommand(this._getToolCode() + "M9");
        super.disableMistCoolant();
    }

    @Override
    public void enableFan() throws RetryException {
        this.sendCommand(this._getToolCode() + "M106");
        super.enableFan();
    }

    @Override
    public void disableFan() throws RetryException {
        this.sendCommand(this._getToolCode() + "M107");
        super.disableFan();
    }

    @Override
    public void openValve() throws RetryException {
        this.sendCommand(this._getToolCode() + "M126");
        super.openValve();
    }

    @Override
    public void closeValve() throws RetryException {
        this.sendCommand(this._getToolCode() + "M127");
        super.closeValve();
    }

    @Override
    public void openCollet() {
        this.sendCommand(this._getToolCode() + "M21");
        super.openCollet();
    }

    @Override
    public void closeCollet() {
        this.sendCommand(this._getToolCode() + "M22");
        super.closeCollet();
    }

    @Override
    public void reset() {
        Base.logger.info("Reset.");
        this.setInitialized(false);
        this.initialize();
    }

    @Override
    protected Point5d reconcilePosition() {
        return new Point5d();
    }
}

