/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers.reprap;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import replicatorg.drivers.reprap.RepRap5DDriver;

public class ExtrusionUpdater {
    private final RepRap5DDriver driver;
    public final AtomicBoolean isExtruding = new AtomicBoolean(false);
    private ReentrantLock feedrateLock = new ReentrantLock();
    private double feedrate = 0.0;
    private ReentrantLock directionLock = new ReentrantLock();
    private Direction direction = Direction.forward;
    private long extrudeQueueEnd = 0L;
    private long commandPeriod = 100L;
    private int maxQueuedExtrudeTime = 500;

    public ExtrusionUpdater(RepRap5DDriver driver) {
        this.driver = driver;
    }

    private void sendExtrudeCommand(double distance, double feedrate) {
        String feedrateString = this.driver.df.format(feedrate);
        if (this.driver.feedrate.get() != feedrate) {
            this.driver.sendCommand(this.driver._getToolCode() + "G1 F" + feedrateString);
        }
        this.driver.sendCommand(this.driver._getToolCode() + "G1 E" + this.driver.df.format(distance + this.driver.ePosition.get()) + " F" + feedrateString);
    }

    public void setFeedrate(double feedrate) {
        this.feedrateLock.lock();
        this.feedrate = feedrate;
        this.feedrateLock.unlock();
    }

    private double getFeedrate() {
        this.feedrateLock.lock();
        double f = this.feedrate;
        this.feedrateLock.unlock();
        this.directionLock.lock();
        double d = this.direction == Direction.forward ? 1.0 : -1.0;
        this.directionLock.unlock();
        return f *= d;
    }

    public void setDirection(Direction direction) {
        this.directionLock.lock();
        this.direction = direction;
        this.directionLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws InterruptedException {
        if (this.isExtruding.get()) {
            int queueSize;
            long currentTime = System.currentTimeMillis();
            if (this.extrudeQueueEnd > currentTime + (long)this.maxQueuedExtrudeTime) {
                Thread.sleep(this.extrudeQueueEnd - currentTime);
            }
            do {
                Queue<Integer> queue = this.driver.commands;
                synchronized (queue) {
                    queueSize = this.driver.commands.size();
                }
                if (queueSize <= this.maxQueuedExtrudeTime) continue;
                Thread.sleep(100L);
            } while (queueSize > this.maxQueuedExtrudeTime);
            double feedrate = this.getFeedrate();
            if (feedrate == 0.0) {
                return;
            }
            double distance = feedrate * (double)this.commandPeriod / 60000.0;
            RepRap5DDriver repRap5DDriver = this.driver;
            synchronized (repRap5DDriver) {
                this.extrudeQueueEnd = this.extrudeQueueEnd < System.currentTimeMillis() ? System.currentTimeMillis() + this.commandPeriod : (this.extrudeQueueEnd += this.commandPeriod);
                this.sendExtrudeCommand(distance, Math.abs(feedrate));
            }
        }
        Thread.sleep(100L);
    }

    public void startExtruding() {
        this.isExtruding.set(true);
    }

    public void stopExtruding() {
        this.isExtruding.set(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        forward,
        reverse;

    }
}

