/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers.gen3;

import java.util.logging.Level;
import replicatorg.app.Base;

public class PacketResponse {
    byte[] payload;
    int readPoint = 1;

    public PacketResponse() {
        this.payload = null;
    }

    public PacketResponse(byte[] p) {
        this.payload = p;
    }

    public boolean isEmpty() {
        return this.payload == null;
    }

    public void printDebug() {
        ResponseCode code = this.getResponseCode();
        String msg = code.getMessage();
        Level level = Level.INFO;
        if (code != ResponseCode.OK && code != ResponseCode.BUFFER_OVERFLOW) {
            level = Level.WARNING;
        }
        if (Base.logger.isLoggable(level)) {
            Base.logger.log(level, "Packet response code: " + msg);
            StringBuffer buf = new StringBuffer("Packet payload: ");
            if (this.payload.length <= 1) {
                buf.append("empty");
            } else {
                for (int i = 1; i < this.payload.length; ++i) {
                    buf.append(Integer.toHexString(this.payload[i] & 0xFF));
                    buf.append(" ");
                }
            }
            Base.logger.log(level, buf.toString());
        }
    }

    public byte[] getPayload() {
        return this.payload;
    }

    int get8() {
        if (this.payload.length > this.readPoint) {
            return this.payload[this.readPoint++] & 0xFF;
        }
        Base.logger.fine("Error: payload not big enough.");
        return 0;
    }

    int get16() {
        return this.get8() + (this.get8() << 8);
    }

    int get32() {
        return this.get16() + (this.get16() << 16);
    }

    public boolean isOK() {
        return this.getResponseCode() == ResponseCode.OK;
    }

    public ResponseCode getResponseCode() {
        if (this.payload != null && this.payload.length > 0) {
            return ResponseCode.fromInt(this.payload[0]);
        }
        return ResponseCode.GENERIC_ERROR;
    }

    public static PacketResponse okResponse() {
        byte[] okPayload = new byte[]{1, 1, 1, 1, 1, 1, 1, 1};
        return new PacketResponse(okPayload);
    }

    public static PacketResponse timeoutResponse() {
        byte[] errorPayload = new byte[]{127, 0, 0, 0, 0, 0, 0, 0};
        return new PacketResponse(errorPayload);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ResponseCode {
        GENERIC_ERROR("Generic Error"),
        OK("OK"),
        BUFFER_OVERFLOW("Buffer full"),
        CRC_MISMATCH("CRC mismatch"),
        QUERY_OVERFLOW("Query overflow"),
        UNSUPPORTED("Unsupported command"),
        TIMEOUT("Packet timeout"),
        UNKNOWN("Unknown code");

        private final String message;

        private ResponseCode(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public static ResponseCode fromInt(int value) {
            switch (value) {
                case 0: {
                    return GENERIC_ERROR;
                }
                case 1: {
                    return OK;
                }
                case 2: {
                    return BUFFER_OVERFLOW;
                }
                case 3: {
                    return CRC_MISMATCH;
                }
                case 4: {
                    return QUERY_OVERFLOW;
                }
                case 5: {
                    return UNSUPPORTED;
                }
                case 6: {
                    return OK;
                }
                case 127: {
                    return TIMEOUT;
                }
            }
            return UNKNOWN;
        }
    }
}

