/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.w3c.dom.Node;
import replicatorg.app.Base;
import replicatorg.app.tools.XML;
import replicatorg.app.util.serial.Serial;
import replicatorg.app.util.serial.SerialFifoEventListener;
import replicatorg.drivers.DriverBaseImplementation;
import replicatorg.drivers.UsesSerial;

public class SerialDriver
extends DriverBaseImplementation
implements UsesSerial {
    protected Serial serial;
    private String portName;
    private int rate;
    private char parity;
    private int databits;
    private float stopbits;
    private boolean explicit = false;
    private final ReentrantReadWriteLock serialLock = new ReentrantReadWriteLock();
    public final ReentrantReadWriteLock.ReadLock serialInUse = this.serialLock.readLock();

    protected SerialDriver() {
        this.portName = Base.preferences.get("serial.portname", null);
        this.rate = Base.preferences.getInt("serial.debug_rate", 19200);
        String parityStr = Base.preferences.get("serial.parity", "N");
        this.parity = parityStr == null || parityStr.length() < 1 ? (char)78 : parityStr.charAt(0);
        this.databits = Base.preferences.getInt("serial.databits", 8);
        this.stopbits = Base.preferences.getFloat("serial.stopbits", 1.0f);
    }

    public void loadXML(Node xml) {
        super.loadXML(xml);
        if (XML.hasChildNode(xml, "portname")) {
            this.portName = XML.getChildNodeValue(xml, "portname");
            this.explicit = true;
        }
        if (XML.hasChildNode(xml, "rate")) {
            this.rate = Integer.parseInt(XML.getChildNodeValue(xml, "rate"));
        }
        if (XML.hasChildNode(xml, "parity")) {
            this.parity = XML.getChildNodeValue(xml, "parity").charAt(0);
        }
        if (XML.hasChildNode(xml, "databits")) {
            this.databits = Integer.parseInt(XML.getChildNodeValue(xml, "databits"));
        }
        if (XML.hasChildNode(xml, "stopbits")) {
            this.stopbits = Integer.parseInt(XML.getChildNodeValue(xml, "stopbits"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSerial(Serial serial) {
        this.serialLock.writeLock().lock();
        if (this.serial == serial) {
            this.serialLock.writeLock().unlock();
            return;
        }
        if (this.serial != null) {
            Serial serial2 = this.serial;
            synchronized (serial2) {
                this.serial.dispose();
                this.serial = null;
            }
        }
        this.setInitialized(false);
        this.serial = serial;
        if (this instanceof SerialFifoEventListener && serial != null) {
            serial.listener.set((SerialFifoEventListener)((Object)this));
        }
        this.serialLock.writeLock().unlock();
    }

    public Serial getSerial() {
        return this.serial;
    }

    public char getParity() {
        return this.parity;
    }

    public String getPortName() {
        return this.portName;
    }

    public int getDataBits() {
        return this.databits;
    }

    public int getRate() {
        return this.rate;
    }

    public float getStopBits() {
        return this.stopbits;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public void dispose() {
        this.serialLock.writeLock().lock();
        super.dispose();
        if (this.serial != null) {
            this.serial.dispose();
        }
        this.serial = null;
        this.serialLock.writeLock().unlock();
    }
}

