/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers;

import java.util.EnumSet;
import replicatorg.machine.model.AxisId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface OnboardParameters {
    public EnumSet<AxisId> getInvertedParameters();

    public void setInvertedParameters(EnumSet<AxisId> var1);

    public String getMachineName();

    public void setMachineName(String var1);

    public EndstopType getInvertedEndstops();

    public void setInvertedEndstops(EndstopType var1);

    public boolean hasFeatureOnboardParameters();

    public void createThermistorTable(int var1, double var2, double var4, double var6);

    public int getR0(int var1);

    public int getT0(int var1);

    public int getBeta(int var1);

    public BackoffParameters getBackoffParameters();

    public void setBackoffParameters(BackoffParameters var1);

    public PIDParameters getPIDParameters(int var1);

    public void setPIDParameters(int var1, PIDParameters var2);

    public ExtraFeatures getExtraFeatures();

    public void setExtraFeatures(ExtraFeatures var1);

    public void resetToFactory();

    public void resetToolToFactory();

    public static class ExtraFeatures {
        static final int CHA = 0;
        static final int CHB = 1;
        static final int CHC = 2;
        public boolean swapMotorController;
        public int heaterChannel;
        public int hbpChannel;
        public int abpChannel;
    }

    public static class PIDParameters {
        public float p;
        public float i;
        public float d;
    }

    public static class BackoffParameters {
        public int stopMs;
        public int reverseMs;
        public int forwardMs;
        public int triggerMs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EndstopType {
        NOT_PRESENT(0),
        INVERTED(-97),
        NON_INVERTED(-128);

        final byte value;

        private EndstopType(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static EndstopType endstopTypeForValue(byte value) {
            if ((value & 0x80) == 0) {
                return NOT_PRESENT;
            }
            return (value & 1) == 0 ? NON_INVERTED : INVERTED;
        }
    }
}

