/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import replicatorg.app.Base;
import replicatorg.drivers.Driver;

public class DriverFactory {
    private DriverFactory() {
        throw new AssertionError();
    }

    public static Driver factory(Node xml) {
        NamedNodeMap map;
        Node attribute;
        if (xml == null) {
            return DriverFactory.factory("NullDriver", null);
        }
        if (xml.hasAttributes() && (attribute = (map = xml.getAttributes()).getNamedItem("name")) != null) {
            String driverName = attribute.getNodeValue().trim();
            return DriverFactory.factory(driverName, xml);
        }
        if (xml.hasChildNodes()) {
            NodeList kids = xml.getChildNodes();
            for (int j = 0; j < kids.getLength(); ++j) {
                Node kid = kids.item(j);
                if (!kid.getNodeName().equals("name")) continue;
                String driverName = kid.getFirstChild().getNodeValue().trim();
                return DriverFactory.factory(driverName, xml);
            }
        }
        Base.logger.severe("Failing over to null driver.");
        return DriverFactory.loadClass("NullDriver");
    }

    public static Driver factory(String driverName, Node xml) {
        if (driverName.equals("serialpassthrough")) {
            return DriverFactory.loadClass("replicatorg.drivers.SerialPassthroughDriver", xml);
        }
        if (driverName.equals("sanguino3g")) {
            return DriverFactory.loadClass("replicatorg.drivers.gen3.Sanguino3GDriver", xml);
        }
        if (driverName.equals("makerbot4g")) {
            return DriverFactory.loadClass("replicatorg.drivers.gen3.Makerbot4GDriver", xml);
        }
        if (driverName.equals("makerbot4ga")) {
            return DriverFactory.loadClass("replicatorg.drivers.gen3.Makerbot4GAlternateDriver", xml);
        }
        if (driverName.equals("reprap5d")) {
            return DriverFactory.loadClass("replicatorg.drivers.reprap.RepRap5DDriver", xml);
        }
        if (driverName.equals("simpleReprap5d")) {
            return DriverFactory.loadClass("replicatorg.drivers.reprap.SimpleRepRap5DDriver", xml);
        }
        if (driverName.equals("null")) {
            return DriverFactory.loadClass("replicatorg.drivers.NullDriver", xml);
        }
        Driver driver = DriverFactory.loadClass(driverName, xml);
        if (driver == null) {
            Base.logger.severe("Driver not found, failing over to 'null'.");
            return DriverFactory.loadClass("replicatorg.drivers.NullDriver", xml);
        }
        return driver;
    }

    private static Driver loadClass(String className, Node xml) {
        Driver d = DriverFactory.loadClass(className);
        if (xml != null) {
            d.loadXML(xml);
        }
        return d;
    }

    private static Driver loadClass(String driverName) {
        Base.logger.info("Loading driver: " + driverName);
        String className = driverName;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> driverClass = loader.loadClass(className);
            if (Driver.class.isAssignableFrom(driverClass)) {
                return (Driver)driverClass.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            Base.logger.severe("The class " + className + " cannot be found.");
        }
        catch (IllegalAccessException e) {
            Base.logger.severe("The null constructor for " + className + " is not accessible.");
        }
        catch (InstantiationException e) {
            Base.logger.severe("Initialization of " + className + " failed.");
        }
        catch (ExceptionInInitializerError e) {
            Base.logger.severe("Initialization of " + className + " failed.");
        }
        catch (SecurityException e) {
            Base.logger.severe("Permission to create " + className + " denied.");
        }
        return null;
    }
}

