/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import replicatorg.app.ui.SimulationWindow;
import replicatorg.util.Point5d;

public class SimulationWindow2D
extends SimulationWindow
implements LayoutManager {
    private static final long serialVersionUID = -1940284103536979587L;
    protected static BuildView buildView;
    protected static HorizontalRuler hRuler;
    protected static VerticalRuler vRuler;
    private int rulerWidth = 25;

    public SimulationWindow2D() {
        this.setLayout(this);
        this.createComponents();
        this.setTitle("2D Build Simulation");
        this.setBackground(Color.white);
        this.setForeground(Color.white);
        this.setVisible(true);
        buildView.queuePoint(new Point5d());
        this.getContentPane().setBackground(Color.white);
    }

    private void createComponents() {
        Container pane = this.getContentPane();
        hRuler = new HorizontalRuler(this.rulerWidth);
        pane.add(hRuler);
        vRuler = new VerticalRuler(this.rulerWidth);
        pane.add(vRuler);
        buildView = new BuildView();
        pane.add(buildView);
        this.invalidate();
    }

    public synchronized void queuePoint(Point5d point) {
        buildView.queuePoint(point);
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void layoutContainer(Container parent) {
        Container pane = this.getContentPane();
        int width = pane.getWidth();
        int height = pane.getHeight();
        Rectangle hRuleBounds = new Rectangle(this.rulerWidth, 0, width - this.rulerWidth, this.rulerWidth + 1);
        hRuler.setBounds(hRuleBounds);
        Rectangle vRuleBounds = new Rectangle(0, this.rulerWidth, this.rulerWidth + 1, height - this.rulerWidth);
        vRuler.setBounds(vRuleBounds);
        Rectangle viewBounds = new Rectangle(this.rulerWidth + 1, this.rulerWidth + 1, width - this.rulerWidth - 1, height - this.rulerWidth - 1);
        buildView.setBounds(viewBounds);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    public void removeLayoutComponent(Component comp) {
    }

    public void setSimulationBounds(Rectangle2D.Double bounds) {
        this.simulationBounds = bounds;
        ((BuildView)SimulationWindow2D.buildView).maximum.x = bounds.getMaxX();
        ((BuildView)SimulationWindow2D.buildView).minimum.x = bounds.getMinX();
        ((BuildView)SimulationWindow2D.buildView).maximum.y = bounds.getMaxY();
        ((BuildView)SimulationWindow2D.buildView).minimum.y = bounds.getMinY();
        SimulationWindow2D.buildView.calculateRatio();
        hRuler.repaint();
        vRuler.repaint();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BuildView
    extends MyComponent
    implements MouseMotionListener {
        private Point3d minimum;
        private Point3d maximum;
        private Point3d current;
        private double currentZ;
        private int mouseX;
        private int mouseY;
        private double ratio;
        private Vector<Point3d> points;

        public BuildView() {
            this.mouseX = 0;
            this.mouseY = 0;
            this.ratio = 1.0;
            this.addMouseMotionListener(this);
            this.minimum = new Point3d();
            this.maximum = new Point3d();
            this.currentZ = 0.0;
            this.points = new Vector();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.mouseX = e.getX();
            this.mouseY = e.getY();
            hRuler.setMousePosition(this.mouseX);
            vRuler.setMousePosition(this.mouseY);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.mouseX = e.getX();
            this.mouseY = e.getY();
            hRuler.setMousePosition(this.mouseX);
            vRuler.setMousePosition(this.mouseY);
        }

        public Point3d getMinimum() {
            return this.minimum;
        }

        public Point3d getMaximum() {
            return this.maximum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queuePoint(Point5d point) {
            this.current = new Point3d(point.get3D());
            if (this.current.x < this.minimum.x) {
                this.minimum.x = this.current.x;
            }
            if (this.current.y < this.minimum.y) {
                this.minimum.y = this.current.y;
            }
            if (this.current.z < this.minimum.z) {
                this.minimum.z = this.current.z;
            }
            if (this.current.x > this.maximum.x) {
                this.maximum.x = this.current.x;
            }
            if (this.current.y > this.maximum.y) {
                this.maximum.y = this.current.y;
            }
            if (this.current.z > this.maximum.z) {
                this.maximum.z = this.current.z;
            }
            Point3d myPoint = new Point3d(this.current);
            Vector<Point3d> vector = this.points;
            synchronized (vector) {
                this.points.addElement(myPoint);
            }
            this.currentZ = this.current.z;
            this.calculateRatio();
            hRuler.setMachinePosition(this.convertRealXToPointX(this.current.x));
            vRuler.setMachinePosition(this.convertRealYToPointY(this.current.y));
            buildView.repaint();
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.drawHelperText(g);
            this.drawLastPoints(g);
        }

        private void drawHelperText(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            g2.setPaint(Color.black);
            g.setFont(new Font("SansSerif", 0, 14));
            g.setColor(Color.black);
            g.drawString("Layer at z: " + this.currentZ + "mm", 10, 20);
            double mouseRealX = this.convertPointXToRealX(this.mouseX);
            double mouseRealY = this.convertPointYToRealY(this.mouseY);
            g.drawString("Mouse: " + mouseRealX + "mm, " + mouseRealY + "mm", 10, 40);
            if (this.current != null) {
                g.drawString("Machine: " + this.current.x + "mm, " + this.current.y + "mm", 10, 60);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drawLastPoints(Graphics g) {
            Color aboveColor = new Color(255, 0, 0);
            Color currentColor = new Color(0, 255, 0);
            Color belowColor = new Color(0, 0, 255);
            Vector<Point3d> vector = this.points;
            synchronized (vector) {
                List<Point3d> lastPoints = this.getLastPoints(1000);
                double belowZ = this.currentZ;
                double aboveZ = this.currentZ;
                int aboveTotal = 0;
                int belowTotal = 0;
                int currentTotal = 0;
                int aboveCount = 0;
                int belowCount = 0;
                int currentCount = 0;
                if (lastPoints.size() > 0) {
                    Point3d end2;
                    Point3d start = lastPoints.get(0);
                    for (int i = lastPoints.size() - 1; i >= 0; --i) {
                        end2 = lastPoints.get(i);
                        if (start.equals((Tuple3d)end2)) continue;
                        if (end2.z < this.currentZ) {
                            if (end2.z < belowZ && belowZ != this.currentZ) continue;
                            belowZ = end2.z;
                            ++belowTotal;
                        } else if (end2.z > this.currentZ) {
                            if (end2.z > aboveZ && aboveZ != this.currentZ) continue;
                            aboveZ = end2.z;
                            ++aboveTotal;
                        } else {
                            if (end2.z != this.currentZ) continue;
                            ++currentTotal;
                        }
                        start = new Point3d(end2);
                    }
                    ListIterator<Point3d> li = lastPoints.listIterator();
                    while (li.hasNext()) {
                        int colorValue;
                        end2 = li.next();
                        if (start.equals((Tuple3d)end2)) continue;
                        int startX = this.convertRealXToPointX(start.x);
                        int startY = this.convertRealYToPointY(start.y);
                        int endX = this.convertRealXToPointX(end2.x);
                        int endY = this.convertRealYToPointY(end2.y);
                        if (end2.z < this.currentZ && end2.z >= belowZ) {
                            colorValue = 255 - 3 * (belowTotal - ++belowCount);
                            colorValue = Math.max(0, colorValue);
                            colorValue = Math.min(255, colorValue);
                            belowColor = new Color(0, 0, colorValue);
                            g.setColor(belowColor);
                        }
                        if (end2.z > this.currentZ && end2.z <= aboveZ) {
                            colorValue = 255 - 3 * (aboveTotal - ++aboveCount);
                            colorValue = Math.max(0, colorValue);
                            colorValue = Math.min(255, colorValue);
                            aboveColor = new Color(colorValue, 0, 0);
                            g.setColor(aboveColor);
                        } else {
                            if (end2.z != this.currentZ) continue;
                            colorValue = 255 - 3 * (currentTotal - ++currentCount);
                            colorValue = Math.max(0, colorValue);
                            colorValue = Math.min(255, colorValue);
                            currentColor = new Color(0, colorValue, 0);
                            g.setColor(currentColor);
                        }
                        if (end2.z > start.z) {
                            g.setColor(Color.red);
                            g.drawOval(startX - 5, startY - 5, 10, 10);
                            g.drawLine(startX - 5, startY, startX + 5, startY);
                            g.drawLine(startX, startY - 5, startX, startY + 5);
                        } else if (end2.z < start.z) {
                            g.setColor(Color.blue);
                            g.drawOval(startX - 5, startY - 5, 10, 10);
                            g.drawOval(startX - 1, startY - 1, 2, 2);
                        } else if (end2.z >= this.currentZ) {
                            g.drawLine(startX, startY, endX, endY);
                        }
                        start = new Point3d(end2);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Point3d> getLastPoints(int count) {
            Vector<Point3d> vector = this.points;
            synchronized (vector) {
                int index = Math.max(0, this.points.size() - count);
                List<Point3d> mypoints = this.points.subList(index, this.points.size());
                return mypoints;
            }
        }

        private void drawToolpaths(Graphics g) {
            Vector<Vector<Point3d>> toolpaths = this.getLayerPaths(this.currentZ);
            Point3d start = new Point3d();
            Point3d end2 = new Point3d();
            if (toolpaths.size() > 0) {
                Enumeration<Vector<Point3d>> e = toolpaths.elements();
                while (e.hasMoreElements()) {
                    Vector<Point3d> path = e.nextElement();
                    if (path.size() <= 1) continue;
                    g.setColor(Color.black);
                    start = path.firstElement();
                    Enumeration<Point3d> e2 = path.elements();
                    while (e2.hasMoreElements()) {
                        end2 = e2.nextElement();
                        int startX = this.convertRealXToPointX(start.x);
                        int startY = this.convertRealYToPointY(start.y);
                        int endX = this.convertRealXToPointX(end2.x);
                        int endY = this.convertRealYToPointY(end2.y);
                        g.drawLine(startX, startY, endX, endY);
                        start = new Point3d(end2);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Vector<Vector<Point3d>> getLayerPaths(double layerZ) {
            Vector<Vector<Point3d>> paths = new Vector<Vector<Point3d>>();
            Vector<Point3d> path = new Vector<Point3d>();
            Vector<Point3d> vector = this.points;
            synchronized (vector) {
                Enumeration<Point3d> e = this.points.elements();
                while (e.hasMoreElements()) {
                    Point3d p = e.nextElement();
                    if (p.z == layerZ) {
                        path.addElement(p);
                        continue;
                    }
                    if (path.size() <= 0) continue;
                    paths.addElement(path);
                    path = new Vector();
                }
            }
            if (path.size() > 0) {
                paths.addElement(path);
            }
            return paths;
        }

        private void calculateRatio() {
            double yRatio = (double)this.getWidth() / (this.maximum.y - this.minimum.y);
            double xRatio = (double)this.getHeight() / (this.maximum.x - this.minimum.x);
            this.ratio = Math.min(yRatio, xRatio);
        }

        public double getXRange() {
            return this.maximum.x - this.minimum.x;
        }

        public double getYRange() {
            return this.maximum.y - this.minimum.y;
        }

        public int convertRealXToPointX(double x) {
            return (int)((x - this.minimum.x) * this.ratio);
        }

        public double convertPointXToRealX(int x) {
            return Math.round(((double)x / this.ratio - this.minimum.x) * 100.0) / 100L;
        }

        public int convertRealYToPointY(double y) {
            return (int)((y - this.minimum.y) * this.ratio);
        }

        public double convertPointYToRealY(int y) {
            return Math.round((this.maximum.y - (double)y / this.ratio) * 100.0) / 100L;
        }
    }

    class VerticalRuler
    extends GenericRuler {
        public VerticalRuler(int rWidth) {
            super(rWidth);
        }

        protected void drawTriangles(Graphics2D g2) {
            g2.setPaint(Color.black);
            Polygon yTriangle = new Polygon();
            yTriangle.addPoint(this.rulerWidth - 1, this.mousePosition);
            yTriangle.addPoint(this.rulerWidth - this.rulerWidth / 4 - 1, this.mousePosition - this.rulerWidth / 4);
            yTriangle.addPoint(this.rulerWidth - this.rulerWidth / 4 - 1, this.mousePosition + this.rulerWidth / 4);
            g2.fill(yTriangle);
            g2.setPaint(Color.green);
            yTriangle = new Polygon();
            yTriangle.addPoint(this.rulerWidth - 1, this.machinePosition);
            yTriangle.addPoint(this.rulerWidth - this.rulerWidth / 4 - 1, this.machinePosition - this.rulerWidth / 4);
            yTriangle.addPoint(this.rulerWidth - this.rulerWidth / 4 - 1, this.machinePosition + this.rulerWidth / 4);
            g2.fill(yTriangle);
        }

        protected void drawTicks(Graphics2D g) {
            int length;
            double real;
            int point;
            double range = buildView.getYRange();
            if (range < 0.01) {
                return;
            }
            int height = this.getHeight();
            GenericRuler.IncrementInfo ii = this.getIncrementInfo(height, range);
            double increment = ii.minor;
            int i = 0;
            do {
                real = (double)i * increment;
                point = buildView.convertRealYToPointY(real) - 1;
                if (i % 10 == 0) {
                    length = this.rulerWidth;
                    g.drawString(Double.toString(real), 2, point - 1);
                } else {
                    length = this.rulerWidth / 3;
                }
                g.drawLine(this.rulerWidth, point, this.rulerWidth - length, point);
                ++i;
            } while (point > 0 && point < this.getHeight());
            i = 0;
            do {
                real = (double)i * increment;
                point = buildView.convertRealYToPointY(real) - 1;
                if (i % 10 == 0) {
                    length = this.rulerWidth;
                    g.drawString(Double.toString(real), 2, point - 1);
                } else {
                    length = this.rulerWidth / 3;
                }
                g.drawLine(this.rulerWidth, point, this.rulerWidth - length, point);
                --i;
            } while (point < this.getHeight() && point > 0);
        }
    }

    class HorizontalRuler
    extends GenericRuler {
        public HorizontalRuler(int rWidth) {
            super(rWidth);
        }

        protected void drawTriangles(Graphics2D g2) {
            g2.setPaint(Color.green);
            Polygon xTriangle = new Polygon();
            xTriangle.addPoint(this.machinePosition, this.rulerWidth - 1);
            xTriangle.addPoint(this.machinePosition - this.rulerWidth / 4, this.rulerWidth - this.rulerWidth / 4 - 1);
            xTriangle.addPoint(this.machinePosition + this.rulerWidth / 4, this.rulerWidth - this.rulerWidth / 4 - 1);
            g2.fill(xTriangle);
            g2.setPaint(Color.black);
            xTriangle = new Polygon();
            xTriangle.addPoint(this.mousePosition, this.rulerWidth - 1);
            xTriangle.addPoint(this.mousePosition - this.rulerWidth / 4, this.rulerWidth - this.rulerWidth / 4 - 1);
            xTriangle.addPoint(this.mousePosition + this.rulerWidth / 4, this.rulerWidth - this.rulerWidth / 4 - 1);
            g2.fill(xTriangle);
        }

        protected void drawTicks(Graphics2D g) {
            int length;
            double real;
            int point;
            double range = buildView.getXRange();
            if (range < 0.01) {
                return;
            }
            int width = this.getWidth();
            GenericRuler.IncrementInfo ii = this.getIncrementInfo(width, range);
            double increment = ii.minor;
            int i = 0;
            int textBaseline = g.getFontMetrics().getAscent() + 2;
            do {
                real = (double)i * increment;
                point = buildView.convertRealXToPointX(real) - 1;
                if (i % 10 == 0) {
                    length = this.rulerWidth;
                    g.drawString(Double.toString(real), point + 1, textBaseline);
                } else {
                    length = this.rulerWidth / 3;
                }
                g.drawLine(point, this.rulerWidth, point, this.rulerWidth - length);
                ++i;
            } while (point < this.getWidth());
            i = 0;
            do {
                real = (double)i * increment;
                point = buildView.convertRealXToPointX(real) - 1;
                if (i % 10 == 0) {
                    length = this.rulerWidth;
                    g.drawString(Double.toString(real), point + 1, textBaseline);
                } else {
                    length = this.rulerWidth / 3;
                }
                g.drawLine(point, this.rulerWidth, point, this.rulerWidth - length);
                --i;
            } while (point > 0);
        }
    }

    abstract class GenericRuler
    extends MyComponent {
        protected int machinePosition;
        protected int mousePosition;
        protected int rulerWidth;

        public GenericRuler(int rulerWidth) {
            this.machinePosition = 0;
            this.mousePosition = 0;
            this.rulerWidth = 25;
            this.rulerWidth = rulerWidth;
        }

        public void setMousePosition(int i) {
            if (this.mousePosition != i) {
                this.mousePosition = i;
            }
        }

        public void setMachinePosition(int i) {
            if (this.mousePosition != i) {
                this.machinePosition = i;
            }
        }

        protected IncrementInfo getIncrementInfo(int length, double range) {
            double increment;
            if (range == 0.0 || length < 10) {
                return null;
            }
            int minPixelsBetweenMinors = 10;
            int minorsPerMajor = 10;
            int numMinors = length / 10;
            double rangePerMinor = range / (double)numMinors;
            for (increment = 10.0; rangePerMinor < increment; increment /= 10.0) {
            }
            while (rangePerMinor > increment) {
                increment *= 10.0;
            }
            double factor = rangePerMinor / increment;
            if (factor < 0.5) {
                increment *= 0.5;
            } else if (factor < 0.25) {
                increment *= 0.25;
            }
            return new IncrementInfo(increment * 10.0, increment);
        }

        public void paint(Graphics g) {
            g.setColor(new Color(224, 224, 224));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.gray);
            Rectangle bounds = this.getBounds();
            g.drawRect(0, 0, bounds.width - 1, bounds.height - 1);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            g2.setPaint(Color.black);
            g.setFont(new Font("SansSerif", 0, 11));
            g.setColor(Color.black);
            g.setColor(Color.black);
            this.drawTicks(g2);
        }

        protected abstract void drawTriangles(Graphics2D var1);

        protected abstract void drawTicks(Graphics2D var1);

        class IncrementInfo {
            public double major;
            public double minor;

            public IncrementInfo(double major, double minor) {
                this.major = major;
                this.minor = minor;
            }
        }
    }

    class MyComponent
    extends JComponent {
        private static final long serialVersionUID = 3222037949637415135L;

        public MyComponent() {
            this.setBackground(Color.white);
            this.setForeground(Color.white);
            this.setVisible(true);
        }
    }
}

