/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.ui.GuiConstants;
import replicatorg.app.ui.MainWindow;
import replicatorg.app.util.PythonUtils;
import replicatorg.app.util.SwingPythonSelector;
import replicatorg.uploader.FirmwareUploader;

public class PreferencesWindow
extends JFrame
implements GuiConstants {
    MainWindow editor;
    JTextField fontSizeField;
    JTextField firmwareUpdateUrlField;

    private void showCurrentSettings() {
        Font editorFont = Base.getFontPref("editor.font", "Monospaced,plain,12");
        this.fontSizeField.setText(String.valueOf(editorFont.getSize()));
        String firmwareUrl = Base.preferences.get("replicatorg.updates.url", "http://firmware.makerbot.com/firmware.xml");
        this.firmwareUpdateUrlField.setText(firmwareUrl);
    }

    private JCheckBox addCheckboxForPref(Container c, String text, final String pref, boolean defaultVal) {
        JCheckBox cb = new JCheckBox(text);
        cb.setSelected(Base.preferences.getBoolean(pref, defaultVal));
        c.add((Component)cb, "wrap");
        cb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox box = (JCheckBox)e.getSource();
                Base.preferences.putBoolean(pref, box.isSelected());
            }
        });
        return cb;
    }

    private void addInitialFilePrefs(Container c) {
        String prefName = "replicatorg.initialopenbehavior";
        int defaultBehavior = Base.InitialOpenBehavior.OPEN_LAST.ordinal();
        int ordinal = Base.preferences.getInt("replicatorg.initialopenbehavior", defaultBehavior);
        if (ordinal >= Base.InitialOpenBehavior.values().length) {
            ordinal = defaultBehavior;
        }
        Base.InitialOpenBehavior openBehavior = Base.InitialOpenBehavior.values()[ordinal];
        ButtonGroup bg = new ButtonGroup();
        c.add((Component)new JLabel("On ReplicatorG launch:"), "wrap");
        class RadioAction
        extends AbstractAction {
            private Base.InitialOpenBehavior behavior;

            public RadioAction(String text, Base.InitialOpenBehavior behavior) {
                super(text);
                this.behavior = behavior;
            }

            public void actionPerformed(ActionEvent e) {
                Base.preferences.putInt("replicatorg.initialopenbehavior", this.behavior.ordinal());
            }
        }
        JRadioButton b = new JRadioButton(new RadioAction("Open last opened or save file", Base.InitialOpenBehavior.OPEN_LAST));
        if (Base.InitialOpenBehavior.OPEN_LAST == openBehavior) {
            b.setSelected(true);
        }
        bg.add(b);
        c.add((Component)b, "wrap");
        b = new JRadioButton(new RadioAction("Open new file", Base.InitialOpenBehavior.OPEN_NEW));
        if (Base.InitialOpenBehavior.OPEN_NEW == openBehavior) {
            b.setSelected(true);
        }
        bg.add(b);
        c.add((Component)b, "wrap");
    }

    JComboBox makeDebugLevelDropdown() {
        String levelName = Base.preferences.get("replicatorg.debuglevel", Level.INFO.getName());
        Level l = Level.parse(levelName);
        if (l == null) {
            l = Level.INFO;
        }
        Vector<Level> levels = new Vector<Level>();
        levels.add(Level.ALL);
        levels.add(Level.FINEST);
        levels.add(Level.FINER);
        levels.add(Level.FINE);
        levels.add(Level.INFO);
        levels.add(Level.WARNING);
        final DefaultComboBoxModel model = new DefaultComboBoxModel(levels);
        model.setSelectedItem(l);
        JComboBox cb = new JComboBox(model);
        cb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Level level = (Level)model.getSelectedItem();
                Base.preferences.put("replicatorg.debuglevel", level.getName());
                Base.logger.setLevel(level);
            }
        });
        return cb;
    }

    public PreferencesWindow() {
        super("Preferences");
        this.setResizable(true);
        Container content = this.getContentPane();
        content.setLayout((LayoutManager)new MigLayout("fill"));
        content.add((Component)new JLabel("MainWindow font size: "), "split");
        this.fontSizeField = new JTextField(4);
        content.add(this.fontSizeField);
        content.add((Component)new JLabel("  (requires restart of ReplicatorG)"), "wrap");
        this.addCheckboxForPref(content, "Monitor temperature during builds", "build.monitor_temp", false);
        this.addCheckboxForPref(content, "Honor serial port selection in machines.xml", "serial.use_machines", true);
        this.addCheckboxForPref(content, "Automatically connect at startup", "replicatorg.autoconnect", true);
        this.addCheckboxForPref(content, "Show experimental machine profiles", "machine.showExperimental", false);
        this.addCheckboxForPref(content, "Show simulator during builds", "build.showSimulator", false);
        this.addCheckboxForPref(content, "Break Z motion into seperate moves (normally false)", "replicatorg.parser.breakzmoves", false);
        content.add((Component)new JLabel("Firmware update URL: "), "split");
        this.firmwareUpdateUrlField = new JTextField(34);
        content.add((Component)this.firmwareUpdateUrlField, "wrap");
        content.add((Component)new JLabel("Arc resolution (in mm): "), "split");
        double value = Base.preferences.getDouble("replicatorg.parser.curve_segment_mm", 1.0);
        JFormattedTextField arcResolutionField = new JFormattedTextField(new Double(value));
        content.add((Component)arcResolutionField, "wrap");
        String arcResolutionHelp = "<html><small><em>The arc resolution is the default segment length that the gcode parser will break arc codes <br>like G2 and G3 into.  Drivers that natively handle arcs will ignore this setting.</em></small></html>";
        content.add((Component)new JLabel(arcResolutionHelp), "growx,wrap");
        arcResolutionField.setColumns(10);
        arcResolutionField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "value") {
                    try {
                        Double v = (Double)evt.getNewValue();
                        if (v == null) {
                            return;
                        }
                        Base.preferences.putDouble("replicatorg.parser.curve_segment_mm", v);
                    }
                    catch (ClassCastException cce) {
                        Base.logger.warning("Unexpected value type: " + evt.getNewValue().getClass().toString());
                    }
                }
            }
        });
        content.add((Component)new JLabel("Debugging level (default INFO):"), "split");
        content.add((Component)this.makeDebugLevelDropdown(), "wrap");
        JButton b = new JButton("Select Python interpreter...");
        content.add((Component)b, "spanx,wrap");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingPythonSelector sps = new SwingPythonSelector(PreferencesWindow.this);
                String path = sps.selectFreeformPath();
                if (path != null) {
                    PythonUtils.setPythonPath(path);
                }
            }
        });
        this.addInitialFilePrefs(content);
        JButton delPrefs = new JButton("Restore all defaults (includes driver choice, etc.)");
        content.add((Component)delPrefs, "wrap");
        delPrefs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Base.resetPreferences();
                PreferencesWindow.this.showCurrentSettings();
            }
        });
        JButton button = new JButton("Close");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesWindow.this.applyFrame();
                PreferencesWindow.this.dispose();
            }
        });
        content.add((Component)button, "tag ok");
        this.showCurrentSettings();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PreferencesWindow.this.dispose();
            }
        });
        ActionListener disposer = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesWindow.this.dispose();
            }
        };
        Base.registerWindowCloseKeys(this.getRootPane(), disposer);
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screen.width - this.getWidth()) / 2, (screen.height - this.getHeight()) / 2);
        content.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                KeyStroke wc = MainWindow.WINDOW_CLOSE_KEYSTROKE;
                if (e.getKeyCode() == 27 || KeyStroke.getKeyStrokeForEvent(e).equals(wc)) {
                    PreferencesWindow.this.dispose();
                }
            }
        });
    }

    public void applyFrame() {
        String newSizeText = this.fontSizeField.getText();
        try {
            int newSize = Integer.parseInt(newSizeText.trim());
            String fontName = Base.preferences.get("editor.font", "Monospaced,plain,12");
            if (fontName != null) {
                String[] pieces = fontName.split(",");
                pieces[2] = String.valueOf(newSize);
                StringBuffer buf = new StringBuffer();
                for (String piece : pieces) {
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    buf.append(piece);
                }
                Base.preferences.put("editor.font", buf.toString());
            }
        }
        catch (Exception e) {
            Base.logger.warning("ignoring invalid font size " + newSizeText);
        }
        String origUpdateUrl = Base.preferences.get("replicatorg.updates.url", "");
        if (!origUpdateUrl.equals(this.firmwareUpdateUrlField.getText())) {
            FirmwareUploader.invalidateFirmware();
            Base.preferences.put("replicatorg.updates.url", this.firmwareUpdateUrlField.getText());
            FirmwareUploader.checkFirmware();
        }
        this.editor.applyPreferences();
    }

    public void showFrame(MainWindow editor) {
        this.editor = editor;
        this.setVisible(true);
    }
}

