/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.MachineController;
import replicatorg.app.ui.BGPanel;
import replicatorg.app.ui.MainWindow;
import replicatorg.drivers.SDCardCapture;
import replicatorg.machine.MachineListener;
import replicatorg.machine.MachineProgressEvent;
import replicatorg.machine.MachineState;
import replicatorg.machine.MachineStateChangeEvent;
import replicatorg.machine.MachineToolStatusEvent;

public class MainButtonPanel
extends BGPanel
implements MachineListener,
ActionListener {
    static final int BUTTON_WIDTH = 27;
    static final int BUTTON_HEIGHT = 32;
    static final float[] disabledFactors = new float[]{1.0f, 1.0f, 1.0f, 0.5f};
    static final float[] disabledOffsets = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private static RescaleOp disabledOp = new RescaleOp(disabledFactors, disabledOffsets, null);
    static final float[] activeFactors = new float[]{-1.0f, -1.0f, -1.0f, 1.0f};
    static final float[] activeOffsets = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
    private static RescaleOp activeOp = new RescaleOp(activeFactors, activeOffsets, null);
    static final int BUTTON_GAP = 15;
    MainWindow editor;
    Image offscreen;
    int maxLabelWidth;
    int width;
    int height;
    Color bgcolor;
    JLabel statusLabel;
    static final Color BACK_COLOR = new Color(95, 115, 37);
    MainButton simButton;
    MainButton pauseButton;
    MainButton stopButton;
    MainButton buildButton;
    MainButton resetButton;
    MainButton cpButton;
    MainButton rcButton;
    MainButton disconnectButton;
    MainButton connectButton;
    MainButton uploadButton;
    MainButton playbackButton;
    MainButton fileButton;

    public MainButtonPanel(MainWindow editor) {
        this.setLayout((LayoutManager)new MigLayout("gap 5"));
        this.editor = editor;
        this.setBackground(BACK_COLOR);
        Font statusFont = Base.getFontPref("buttons.status.font", "SansSerif,plain,12");
        Color statusColor = Base.getColorPref("buttons.status.color", "#FFFFFF");
        this.simButton = this.makeButton("Simulate", "images/button-simulate.png");
        this.add(this.simButton);
        this.buildButton = this.makeButton("Build", "images/button-build.png");
        this.add(this.buildButton);
        this.uploadButton = this.makeButton("Upload to SD card", "images/button-upload.png");
        this.add(this.uploadButton);
        this.playbackButton = this.makeButton("Build from SD card", "images/button-playback.png");
        this.add(this.playbackButton);
        this.fileButton = this.makeButton("Build to file", "images/button-to-file.png");
        this.add(this.fileButton);
        this.pauseButton = this.makeButton("Pause", "images/button-pause.png");
        this.add((Component)this.pauseButton, "gap unrelated");
        this.stopButton = this.makeButton("Stop", "images/button-stop.png");
        this.add(this.stopButton);
        this.cpButton = this.makeButton("Control panel", "images/button-control-panel.png");
        this.rcButton = this.makeButton("Live tuning", "images/button-realtime-panel.png");
        this.add((Component)this.cpButton, "gap unrelated");
        this.add(this.rcButton);
        this.resetButton = this.makeButton("Reset machine", "images/button-reset.png");
        this.add((Component)this.resetButton, "gap unrelated");
        this.connectButton = this.makeButton("Connect", "images/button-connect.png");
        this.add((Component)this.connectButton, "gap unrelated");
        this.disconnectButton = this.makeButton("Disconnect", "images/button-disconnect.png");
        this.add(this.disconnectButton);
        this.statusLabel = new JLabel();
        this.statusLabel.setFont(statusFont);
        this.statusLabel.setForeground(statusColor);
        this.add((Component)this.statusLabel, "gap unrelated,growx");
        this.simButton.setToolTipText("This will open a window showing a rapid simulation of what toolpaths the machine is going to perform.");
        this.buildButton.setToolTipText("This will start building the object on the machine.");
        this.pauseButton.setToolTipText("This will pause or resume the build.");
        this.stopButton.setToolTipText("This will abort the build in progress.");
        this.cpButton.setToolTipText("Here you'll find manually controls for the machine.");
        this.rcButton.setToolTipText("This can be used to tune the process, in real time, during a print job.");
        this.resetButton.setToolTipText("This will restart the firmware on the machine.");
        this.connectButton.setToolTipText("Connect to the machine.");
        this.disconnectButton.setToolTipText("Disconnect from the machine.");
        this.setPreferredSize(new Dimension(700, 60));
        this.machineStateChangedInternal(new MachineStateChangeEvent(null, new MachineState()));
    }

    public MainButton makeButton(String rolloverText, String source) {
        BufferedImage img = Base.getImage(source, this);
        if (img == null) {
            Base.logger.severe("Couldn't load button image: " + source + ". Check that your path (" + System.getProperty("user.dir") + ") contains this file");
            System.exit(1);
        }
        BufferedImage disabled = disabledOp.filter(img, null);
        BufferedImage inactive = img;
        BufferedImage rollover = img;
        BufferedImage active = activeOp.filter(img, null);
        MainButton mb = new MainButton(rolloverText, active, inactive, rollover, disabled);
        mb.setEnabled(false);
        return mb;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.simButton) {
            this.editor.handleSimulate();
        } else if (e.getSource() == this.buildButton) {
            this.editor.handleBuild();
        } else if (e.getSource() == this.uploadButton) {
            this.editor.handleUpload();
        } else if (e.getSource() == this.fileButton) {
            this.editor.handleBuildToFile();
        } else if (e.getSource() == this.playbackButton) {
            this.editor.handlePlayback();
        } else if (e.getSource() == this.pauseButton) {
            this.editor.handlePause();
        } else if (e.getSource() == this.stopButton) {
            this.editor.handleStop();
        } else if (e.getSource() == this.resetButton) {
            this.editor.handleReset();
        } else if (e.getSource() == this.cpButton) {
            this.editor.handleControlPanel();
        } else if (e.getSource() == this.connectButton) {
            this.editor.handleConnect();
        } else if (e.getSource() == this.disconnectButton) {
            this.editor.handleDisconnect();
        } else if (e.getSource() == this.rcButton) {
            this.editor.handleRealTimeControl();
        }
    }

    public void machineStateChanged(MachineStateChangeEvent evt) {
        final MachineStateChangeEvent e = evt;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainButtonPanel.this.machineStateChangedInternal(e);
            }
        });
    }

    private void updateFromState(MachineState s, MachineController machine) {
        boolean ready = s.isReady();
        boolean building = s.isBuilding();
        boolean paused = s.isPaused();
        boolean hasGcode = this.editor != null && this.editor.getBuild() != null && this.editor.getBuild().getCode() != null;
        boolean hasMachine = machine != null;
        boolean hasPlayback = hasMachine && machine.driver != null && machine.driver instanceof SDCardCapture && ((SDCardCapture)((Object)machine.driver)).hasFeatureSDCardCapture();
        this.simButton.setEnabled(hasMachine && !building && hasGcode);
        this.fileButton.setEnabled(hasMachine && !building && hasGcode);
        this.buildButton.setEnabled(ready && hasGcode);
        this.uploadButton.setEnabled(ready && hasPlayback && hasGcode);
        this.playbackButton.setEnabled(ready && hasPlayback);
        this.pauseButton.setEnabled(building);
        this.stopButton.setEnabled(building);
        this.pauseButton.setSelected(paused);
        this.rcButton.setEnabled(building);
        MachineState.Target runningTarget = s.isBuilding() ? s.getTarget() : null;
        this.simButton.setSelected(runningTarget == MachineState.Target.SIMULATOR);
        this.buildButton.setSelected(runningTarget == MachineState.Target.MACHINE);
        this.uploadButton.setSelected(runningTarget == MachineState.Target.SD_UPLOAD);
        this.fileButton.setSelected(runningTarget == MachineState.Target.FILE);
        this.playbackButton.setSelected(runningTarget == MachineState.Target.NONE);
        boolean connected = s.isConnected() && hasMachine && machine.isInitialized();
        this.resetButton.setEnabled(connected);
        this.disconnectButton.setEnabled(connected);
        this.connectButton.setEnabled(hasMachine && !connected);
        this.cpButton.setEnabled(ready);
        this.rcButton.setVisible(this.editor.supportsRealTimeControl());
    }

    public void updateFromMachine(MachineController machine) {
        MachineState s = new MachineState(MachineState.State.NOT_ATTACHED);
        if (machine != null) {
            s = machine.getMachineState();
        }
        this.updateFromState(s, machine);
    }

    public void machineStateChangedInternal(MachineStateChangeEvent evt) {
        MachineState s = evt.getState();
        MachineController machine = evt.getSource();
        this.updateFromState(s, machine);
    }

    public void machineProgress(MachineProgressEvent event) {
    }

    public void toolStatusChanged(MachineToolStatusEvent event) {
    }

    class MainButton
    extends JButton
    implements ChangeListener {
        private String rolloverText;

        public MainButton(String rolloverText, Image active, Image inactive, Image rollover, Image disabled) {
            this.rolloverText = rolloverText;
            this.setIcon(new ImageIcon(inactive));
            this.setSelectedIcon(new ImageIcon(active));
            this.setDisabledIcon(new ImageIcon(disabled));
            this.setRolloverEnabled(true);
            this.setRolloverIcon(new ImageIcon(rollover));
            this.setSize(new Dimension(active.getWidth(null), active.getHeight(null)));
            this.setBorder(null);
            this.getModel().addChangeListener(this);
            this.addActionListener(MainButtonPanel.this);
        }

        public String getRolloverText() {
            return this.rolloverText;
        }

        public void paint(Graphics g) {
            Rectangle b = this.getBounds();
            if (this.getModel().isSelected()) {
                g.setColor(new Color(1.0f, 1.0f, 0.5f, 0.8f));
                g.fillRect(0, 0, b.width, b.height);
                this.getSelectedIcon().paintIcon(this, g, 0, 0);
            } else if (this.getModel().isEnabled()) {
                if (this.getModel().isPressed()) {
                    g.setColor(new Color(1.0f, 1.0f, 0.5f, 0.3f));
                    g.fillRect(0, 0, b.width, b.height);
                    this.getSelectedIcon().paintIcon(this, g, 0, 0);
                } else if (this.getModel().isRollover()) {
                    g.setColor(new Color(1.0f, 1.0f, 0.5f, 0.3f));
                    g.fillRect(0, 0, b.width, b.height);
                    this.getRolloverIcon().paintIcon(this, g, 0, 0);
                } else {
                    g.setColor(BACK_COLOR);
                    g.fillRect(0, 0, b.width, b.height);
                    this.getIcon().paintIcon(this, g, 0, 0);
                }
            } else {
                g.setColor(BACK_COLOR);
                g.fillRect(0, 0, b.width, b.height);
                this.getDisabledIcon().paintIcon(this, g, 0, 0);
            }
        }

        public void stateChanged(ChangeEvent ce) {
            if (MainButtonPanel.this.statusLabel == null) {
                return;
            }
            if (this.getModel().isRollover()) {
                MainButtonPanel.this.statusLabel.setText(this.getRolloverText());
            } else {
                MainButtonPanel.this.statusLabel.setText("");
            }
        }
    }
}

