/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import replicatorg.app.Base;
import replicatorg.app.MachineController;
import replicatorg.app.ui.BGPanel;
import replicatorg.drivers.EstimationDriver;
import replicatorg.drivers.UsesSerial;
import replicatorg.drivers.Version;
import replicatorg.machine.MachineListener;
import replicatorg.machine.MachineProgressEvent;
import replicatorg.machine.MachineState;
import replicatorg.machine.MachineStateChangeEvent;
import replicatorg.machine.MachineToolStatusEvent;

public class MachineStatusPanel
extends BGPanel
implements MachineListener {
    private static final long serialVersionUID = -6944931245041870574L;
    protected MachineController machine = null;
    protected JLabel label = new JLabel();
    protected JLabel smallLabel = new JLabel();
    protected JLabel tempLabel = new JLabel();
    protected double currentTemperature = -1.0;
    private static final Color BG_NO_MACHINE = new Color(255, 128, 96);
    private static final Color BG_READY = new Color(128, 255, 96);
    private static final Color BG_BUILDING = new Color(255, 239, 0);
    private boolean firmwareWarningIssued = false;

    MachineStatusPanel() {
        Font smallFont = Base.getFontPref("status.font", "SansSerif,plain,10");
        this.smallLabel.setFont(smallFont);
        this.tempLabel.setFont(smallFont);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.label.setAlignmentX(0.0f);
        this.add(this.label);
        this.smallLabel.setAlignmentX(0.0f);
        Box b = Box.createHorizontalBox();
        b.add(this.smallLabel);
        b.add(Box.createHorizontalGlue());
        b.add(this.tempLabel);
        b.setAlignmentX(0.0f);
        this.tempLabel.setAlignmentX(1.0f);
        this.add(b);
        this.add(Box.createVerticalGlue());
        FontMetrics smallMetrics = this.getFontMetrics(smallFont);
        int height = (smallMetrics.getAscent() + smallMetrics.getDescent()) * 3;
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, height));
        this.setMinimumSize(new Dimension(0, height));
        int prefWidth = 80 * smallMetrics.charWidth('n');
        this.setPreferredSize(new Dimension(prefWidth, height));
    }

    public void setMachine(MachineController machine) {
        if (machine != null && this.machine == machine) {
            return;
        }
        this.machine = machine;
        MachineState state = machine != null ? machine.getMachineState() : new MachineState();
        MachineStateChangeEvent e = new MachineStateChangeEvent(machine, state);
        this.updateMachineStatus(e);
    }

    protected String getMachineStateMessage(MachineController machine) {
        if (machine == null) {
            return "No machine selected";
        }
        MachineState state = machine.getMachineState();
        if (state.getState() == MachineState.State.NOT_ATTACHED) {
            if (machine.getDriver() == null) {
                return "No machine selected";
            }
            return "Disconnected";
        }
        if (state.getState() == MachineState.State.CONNECTING) {
            StringBuffer buf = new StringBuffer("Connecting to " + machine.getName());
            if (machine.driver instanceof UsesSerial) {
                buf.append(" on ");
                buf.append(((UsesSerial)((Object)machine.driver)).getSerial().getName());
            }
            buf.append("...");
            return buf.toString();
        }
        StringBuffer message = new StringBuffer("Machine " + machine.getName());
        message.append(" (" + machine.getDriver().getDriverName() + ") ");
        if (state.getState() == MachineState.State.READY) {
            message.append("ready");
        } else if (state.isPaused()) {
            message.append("paused");
        } else if (state.isBuilding()) {
            if (state.isSimulating()) {
                message.append("simulating");
            } else {
                message.append("building");
            }
        }
        return message.toString();
    }

    protected synchronized void updateMachineStatus(MachineStateChangeEvent evt) {
        Color bgColor = Color.WHITE;
        MachineController machine = evt.getSource();
        String text = this.getMachineStateMessage(machine);
        if (machine == null || machine.driver == null) {
            bgColor = BG_NO_MACHINE;
        } else {
            boolean initialized;
            boolean bl = initialized = machine.isInitialized() && evt.getState().getState() != MachineState.State.NOT_ATTACHED && evt.getState().getState() != MachineState.State.CONNECTING;
            if (!initialized) {
                bgColor = BG_NO_MACHINE;
            } else {
                bgColor = evt.getState().isBuilding() ? BG_BUILDING : BG_READY;
                this.currentTemperature = -1.0;
                Version v = machine.driver.getVersion();
                if (v != null && v.compareTo(machine.driver.getPreferredVersion()) < 0) {
                    if (!this.firmwareWarningIssued) {
                        this.firmwareWarningIssued = true;
                        JOptionPane.showMessageDialog(this, "Firmware version " + v + " was detected on your machine.  Firmware version " + machine.driver.getPreferredVersion() + " is recommended.\n" + "Please update your firmware and restart ReplicatorG.", "Old firmware detected", 2);
                    }
                } else if (v == null) {
                    bgColor = BG_NO_MACHINE;
                    text = "Machine connection timed out";
                }
            }
        }
        this.label.setText(text);
        this.smallLabel.setText(null);
        this.tempLabel.setText(null);
        this.setBackground(bgColor);
    }

    public void machineStateChanged(MachineStateChangeEvent evt) {
        final MachineStateChangeEvent e = evt;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MachineStatusPanel.this.updateMachineStatus(e);
            }
        });
    }

    public void machineProgress(MachineProgressEvent event) {
        double remaining;
        double proportion = (double)event.getLines() / (double)event.getTotalLines();
        if (this.machine.getMachineState().getTarget() == MachineState.Target.SD_UPLOAD) {
            if (event.getLines() == 0) {
                double d = 0.0;
            }
            remaining = event.getElapsed() * (1.0 / proportion - 1.0);
        } else {
            remaining = event.getEstimated() * (1.0 - proportion);
        }
        final String s = String.format("Commands:  %1$7d / %2$7d  (%3$3.2f%%)   |   Elapsed:  %4$s  |  Estimated Remaining:  %5$s", event.getLines(), event.getTotalLines(), (double)Math.round(proportion * 10000.0) / 100.0, EstimationDriver.getBuildTimeString(event.getElapsed(), true), EstimationDriver.getBuildTimeString(remaining, true));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MachineStatusPanel.this.smallLabel.setText(s);
            }
        });
    }

    public void toolStatusChanged(MachineToolStatusEvent event) {
        this.currentTemperature = event.getTool().getCurrentTemperature();
        if (this.currentTemperature != -1.0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MachineStatusPanel.this.tempLabel.setText(String.format("Temp: %1$3.1f\u00b0C", MachineStatusPanel.this.currentTemperature));
                }
            });
        }
    }
}

