/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.MachineController;
import replicatorg.app.ui.controlpanel.ExtruderPanel;
import replicatorg.app.ui.controlpanel.JogPanel;
import replicatorg.drivers.Driver;
import replicatorg.drivers.RetryException;
import replicatorg.machine.MachineListener;
import replicatorg.machine.MachineProgressEvent;
import replicatorg.machine.MachineState;
import replicatorg.machine.MachineStateChangeEvent;
import replicatorg.machine.MachineToolStatusEvent;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.Endstops;
import replicatorg.machine.model.ToolModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlPanelWindow
extends JFrame
implements ChangeListener,
WindowListener,
MachineListener {
    static final long serialVersionUID = -3494348039028986935L;
    protected JPanel mainPanel;
    protected JogPanel jogPanel;
    protected JTabbedPane toolsPane;
    protected MachineController machine;
    protected Driver driver;
    protected UpdateThread updateThread;
    protected PollThread pollThread;
    private static ControlPanelWindow instance = null;
    Vector<ExtruderPanel> extruderPanels = new Vector();

    public static synchronized ControlPanelWindow getControlPanel(MachineController m) {
        if (instance == null) {
            instance = new ControlPanelWindow(m);
        } else if (ControlPanelWindow.instance.machine != m) {
            instance.dispose();
            instance = new ControlPanelWindow(m);
        }
        return instance;
    }

    private ControlPanelWindow(MachineController m) {
        super("Control Panel");
        BufferedImage icon = Base.getImage("images/icon.gif", this);
        this.setIconImage(icon);
        this.machine = m;
        this.driver = this.machine.getDriver();
        this.driver.invalidatePosition();
        this.machine.addMachineStateListener(this);
        this.setDefaultCloseOperation(2);
        this.setJMenuBar(this.createMenuBar());
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout((LayoutManager)new MigLayout());
        this.mainPanel.add((Component)this.createJogPanel(), "split 2,flowy");
        this.mainPanel.add((Component)this.createActivationPanel(), "flowy,growx");
        this.mainPanel.add((Component)this.createToolsPanel(), "spany,grow");
        this.setResizable(false);
        this.add(this.mainPanel);
        this.addWindowListener(this);
        this.updateThread = new UpdateThread(this);
        this.updateThread.start();
        this.pollThread = new PollThread(this.driver);
        this.pollThread.start();
    }

    private JMenuItem makeHomeItem(String name, final EnumSet<AxisId> set, final boolean positive) {
        JMenuItem item = new JMenuItem(name);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ControlPanelWindow.this.driver.homeAxes(set, positive, 0.0);
                }
                catch (RetryException e1) {
                    Base.logger.severe("Can't home axis; machine busy");
                }
            }
        });
        return item;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar bar = new JMenuBar();
        JMenu homeMenu = new JMenu("Homing");
        bar.add(homeMenu);
        for (AxisId axis : AxisId.values()) {
            Endstops endstops = this.driver.getMachine().getEndstops(axis);
            if (endstops == null) continue;
            if (endstops.hasMin) {
                homeMenu.add(this.makeHomeItem("Home " + axis.name() + " to minimum", EnumSet.of(axis), false));
            }
            if (!endstops.hasMax) continue;
            homeMenu.add(this.makeHomeItem("Home " + axis.name() + " to maximum", EnumSet.of(axis), true));
        }
        return bar;
    }

    protected JTextField createDisplayField() {
        int textBoxWidth = 160;
        JTextField tf = new JTextField();
        tf.setMaximumSize(new Dimension(textBoxWidth, 25));
        tf.setMinimumSize(new Dimension(textBoxWidth, 25));
        tf.setPreferredSize(new Dimension(textBoxWidth, 25));
        tf.setEnabled(false);
        return tf;
    }

    protected JComponent createJogPanel() {
        this.jogPanel = new JogPanel(this.machine);
        return this.jogPanel;
    }

    protected JComponent createActivationPanel() {
        JPanel activationPanel = new JPanel();
        activationPanel.setBorder(BorderFactory.createTitledBorder("Stepper Motor Controls"));
        activationPanel.setLayout(new BoxLayout(activationPanel, 2));
        JButton enableButton = new JButton("Enable");
        enableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ControlPanelWindow.this.driver.enableDrives();
                }
                catch (RetryException e1) {
                    Base.logger.severe("Can't change stepper state; machine busy");
                }
            }
        });
        activationPanel.add(enableButton);
        JButton disableButton = new JButton("Disable");
        disableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ControlPanelWindow.this.driver.disableDrives();
                }
                catch (RetryException e1) {
                    Base.logger.severe("Can't change stepper state; machine busy");
                }
            }
        });
        activationPanel.add(disableButton);
        activationPanel.add(Box.createHorizontalGlue());
        return activationPanel;
    }

    protected JComponent createToolsPanel() {
        this.toolsPane = new JTabbedPane();
        Enumeration<ToolModel> e = this.machine.getModel().getTools().elements();
        while (e.hasMoreElements()) {
            ToolModel t = e.nextElement();
            if (t == null) continue;
            if (t.getType().equals("extruder")) {
                Base.logger.fine("Creating panel for " + t.getName());
                ExtruderPanel extruderPanel = new ExtruderPanel(this.machine, t);
                this.toolsPane.addTab(t.getName(), extruderPanel);
                this.extruderPanels.add(extruderPanel);
                if (this.machine.getModel().currentTool() != t) continue;
                this.toolsPane.setSelectedComponent(extruderPanel);
                continue;
            }
            Base.logger.warning("Unsupported tool for control panel.");
        }
        this.toolsPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                JTabbedPane tp = (JTabbedPane)ce.getSource();
                ExtruderPanel ep = (ExtruderPanel)tp.getSelectedComponent();
                ControlPanelWindow.this.machine.getModel().selectTool(ep.getTool().getIndex());
            }
        });
        return this.toolsPane;
    }

    public void updateStatus() {
        this.jogPanel.updateStatus();
        for (ExtruderPanel e : this.extruderPanels) {
            e.updateStatus();
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.updateThread.interrupt();
        this.pollThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowClosed(WindowEvent e) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.machine.removeMachineStateListener(this);
            if (instance == this) {
                instance = null;
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void machineProgress(MachineProgressEvent event) {
    }

    @Override
    public void machineStateChanged(MachineStateChangeEvent evt) {
        MachineState state = evt.getState();
        if (state.isBuilding() || !state.isConnected() || state.getState() == MachineState.State.RESET) {
            if (this.updateThread != null) {
                this.updateThread.interrupt();
            }
            if (this.pollThread != null) {
                this.pollThread.interrupt();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ControlPanelWindow.this.dispose();
                }
            });
        }
    }

    @Override
    public void toolStatusChanged(MachineToolStatusEvent event) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    class UpdateThread
    extends Thread {
        ControlPanelWindow window;

        public UpdateThread(ControlPanelWindow w) {
            super("Control Panel Update Thread");
            this.window = w;
        }

        public void run() {
            try {
                while (true) {
                    try {
                        this.window.updateStatus();
                    }
                    catch (AssertionError ae) {
                        this.window.dispose();
                        break;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class PollThread
    extends Thread {
        Driver driver;

        public PollThread(Driver d) {
            super("Control Panel Poll Thread");
            this.driver = d;
        }

        public void run() {
            try {
                while (true) {
                    this.driver.updateManualControl();
                    Thread.sleep(700L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

