/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app;

import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import replicatorg.app.Base;
import replicatorg.app.GCodeParser;
import replicatorg.app.exceptions.BuildFailureException;
import replicatorg.app.exceptions.GCodeException;
import replicatorg.app.exceptions.JobCancelledException;
import replicatorg.app.exceptions.JobEndException;
import replicatorg.app.exceptions.JobException;
import replicatorg.app.exceptions.JobRewindException;
import replicatorg.app.tools.XML;
import replicatorg.app.ui.MainWindow;
import replicatorg.drivers.Driver;
import replicatorg.drivers.DriverFactory;
import replicatorg.drivers.EstimationDriver;
import replicatorg.drivers.OnboardParameters;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.SDCardCapture;
import replicatorg.drivers.SimulationDriver;
import replicatorg.drivers.UsesSerial;
import replicatorg.machine.MachineListener;
import replicatorg.machine.MachineProgressEvent;
import replicatorg.machine.MachineState;
import replicatorg.machine.MachineStateChangeEvent;
import replicatorg.machine.MachineToolStatusEvent;
import replicatorg.machine.model.MachineModel;
import replicatorg.machine.model.ToolModel;
import replicatorg.model.GCodeSource;
import replicatorg.model.StringListSource;

public class MachineController {
    private MachineState state = new MachineState();
    private int linesProcessed = -1;
    private int linesTotal = -1;
    private double startTimeMillis = -1.0;
    MachineThread machineThread = new MachineThread();
    protected GCodeSource source;
    protected Node machineNode;
    protected String name;
    public Driver driver = null;
    protected SimulationDriver simulator;
    protected Thread thread;
    protected double estimatedBuildTime = 0.0;
    protected Vector<String> warmupCommands;
    protected Vector<String> cooldownCommands;
    private MainWindow window;
    static Map<SDCardCapture.ResponseCode, String> sdErrorMap = new EnumMap<SDCardCapture.ResponseCode, String>(SDCardCapture.ResponseCode.class);
    private String descriptorName;
    MachineModel cachedModel;
    private Vector<MachineListener> listeners;

    public MachineState getMachineState() {
        return this.state.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(MachineState state) {
        MachineState oldState = this.state;
        this.state = state;
        if (!oldState.equals(state)) {
            this.emitStateChange(oldState, state);
            MachineThread machineThread = this.machineThread;
            synchronized (machineThread) {
                this.machineThread.notify();
            }
        }
    }

    private void setState(MachineState.State state) {
        MachineState newState = this.getMachineState();
        newState.setState(state);
        this.setState(newState);
    }

    private void readName() {
        if (this.driver instanceof OnboardParameters) {
            String n = ((OnboardParameters)((Object)this.driver)).getMachineName();
            if (n != null && n.length() > 0) {
                this.name = n;
            } else {
                this.parseName();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public MachineController(Node mNode) {
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_NO_CARD, "No SD card was detected.  Please make sure you have a working, formatted\nSD card in the motherboard's SD slot and try again.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_INIT, "ReplicatorG was unable to initialize the SD card.  Please make sure that\nthe SD card works properly.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_PARTITION, "ReplicatorG was unable to read the SD card's partition table.  Please check\nthat the card is partitioned properly.\nIf you believe your SD card is OK, try resetting your device and restarting\nReplicatorG.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_FS, "ReplicatorG was unable to open the filesystem on the SD card.  Please make sure\nthat the SD card has a single partition formatted with a FAT16 filesystem.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_ROOT_DIR, "ReplicatorG was unable to read the root directory on the SD card.  Please\ncheck to see if the SD card was formatted properly.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_LOCKED, "The SD card cannot be written to because it is locked.  Remove the card,\nswitch the lock off, and try again.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_NO_FILE, "ReplicatorG could not find the build file on the SD card.");
        sdErrorMap.put(SDCardCapture.ResponseCode.FAIL_GENERIC, "Unknown SD card error.");
        this.cachedModel = null;
        this.listeners = new Vector();
        this.machineNode = mNode;
        this.parseName();
        Base.logger.info("Loading machine: " + this.name);
        this.loadDriver();
        this.loadExtraPrefs();
        this.machineThread = new MachineThread();
        this.machineThread.start();
    }

    public void setCodeSource(GCodeSource source) {
        this.source = source;
    }

    public void setMainWindow(MainWindow window) {
        this.window = window;
    }

    public boolean processSDResponse(SDCardCapture.ResponseCode code) {
        if (code == SDCardCapture.ResponseCode.SUCCESS) {
            return true;
        }
        String message = sdErrorMap.get((Object)code);
        JOptionPane.showMessageDialog(this.window, message, "SD card error", 0);
        return false;
    }

    public String getDescriptorName() {
        return this.descriptorName;
    }

    private void parseName() {
        NodeList kids = this.machineNode.getChildNodes();
        for (int j = 0; j < kids.getLength(); ++j) {
            Node kid = kids.item(j);
            if (!kid.getNodeName().equals("name")) continue;
            this.name = this.descriptorName = kid.getFirstChild().getNodeValue().trim();
            return;
        }
        this.name = "Unknown";
    }

    public boolean buildRemote(String remoteName) {
        this.machineThread.buildRemote(remoteName);
        return true;
    }

    public boolean execute() {
        if (this.simulator != null && Base.preferences.getBoolean("build.showSimulator", false)) {
            this.simulator.createWindow();
        }
        Base.logger.info("Estimating build time...");
        this.estimate();
        Base.logger.info("Beginning build.");
        this.machineThread.build(this.source);
        return true;
    }

    public boolean simulate() {
        if (this.simulator != null) {
            this.simulator.createWindow();
        }
        Base.logger.info("Estimating build time...");
        this.estimate();
        Base.logger.info("Beginning simulation.");
        this.machineThread.simulate(this.source);
        return true;
    }

    public void estimate() {
        block6: {
            if (this.source == null) {
                return;
            }
            try {
                EstimationDriver estimator = new EstimationDriver();
                estimator.setMachine(this.loadModel());
                for (String line : this.source) {
                    if (line.indexOf("M" + Integer.toString(997)) != -1 || line.indexOf("M" + Integer.toString(998)) != -1 || line.indexOf("M" + Integer.toString(999)) != -1) continue;
                    estimator.parse(line);
                    estimator.execute();
                }
                if (this.simulator != null) {
                    this.simulator.setSimulationBounds(estimator.getBounds());
                }
                if (this.driver instanceof SimulationDriver) {
                    ((SimulationDriver)this.driver).setSimulationBounds(estimator.getBounds());
                }
                this.estimatedBuildTime = estimator.getBuildTime();
                Base.logger.info("Estimated build time is: " + EstimationDriver.getBuildTimeString(this.estimatedBuildTime));
            }
            catch (InterruptedException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    private MachineModel loadModel() {
        MachineModel model = new MachineModel();
        model.loadXML(this.machineNode);
        return model;
    }

    private void loadDriver() {
        if (Base.preferences.getBoolean("machinecontroller.simulator", true)) {
            Base.logger.info("Loading simulator.");
            this.simulator = new SimulationDriver();
            this.simulator.setMachine(this.loadModel());
        }
        Node driverXml = null;
        NodeList kids = this.machineNode.getChildNodes();
        for (int j = 0; j < kids.getLength(); ++j) {
            Node kid = kids.item(j);
            if (!kid.getNodeName().equals("driver")) continue;
            driverXml = kid;
        }
        this.driver = DriverFactory.factory(driverXml);
        this.driver.setMachine(this.getModel());
    }

    private void loadExtraPrefs() {
        int i;
        String[] commands = null;
        String command = null;
        this.warmupCommands = new Vector();
        if (XML.hasChildNode(this.machineNode, "warmup")) {
            String warmup = XML.getChildNodeValue(this.machineNode, "warmup");
            commands = warmup.split("\n");
            for (i = 0; i < commands.length; ++i) {
                command = commands[i].trim();
                this.warmupCommands.add(new String(command));
            }
        }
        this.cooldownCommands = new Vector();
        if (XML.hasChildNode(this.machineNode, "cooldown")) {
            String cooldown = XML.getChildNodeValue(this.machineNode, "cooldown");
            commands = cooldown.split("\n");
            for (i = 0; i < commands.length; ++i) {
                command = commands[i].trim();
                this.cooldownCommands.add(new String(command));
            }
        }
    }

    public Driver getDriver() {
        return this.driver;
    }

    public SimulationDriver getSimulatorDriver() {
        return this.simulator;
    }

    public MachineModel getModel() {
        if (this.cachedModel == null) {
            this.cachedModel = this.loadModel();
        }
        return this.cachedModel;
    }

    public synchronized void stop() {
        this.machineThread.stopBuild();
    }

    public synchronized boolean isInitialized() {
        return this.driver != null && this.driver.isInitialized();
    }

    public synchronized void pause() {
        this.machineThread.pauseBuild();
    }

    public synchronized void upload(String remoteName) {
        this.machineThread.upload(this.source, remoteName);
    }

    public synchronized void buildToFile(String path) {
        this.machineThread.buildToFile(this.source, path);
    }

    public synchronized void unpause() {
        this.machineThread.resumeBuild();
    }

    public synchronized void reset() {
        this.machineThread.reset();
    }

    public synchronized void connect() {
        if (!this.machineThread.isAlive()) {
            this.machineThread = new MachineThread();
            this.machineThread.start();
        }
        this.machineThread.connect();
    }

    public synchronized void disconnect() {
        this.driver.uninitialize();
        this.setState(new MachineState(MachineState.State.NOT_ATTACHED));
    }

    public synchronized boolean isPaused() {
        return this.getMachineState().isPaused();
    }

    public void dispose() {
        if (this.machineThread != null) {
            this.machineThread.shutdown();
            try {
                this.machineThread.join(5000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.driver != null) {
            this.driver.dispose();
        }
        if (this.getSimulatorDriver() != null) {
            this.getSimulatorDriver().dispose();
        }
        this.setState(new MachineState(MachineState.State.NOT_ATTACHED));
    }

    public void addMachineStateListener(MachineListener listener) {
        this.listeners.add(listener);
        listener.machineStateChanged(new MachineStateChangeEvent(this, this.getMachineState()));
    }

    public void removeMachineStateListener(MachineListener listener) {
        this.listeners.remove(listener);
    }

    protected void emitStateChange(MachineState prev, MachineState current) {
        MachineStateChangeEvent e = new MachineStateChangeEvent(this, current, prev);
        Vector<MachineListener> lclone = new Vector<MachineListener>(this.listeners);
        for (MachineListener l : lclone) {
            l.machineStateChanged(e);
        }
    }

    protected void emitProgress(MachineProgressEvent progress) {
        for (MachineListener l : this.listeners) {
            l.machineProgress(progress);
        }
    }

    protected void emitToolStatus(ToolModel tool) {
        MachineToolStatusEvent e = new MachineToolStatusEvent(this, tool);
        for (MachineListener l : this.listeners) {
            l.toolStatusChanged(e);
        }
    }

    public int getLinesProcessed() {
        return this.linesProcessed;
    }

    class MachineThread
    extends Thread {
        private long lastPolled = 0L;
        private boolean pollingEnabled = false;
        private long pollIntervalMs = 1000L;
        GCodeSource currentSource;
        String remoteName = null;
        private boolean running = true;

        MachineThread() {
        }

        synchronized void startStatusPolling(long interval) {
            this.pollingEnabled = true;
            this.pollIntervalMs = interval;
        }

        synchronized void stopStatusPolling() {
            this.pollingEnabled = false;
        }

        private void runWarmupCommands() throws BuildFailureException, InterruptedException {
            Base.logger.info("Running warmup commands.");
            this.buildCodesInternal(new StringListSource(MachineController.this.warmupCommands));
        }

        private void runCooldownCommands() throws BuildFailureException, InterruptedException {
            Base.logger.info("Running cooldown commands.");
            this.buildCodesInternal(new StringListSource(MachineController.this.cooldownCommands));
        }

        public void interruptDriver() {
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean buildCodesInternal(GCodeSource source) throws BuildFailureException, InterruptedException {
            if (!MachineController.this.state.isBuilding()) {
                return false;
            }
            MachineController.this.driver.getParser().init(MachineController.this.driver);
            Iterator<String> i = source.iterator();
            boolean retry = false;
            while (i.hasNext()) {
                long curMillis;
                if (!retry) {
                    String line = i.next();
                    MachineController.this.linesProcessed++;
                    if (Thread.currentThread().isInterrupted()) {
                        throw new BuildFailureException("Build was interrupted");
                    }
                    if (MachineController.this.simulator.isSimulating()) {
                        MachineController.this.simulator.parse(line);
                    }
                    if (!MachineController.this.state.isSimulating()) {
                        MachineController.this.driver.parse(line);
                    }
                }
                try {
                    GCodeParser.StopInfo info = MachineController.this.driver.getParser().getStops();
                    if (info != null && Base.preferences.getBoolean("machine.optionalstops", true) && MachineController.this.state.isBuilding() && MachineController.this.state.isInteractiveTarget()) {
                        JobException e = info.getException();
                        if (info.isOptional()) {
                            int result = JOptionPane.showConfirmDialog(null, info.getMessage(), "Continue Build?", 0);
                            if (result != 0) {
                                e = info.getCancelException();
                            }
                        } else {
                            JOptionPane.showMessageDialog(null, info.getMessage(), "Build stop", 1);
                        }
                        if (e != null) {
                            throw e;
                        }
                    }
                }
                catch (JobEndException e) {
                    return true;
                }
                catch (JobCancelledException e) {
                    throw new BuildFailureException("Job cancelled by user.");
                }
                catch (JobRewindException e) {
                    i = source.iterator();
                    continue;
                }
                catch (JobException e) {
                    Base.logger.severe("Unknown job exception emitted");
                }
                if (!retry && MachineController.this.simulator.isSimulating()) {
                    try {
                        MachineController.this.simulator.execute();
                    }
                    catch (RetryException r) {
                        // empty catch block
                    }
                }
                try {
                    if (!MachineController.this.state.isSimulating()) {
                        MachineController.this.driver.execute();
                    }
                    retry = false;
                }
                catch (RetryException r) {
                    Base.logger.log(Level.FINE, "Message delivery failed, retrying");
                    retry = true;
                }
                catch (GCodeException e) {
                    Base.logger.severe("Error: " + e.getMessage());
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (!MachineController.this.state.isSimulating()) {
                    MachineController.this.driver.checkErrors();
                }
                if (MachineController.this.state.isPaused()) {
                    if (!MachineController.this.state.isSimulating()) {
                        MachineController.this.driver.pause();
                    }
                    while (MachineController.this.state.isPaused()) {
                        MachineThread ie = this;
                        synchronized (ie) {
                            this.wait();
                        }
                    }
                    if (!MachineController.this.state.isSimulating()) {
                        MachineController.this.driver.unpause();
                    }
                }
                if (MachineController.this.state.getState() == MachineState.State.STOPPING || MachineController.this.state.getState() == MachineState.State.RESET) {
                    if (!MachineController.this.state.isSimulating()) {
                        MachineController.this.driver.stop(true);
                    }
                    throw new BuildFailureException("Build manually aborted");
                }
                if (MachineController.this.state.getState() != MachineState.State.BUILDING) {
                    return false;
                }
                if (this.pollingEnabled && this.lastPolled + this.pollIntervalMs <= (curMillis = System.currentTimeMillis())) {
                    this.lastPolled = curMillis;
                    this.pollStatus();
                }
                MachineProgressEvent progress = new MachineProgressEvent((double)System.currentTimeMillis() - MachineController.this.startTimeMillis, MachineController.this.estimatedBuildTime, MachineController.this.linesProcessed, MachineController.this.linesTotal);
                MachineController.this.emitProgress(progress);
            }
            if (!MachineController.this.state.isSimulating()) {
                while (!MachineController.this.driver.isFinished()) {
                    if (MachineController.this.state.getState() == MachineState.State.STOPPING || MachineController.this.state.getState() == MachineState.State.RESET) {
                        if (!MachineController.this.state.isSimulating()) {
                            MachineController.this.driver.stop(true);
                        }
                        throw new BuildFailureException("Build manually aborted");
                    }
                    if (MachineController.this.state.getState() != MachineState.State.BUILDING) {
                        return false;
                    }
                    Thread.sleep(100L);
                }
            }
            return true;
        }

        public boolean isReady() {
            return MachineController.this.state.isReady();
        }

        public void pollStatus() {
            if (MachineController.this.state.isBuilding() && !MachineController.this.state.isSimulating() && Base.preferences.getBoolean("build.monitor_temp", false)) {
                MachineController.this.driver.readTemperature();
                MachineController.this.emitToolStatus(MachineController.this.driver.getMachine().currentTool());
            }
        }

        public void reset() {
            if (MachineController.this.state.isConnected()) {
                MachineController.this.setState(new MachineState(MachineState.State.RESET));
            }
        }

        public void connect() {
            MachineController.this.setState(new MachineState(MachineState.State.CONNECTING));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildInternal(GCodeSource source) {
            MachineController.this.startTimeMillis = System.currentTimeMillis();
            MachineController.this.linesProcessed = 0;
            MachineController.this.linesTotal = MachineController.this.warmupCommands.size() + MachineController.this.cooldownCommands.size() + source.getLineCount();
            this.startStatusPolling(1000L);
            try {
                if (!MachineController.this.state.isSimulating()) {
                    MachineController.this.driver.getCurrentPosition();
                }
                this.runWarmupCommands();
                Base.logger.info("Running build.");
                this.buildCodesInternal(source);
                this.runCooldownCommands();
                if (!MachineController.this.state.isSimulating()) {
                    MachineController.this.driver.invalidatePosition();
                }
                MachineController.this.setState(new MachineState(MachineController.this.driver.isInitialized() ? MachineState.State.READY : MachineState.State.NOT_ATTACHED));
            }
            catch (BuildFailureException e) {
                if (MachineController.this.state.isSimulating()) {
                    MachineController.this.setState(new MachineState(MachineController.this.driver.isInitialized() ? MachineState.State.READY : MachineState.State.NOT_ATTACHED));
                } else {
                    MachineController.this.setState(new MachineState(MachineState.State.CONNECTING));
                }
            }
            catch (InterruptedException e) {
                Base.logger.warning("MachineController interrupted");
            }
            finally {
                this.stopStatusPolling();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildRemoteInternal(String remoteName) {
            if (remoteName == null || !(MachineController.this.driver instanceof SDCardCapture)) {
                return;
            }
            if (MachineController.this.state.getState() != MachineState.State.PLAYBACK) {
                return;
            }
            MachineController.this.driver.getCurrentPosition();
            SDCardCapture sdcc = (SDCardCapture)((Object)MachineController.this.driver);
            if (!MachineController.this.processSDResponse(sdcc.playback(remoteName))) {
                MachineController.this.setState(MachineState.State.STOPPING);
                return;
            }
            while (this.running && !MachineController.this.driver.isFinished()) {
                try {
                    MachineThread machineThread;
                    if (MachineController.this.state.isPaused()) {
                        MachineController.this.driver.pause();
                        while (MachineController.this.state.isPaused()) {
                            machineThread = this;
                            synchronized (machineThread) {
                                this.wait();
                            }
                        }
                        MachineController.this.driver.unpause();
                    }
                    if (MachineController.this.state.getState() != MachineState.State.PLAYBACK) {
                        return;
                    }
                    machineThread = this;
                    synchronized (machineThread) {
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException e) {
                    if (MachineController.this.state.getState() == MachineState.State.PLAYBACK) continue;
                    return;
                }
            }
            MachineController.this.driver.invalidatePosition();
            MachineController.this.setState(new MachineState(MachineState.State.READY));
        }

        public void build(GCodeSource source) {
            this.currentSource = source;
            MachineController.this.setState(new MachineState(MachineState.State.BUILDING, MachineState.Target.MACHINE));
        }

        public void simulate(GCodeSource source) {
            this.currentSource = source;
            MachineController.this.setState(new MachineState(MachineState.State.BUILDING, MachineState.Target.SIMULATOR));
        }

        public void upload(GCodeSource source, String remoteName) {
            this.currentSource = source;
            this.remoteName = remoteName;
            MachineController.this.setState(new MachineState(MachineState.State.BUILDING, MachineState.Target.SD_UPLOAD));
        }

        public void buildToFile(GCodeSource source, String path) {
            this.currentSource = source;
            this.remoteName = path;
            MachineController.this.setState(new MachineState(MachineState.State.BUILDING, MachineState.Target.FILE));
        }

        public void buildRemote(String remoteName) {
            this.remoteName = remoteName;
            MachineController.this.setState(MachineState.State.PLAYBACK);
        }

        public void pauseBuild() {
            if (MachineController.this.state.isBuilding() && !MachineController.this.state.isPaused()) {
                MachineState newState = MachineController.this.getMachineState();
                newState.setPaused(true);
                MachineController.this.setState(newState);
            }
        }

        public void resumeBuild() {
            if (MachineController.this.state.isBuilding() && MachineController.this.state.isPaused()) {
                MachineState newState = MachineController.this.getMachineState();
                newState.setPaused(false);
                MachineController.this.setState(newState);
            }
        }

        public void stopBuild() {
            MachineController.this.driver.getMachine().currentTool().setTargetTemperature(0.0);
            MachineController.this.driver.getMachine().currentTool().setPlatformTargetTemperature(0.0);
            if (MachineController.this.state.isBuilding()) {
                MachineController.this.setState(MachineState.State.STOPPING);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            if (MachineController.this.state.getState() == MachineState.State.PLAYBACK) {
                this.running = false;
                return;
            }
            if (MachineController.this.state.isBuilding()) {
                MachineController.this.setState(MachineState.State.STOPPING);
            }
            this.running = false;
            MachineThread machineThread = this;
            synchronized (machineThread) {
                this.notify();
            }
        }

        protected boolean isRunning() {
            return this.running || MachineController.this.state.getState() == MachineState.State.STOPPING;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.isRunning()) {
                try {
                    Object us;
                    if (MachineController.this.state.getState() == MachineState.State.BUILDING) {
                        SDCardCapture sdcc;
                        if (MachineController.this.state.getTarget() == MachineState.Target.SD_UPLOAD) {
                            if (MachineController.this.driver instanceof SDCardCapture) {
                                sdcc = (SDCardCapture)((Object)MachineController.this.driver);
                                if (MachineController.this.processSDResponse(sdcc.beginCapture(this.remoteName))) {
                                    this.buildInternal(this.currentSource);
                                    Base.logger.info("Captured bytes: " + Integer.toString(sdcc.endCapture()));
                                    continue;
                                }
                                MachineController.this.setState(MachineState.State.STOPPING);
                                continue;
                            }
                            MachineController.this.setState(MachineState.State.STOPPING);
                            continue;
                        }
                        if (MachineController.this.state.getTarget() == MachineState.Target.FILE) {
                            if (MachineController.this.driver instanceof SDCardCapture) {
                                sdcc = (SDCardCapture)((Object)MachineController.this.driver);
                                try {
                                    sdcc.beginFileCapture(this.remoteName);
                                    this.buildInternal(this.currentSource);
                                    sdcc.endFileCapture();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                continue;
                            }
                            MachineController.this.setState(MachineState.State.STOPPING);
                            continue;
                        }
                        this.buildInternal(this.currentSource);
                        continue;
                    }
                    if (MachineController.this.state.getState() == MachineState.State.PLAYBACK) {
                        this.buildRemoteInternal(this.remoteName);
                        continue;
                    }
                    if (MachineController.this.state.getState() == MachineState.State.CONNECTING) {
                        MachineController.this.driver.initialize();
                        if (MachineController.this.driver.isInitialized()) {
                            MachineController.this.readName();
                            MachineController.this.setState(MachineState.State.READY);
                            continue;
                        }
                        MachineController.this.setState(MachineState.State.NOT_ATTACHED);
                        continue;
                    }
                    if (MachineController.this.state.getState() == MachineState.State.STOPPING) {
                        MachineController.this.driver.stop(true);
                        MachineController.this.setState(MachineState.State.READY);
                        continue;
                    }
                    if (MachineController.this.state.getState() == MachineState.State.RESET) {
                        MachineController.this.driver.reset();
                        MachineController.this.readName();
                        MachineController.this.setState(MachineState.State.READY);
                        continue;
                    }
                    if (MachineController.this.state.getState() == MachineState.State.NOT_ATTACHED && MachineController.this.driver instanceof UsesSerial) {
                        us = (UsesSerial)((Object)MachineController.this.driver);
                        us.setSerial(null);
                    }
                    us = this;
                    synchronized (us) {
                        if (MachineController.this.state.getState() == MachineState.State.READY || MachineController.this.state.getState() == MachineState.State.NOT_ATTACHED || MachineController.this.state.isPaused()) {
                            this.wait();
                        }
                    }
                }
                catch (InterruptedException ie) {
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

