/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app;

import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point3d;
import replicatorg.app.Base;
import replicatorg.app.exceptions.GCodeException;
import replicatorg.app.exceptions.JobCancelledException;
import replicatorg.app.exceptions.JobEndException;
import replicatorg.app.exceptions.JobException;
import replicatorg.app.exceptions.JobRewindException;
import replicatorg.drivers.Driver;
import replicatorg.drivers.MultiTool;
import replicatorg.drivers.PenPlotter;
import replicatorg.drivers.RetryException;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.ToolModel;
import replicatorg.util.Point5d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCodeParser {
    protected String command;
    protected Driver driver;
    Queue<Point5d> pointQueue;
    protected Hashtable<String, Double> codeValues;
    protected Hashtable<String, Boolean> seenCodes;
    protected static String[] codes = new String[]{"A", "B", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "P", "Q", "R", "S", "T", "X", "Y", "Z"};
    public static double curveSectionMM = Base.preferences.getDouble("replicatorg.parser.curve_segment_mm", 1.0);
    public static double curveSectionInches = curveSectionMM / 25.4;
    protected double curveSection = 0.0;
    protected static int XY_PLANE = 0;
    protected static int ZX_PLANE = 1;
    protected static int ZY_PLANE = 2;
    protected int currentPlane = 0;
    protected Point3d currentOffset;
    protected Point5d target;
    protected Point5d delta;
    boolean absoluteMode = false;
    double feedrate = 0.0;
    int lastGCode = -1;
    protected int tool = -1;
    protected String comment = "";
    Pattern parenPattern;
    Pattern semiPattern;
    Pattern deleteBlockPattern;
    public static int UNITS_MM = 0;
    public static int UNITS_INCHES = 1;
    protected int units;
    protected Point3d drillTarget;
    protected double drillRetract = 0.0;
    protected double drillFeedrate = 0.0;
    protected int drillDwell = 0;
    protected double drillPecksize = 0.0;
    protected Class<?> extClass;
    protected Object objExtClass;
    public static final String TB_CODE = "M";
    public static final int TB_INIT = 997;
    public static final int TB_MESSAGE = 998;
    public static final int TB_CLEANUP = 999;
    private boolean breakoutZMoves = Base.preferences.getBoolean("replicatorg.parser.breakzmoves", false);

    public GCodeParser() {
        this.units = UNITS_MM;
        this.curveSection = curveSectionMM;
        this.parenPattern = Pattern.compile("\\((.*)\\)");
        this.semiPattern = Pattern.compile(";(.*)");
        this.deleteBlockPattern = Pattern.compile("^(\\.*)");
        this.target = new Point5d();
        this.delta = new Point5d();
        this.drillTarget = new Point3d();
        this.codeValues = new Hashtable(codes.length, 1.0f);
        this.seenCodes = new Hashtable(codes.length, 1.0f);
        this.currentOffset = new Point3d();
        this.pointQueue = new LinkedList<Point5d>();
    }

    protected double getMaxFeedrate() {
        return this.driver.getMachine().getMaximumFeedrates().x();
    }

    public void init(Driver drv) {
        this.driver = drv;
        this.breakoutZMoves = Base.preferences.getBoolean("replicatorg.parser.breakzmoves", false);
        this.currentOffset = this.driver.getOffset(0);
        this.pointQueue = new LinkedList<Point5d>();
    }

    public boolean parse(String cmd) {
        this.cleanup();
        this.command = cmd;
        this.parseComments();
        this.stripComments();
        for (int i = 0; i < codes.length; ++i) {
            double value = this.parseCode(codes[i]);
            this.codeValues.put(new String(codes[i]), new Double(value));
        }
        if (!this.hasCode("G") && (this.hasCode("X") || this.hasCode("Y") || this.hasCode("Z"))) {
            this.seenCodes.put(new String("G"), new Boolean(true));
            this.codeValues.put(new String("G"), new Double(this.lastGCode));
        }
        return true;
    }

    private boolean findCode(String code) {
        return this.command.indexOf(code) >= 0;
    }

    public double convertToMM(double value, int units) {
        if (units == UNITS_INCHES) {
            return value * 25.4;
        }
        return value;
    }

    public double getCodeValue(String c) {
        Double d = this.codeValues.get(c);
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    private boolean hasCode(String code) {
        Boolean b = this.seenCodes.get(code);
        if (b != null) {
            return b;
        }
        return false;
    }

    private double parseCode(String code) {
        Pattern myPattern = Pattern.compile(code + "([0-9.+-]+)");
        Matcher myMatcher = myPattern.matcher(this.command);
        if (this.findCode(code)) {
            this.seenCodes.put(code, new Boolean(true));
            if (myMatcher.find()) {
                String match = myMatcher.group(1);
                double number = Double.parseDouble(match);
                return number;
            }
            return 0.0;
        }
        return 0.0;
    }

    private void parseComments() {
        Matcher parenMatcher = this.parenPattern.matcher(this.command);
        Matcher semiMatcher = this.semiPattern.matcher(this.command);
        if (parenMatcher.find()) {
            this.comment = parenMatcher.group(1);
        }
        if (semiMatcher.find()) {
            this.comment = semiMatcher.group(1);
        }
        this.comment = this.comment.trim();
        this.comment = this.comment.replace('|', '\n');
    }

    private void stripComments() {
        Matcher parenMatcher = this.parenPattern.matcher(this.command);
        this.command = parenMatcher.replaceAll("");
        Matcher semiMatcher = this.semiPattern.matcher(this.command);
        this.command = semiMatcher.replaceAll("");
    }

    public String getCommand() {
        return new String(this.command);
    }

    public void execute() throws GCodeException, RetryException {
        if (!this.pointQueue.isEmpty()) {
            while (!this.pointQueue.isEmpty()) {
                Base.logger.fine("dequeueing!");
                this.setTarget(this.pointQueue.peek());
                this.pointQueue.remove();
            }
        } else {
            this.executeMCodes();
            this.executeGCodes();
            int tempTool = (int)this.getCodeValue("T");
            if (this.hasCode("T")) {
                if (tempTool != this.tool) {
                    this.driver.selectTool(tempTool);
                }
                this.tool = tempTool;
            }
        }
    }

    private void executeMCodes() throws GCodeException, RetryException {
        if (this.hasCode(TB_CODE)) {
            if (this.hasCode("T") && this.driver instanceof MultiTool && ((MultiTool)((Object)this.driver)).supportsSimultaneousTools()) {
                this.driver.getMachine().selectTool((int)this.getCodeValue("T"));
            }
            switch ((int)this.getCodeValue(TB_CODE)) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    this.driver.setSpindleDirection(ToolModel.MOTOR_CLOCKWISE);
                    this.driver.enableSpindle();
                    break;
                }
                case 4: {
                    this.driver.setSpindleDirection(ToolModel.MOTOR_COUNTER_CLOCKWISE);
                    this.driver.enableSpindle();
                    break;
                }
                case 5: {
                    this.driver.disableSpindle();
                    break;
                }
                case 6: {
                    int timeout = 65535;
                    if (this.hasCode("P")) {
                        timeout = (int)this.getCodeValue("P");
                    }
                    if (this.hasCode("T")) {
                        this.driver.requestToolChange((int)this.getCodeValue("T"), timeout);
                        break;
                    }
                    throw new GCodeException("The T parameter is required for tool changes. (M6)");
                }
                case 7: {
                    this.driver.enableFloodCoolant();
                    break;
                }
                case 8: {
                    this.driver.enableMistCoolant();
                    break;
                }
                case 9: {
                    this.driver.disableFloodCoolant();
                    this.driver.disableMistCoolant();
                    break;
                }
                case 10: {
                    if (this.hasCode("Q")) {
                        this.driver.closeClamp((int)this.getCodeValue("Q"));
                        break;
                    }
                    throw new GCodeException("The Q parameter is required for clamp operations. (M10)");
                }
                case 11: {
                    if (this.hasCode("Q")) {
                        this.driver.openClamp((int)this.getCodeValue("Q"));
                        break;
                    }
                    throw new GCodeException("The Q parameter is required for clamp operations. (M11)");
                }
                case 13: {
                    this.driver.setSpindleDirection(ToolModel.MOTOR_CLOCKWISE);
                    this.driver.enableSpindle();
                    this.driver.enableFloodCoolant();
                    break;
                }
                case 14: {
                    this.driver.setSpindleDirection(ToolModel.MOTOR_COUNTER_CLOCKWISE);
                    this.driver.enableSpindle();
                    this.driver.enableFloodCoolant();
                    break;
                }
                case 17: {
                    this.driver.enableDrives();
                    break;
                }
                case 18: {
                    this.driver.disableDrives();
                    break;
                }
                case 21: {
                    this.driver.openCollet();
                    break;
                }
                case 22: {
                    this.driver.closeCollet();
                    break;
                }
                case 40: {
                    this.driver.changeGearRatio(0);
                    break;
                }
                case 41: {
                    this.driver.changeGearRatio(1);
                    break;
                }
                case 42: {
                    this.driver.changeGearRatio(2);
                    break;
                }
                case 43: {
                    this.driver.changeGearRatio(3);
                    break;
                }
                case 44: {
                    this.driver.changeGearRatio(4);
                    break;
                }
                case 45: {
                    this.driver.changeGearRatio(5);
                    break;
                }
                case 46: {
                    this.driver.changeGearRatio(6);
                    break;
                }
                case 50: {
                    this.driver.getSpindleRPM();
                    break;
                }
                case 101: {
                    this.driver.setMotorDirection(ToolModel.MOTOR_CLOCKWISE);
                    this.driver.enableMotor();
                    break;
                }
                case 102: {
                    this.driver.setMotorDirection(ToolModel.MOTOR_COUNTER_CLOCKWISE);
                    this.driver.enableMotor();
                    break;
                }
                case 103: {
                    this.driver.disableMotor();
                    break;
                }
                case 104: {
                    if (!this.hasCode("S")) break;
                    this.driver.setTemperature(this.getCodeValue("S"));
                    break;
                }
                case 105: {
                    this.driver.readTemperature();
                    break;
                }
                case 106: {
                    this.driver.enableFan();
                    break;
                }
                case 107: {
                    this.driver.disableFan();
                    break;
                }
                case 108: {
                    if (this.hasCode("S")) {
                        this.driver.setMotorSpeedPWM((int)Math.round(this.getCodeValue("S")));
                        break;
                    }
                    if (!this.hasCode("R")) break;
                    this.driver.setMotorRPM(this.getCodeValue("R"));
                    break;
                }
                case 109: {
                    if (!this.hasCode("S")) break;
                    this.driver.setPlatformTemperature(this.getCodeValue("S"));
                    break;
                }
                case 110: {
                    this.driver.setChamberTemperature(this.getCodeValue("S"));
                }
                case 126: {
                    this.driver.openValve();
                    break;
                }
                case 127: {
                    this.driver.closeValve();
                    break;
                }
                case 128: {
                    this.driver.getPosition();
                    break;
                }
                case 129: {
                    break;
                }
                case 130: {
                    break;
                }
                case 200: {
                    this.driver.initialize();
                    break;
                }
                case 201: {
                    break;
                }
                case 202: {
                    break;
                }
                case 203: {
                    break;
                }
                case 204: {
                    break;
                }
                case 300: {
                    if (!this.hasCode("S") || !(this.driver instanceof PenPlotter)) break;
                    ((PenPlotter)((Object)this.driver)).setServoPos(0, this.getCodeValue("S"));
                    break;
                }
                case 301: {
                    if (!this.hasCode("S") || !(this.driver instanceof PenPlotter)) break;
                    ((PenPlotter)((Object)this.driver)).setServoPos(1, this.getCodeValue("S"));
                    break;
                }
                case 997: {
                    try {
                        String[] params = this.command.split(" ");
                        this.extClass = Class.forName(params[1]);
                        this.objExtClass = this.extClass.newInstance();
                        String methParam = params[2];
                        Method extMethod = this.extClass.getMethod("initialize", String.class);
                        extMethod.invoke(this.objExtClass, methParam);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 998: {
                    try {
                        String[] params = this.command.split(" ");
                        String[] params2 = this.command.split("\\'");
                        String methParam = params2[1];
                        Method extMethod = this.extClass.getMethod(params[1], String.class);
                        extMethod.invoke(this.objExtClass, methParam);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 999: {
                    this.extClass = null;
                    this.objExtClass = null;
                    break;
                }
                default: {
                    throw new GCodeException("Unknown M code: M" + (int)this.getCodeValue(TB_CODE));
                }
            }
        }
    }

    private void executeGCodes() throws GCodeException, RetryException {
        Point5d temp = this.driver.getCurrentPosition();
        double iVal = this.convertToMM(this.getCodeValue("I"), this.units);
        double jVal = this.convertToMM(this.getCodeValue("J"), this.units);
        double kVal = this.convertToMM(this.getCodeValue("K"), this.units);
        double qVal = this.convertToMM(this.getCodeValue("Q"), this.units);
        double rVal = this.convertToMM(this.getCodeValue("R"), this.units);
        double xVal = this.convertToMM(this.getCodeValue("X"), this.units);
        double yVal = this.convertToMM(this.getCodeValue("Y"), this.units);
        double zVal = this.convertToMM(this.getCodeValue("Z"), this.units);
        double aVal = this.convertToMM(this.getCodeValue("A"), this.units);
        double bVal = this.convertToMM(this.getCodeValue("B"), this.units);
        double eVal = this.convertToMM(this.getCodeValue("E"), this.units);
        xVal += this.currentOffset.x;
        yVal += this.currentOffset.y;
        zVal += this.currentOffset.z;
        if (this.absoluteMode) {
            if (this.hasCode("X")) {
                temp.setX(xVal);
            }
            if (this.hasCode("Y")) {
                temp.setY(yVal);
            }
            if (this.hasCode("Z")) {
                temp.setZ(zVal);
            }
            if (this.hasCode("A")) {
                temp.setA(aVal);
            }
            if (this.hasCode("E")) {
                if (this.tool == 0) {
                    temp.setA(eVal);
                } else if (this.tool == 1) {
                    temp.setB(eVal);
                }
            }
            if (this.hasCode("B")) {
                temp.setB(bVal);
            }
        } else {
            if (this.hasCode("X")) {
                temp.setX(temp.x() + xVal);
            }
            if (this.hasCode("Y")) {
                temp.setY(temp.y() + yVal);
            }
            if (this.hasCode("Z")) {
                temp.setZ(temp.z() + zVal);
            }
            if (this.hasCode("A")) {
                temp.setA(temp.a() + aVal);
            }
            if (this.hasCode("E")) {
                if (this.tool == 0) {
                    temp.setA(temp.a() + eVal);
                } else if (this.tool == 1) {
                    temp.setB(temp.b() + eVal);
                }
            }
            if (this.hasCode("B")) {
                temp.setB(temp.b() + bVal);
            }
        }
        if (this.hasCode("F")) {
            this.feedrate = this.getCodeValue("F");
            this.driver.setFeedrate(this.feedrate);
        }
        if (this.hasCode("G")) {
            int gCode = (int)this.getCodeValue("G");
            switch (gCode) {
                case 0: {
                    this.driver.setFeedrate(this.getMaxFeedrate());
                    this.setTarget(temp);
                    break;
                }
                case 1: {
                    this.driver.setFeedrate(this.feedrate);
                    this.setTarget(temp);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.hasCode("I") || this.hasCode("J")) {
                        Point5d center = new Point5d();
                        Point5d current = this.driver.getCurrentPosition();
                        center.setX(current.x() + iVal);
                        center.setY(current.y() + jVal);
                        if (gCode == 2) {
                            this.pointQueue.addAll(this.drawArc(center, temp, true));
                        } else {
                            this.pointQueue.addAll(this.drawArc(center, temp, false));
                        }
                    } else if (this.hasCode("R")) {
                        Base.logger.warning("G02/G03 arcs with (R)adius parameter are not supported yet.");
                        if (gCode == 2) {
                            this.pointQueue.addAll(this.drawRadius(temp, rVal, true));
                        } else {
                            this.pointQueue.addAll(this.drawRadius(temp, rVal, false));
                        }
                    }
                    while (!this.pointQueue.isEmpty()) {
                        this.setTarget(this.pointQueue.peek());
                        this.pointQueue.remove();
                    }
                    break;
                }
                case 4: {
                    this.driver.delay((long)this.getCodeValue("P"));
                    break;
                }
                case 10: {
                    if (this.hasCode("P")) {
                        int offsetSystemNum = (int)this.getCodeValue("P");
                        if (offsetSystemNum < 1 || offsetSystemNum > 6) break;
                        if (this.hasCode("X")) {
                            this.driver.setOffsetX(offsetSystemNum, this.getCodeValue("X"));
                        }
                        if (this.hasCode("Y")) {
                            this.driver.setOffsetY(offsetSystemNum, this.getCodeValue("Y"));
                        }
                        if (!this.hasCode("Z")) break;
                        this.driver.setOffsetZ(offsetSystemNum, this.getCodeValue("Z"));
                        break;
                    }
                    Base.logger.warning("No coordinate system indicated use G10 Pn, where n is 0-6.");
                    break;
                }
                case 17: {
                    this.currentPlane = XY_PLANE;
                    break;
                }
                case 18: {
                    this.currentPlane = ZX_PLANE;
                    break;
                }
                case 19: {
                    this.currentPlane = ZY_PLANE;
                    break;
                }
                case 20: 
                case 70: {
                    this.units = UNITS_INCHES;
                    this.curveSection = curveSectionInches;
                    break;
                }
                case 21: 
                case 71: {
                    this.units = UNITS_MM;
                    this.curveSection = curveSectionMM;
                    break;
                }
                case 28: {
                    EnumSet<AxisId> axes = EnumSet.noneOf(AxisId.class);
                    if (this.hasCode("X")) {
                        axes.add(AxisId.X);
                    }
                    if (this.hasCode("Y")) {
                        axes.add(AxisId.Y);
                    }
                    if (this.hasCode("Z")) {
                        axes.add(AxisId.Z);
                    }
                    this.driver.homeAxes(axes, false, this.hasCode("F") ? this.feedrate : 0.0);
                    break;
                }
                case 161: {
                    EnumSet<AxisId> axes = EnumSet.noneOf(AxisId.class);
                    if (this.hasCode("X")) {
                        axes.add(AxisId.X);
                    }
                    if (this.hasCode("Y")) {
                        axes.add(AxisId.Y);
                    }
                    if (this.hasCode("Z")) {
                        axes.add(AxisId.Z);
                    }
                    this.driver.homeAxes(axes, false, this.hasCode("F") ? this.feedrate : 0.0);
                    break;
                }
                case 162: {
                    EnumSet<AxisId> axes = EnumSet.noneOf(AxisId.class);
                    if (this.hasCode("X")) {
                        axes.add(AxisId.X);
                    }
                    if (this.hasCode("Y")) {
                        axes.add(AxisId.Y);
                    }
                    if (this.hasCode("Z")) {
                        axes.add(AxisId.Z);
                    }
                    this.driver.homeAxes(axes, true, this.hasCode("F") ? this.feedrate : 0.0);
                    break;
                }
                case 31: {
                    Base.logger.warning("Single point probes not yet supported.");
                    this.setTarget(temp);
                    break;
                }
                case 32: {
                    Base.logger.warning("Area probes not yet supported.");
                    Point5d current = this.driver.getCurrentPosition();
                    double minX = current.x();
                    double minY = current.y();
                    double maxX = xVal;
                    double maxY = yVal;
                    double increment = iVal;
                    this.probeArea(minX, minY, maxX, maxY, increment);
                    break;
                }
                case 53: {
                    this.currentOffset = this.driver.getOffset(0);
                    break;
                }
                case 54: {
                    this.currentOffset = this.driver.getOffset(1);
                    break;
                }
                case 55: {
                    this.currentOffset = this.driver.getOffset(2);
                    break;
                }
                case 56: {
                    this.currentOffset = this.driver.getOffset(3);
                    break;
                }
                case 57: {
                    this.currentOffset = this.driver.getOffset(4);
                    break;
                }
                case 58: {
                    this.currentOffset = this.driver.getOffset(5);
                    break;
                }
                case 59: {
                    this.currentOffset = this.driver.getOffset(6);
                    break;
                }
                case 80: {
                    this.drillTarget = new Point3d();
                    this.drillRetract = 0.0;
                    this.drillFeedrate = 0.0;
                    this.drillDwell = 0;
                    this.drillPecksize = 0.0;
                    break;
                }
                case 81: 
                case 82: 
                case 83: 
                case 183: {
                    boolean speedPeck = false;
                    if (this.hasCode("X")) {
                        this.drillTarget.x = temp.x();
                    }
                    if (this.hasCode("Y")) {
                        this.drillTarget.y = temp.y();
                    }
                    if (this.hasCode("Z")) {
                        this.drillTarget.z = temp.z();
                    }
                    if (this.hasCode("F")) {
                        this.drillFeedrate = this.getCodeValue("F");
                    }
                    if (this.hasCode("R")) {
                        this.drillRetract = rVal;
                    }
                    if (gCode == 81) {
                        this.drillDwell = 0;
                        this.drillPecksize = 0.0;
                    } else if (gCode == 82) {
                        if (this.hasCode("P")) {
                            this.drillDwell = (int)this.getCodeValue("P");
                        }
                        this.drillPecksize = 0.0;
                    } else if (gCode == 83 || gCode == 183) {
                        if (this.hasCode("P")) {
                            this.drillDwell = (int)this.getCodeValue("P");
                        }
                        if (this.hasCode("Q")) {
                            this.drillPecksize = Math.abs(this.getCodeValue("Q"));
                        }
                        if (gCode == 183) {
                            speedPeck = true;
                        }
                    }
                    this.drillingCycle(speedPeck);
                    break;
                }
                case 90: {
                    this.absoluteMode = true;
                    break;
                }
                case 91: {
                    this.absoluteMode = false;
                    break;
                }
                case 92: {
                    Point5d current = this.driver.getCurrentPosition();
                    if (this.hasCode("X")) {
                        current.setX(xVal);
                    }
                    if (this.hasCode("Y")) {
                        current.setY(yVal);
                    }
                    if (this.hasCode("Z")) {
                        current.setZ(zVal);
                    }
                    if (this.hasCode("A")) {
                        current.setA(aVal);
                    }
                    if (this.hasCode("E")) {
                        current.setA(eVal);
                    }
                    if (this.hasCode("B")) {
                        current.setB(bVal);
                    }
                    this.driver.setCurrentPosition(current);
                    this.target = current;
                    break;
                }
                case 94: {
                    break;
                }
                case 97: {
                    this.driver.setSpindleRPM((int)this.getCodeValue("S"));
                    break;
                }
                default: {
                    throw new GCodeException("Unknown G code: G" + (int)this.getCodeValue("G"));
                }
            }
        }
    }

    private void drillingCycle(boolean speedPeck) throws RetryException {
        Point5d current = this.driver.getCurrentPosition();
        if (current.z() < this.drillRetract) {
            this.driver.setFeedrate(this.getMaxFeedrate());
            this.setTarget(new Point5d(current.x(), current.y(), this.drillRetract, current.a(), current.b()));
        }
        this.driver.setFeedrate(this.getMaxFeedrate());
        this.setTarget(new Point5d(this.drillTarget.x, this.drillTarget.y, current.z(), current.a(), current.b()));
        double targetZ = this.drillRetract;
        double deltaZ = this.drillPecksize > 0.0 ? this.drillPecksize : this.drillRetract - this.drillTarget.z;
        do {
            if (targetZ != this.drillRetract && !speedPeck) {
                this.driver.setFeedrate(this.getMaxFeedrate());
                this.setTarget(new Point5d(this.drillTarget.x, this.drillTarget.y, targetZ, current.a(), current.b()));
            }
            if ((targetZ -= deltaZ) < this.drillTarget.z) {
                targetZ = this.drillTarget.z;
            }
            this.driver.setFeedrate(this.drillFeedrate);
            this.setTarget(new Point5d(this.drillTarget.x, this.drillTarget.y, targetZ, current.a(), current.b()));
            if (this.drillDwell > 0) {
                this.driver.delay(this.drillDwell);
            }
            if (speedPeck) continue;
            this.driver.setFeedrate(this.getMaxFeedrate());
            this.setTarget(new Point5d(this.drillTarget.x, this.drillTarget.y, this.drillRetract, current.a(), current.b()));
        } while (targetZ > this.drillTarget.z);
        if (current.z() < this.drillRetract) {
            this.driver.setFeedrate(this.getMaxFeedrate());
            this.setTarget(new Point5d(this.drillTarget.x, this.drillTarget.y, this.drillRetract, current.a(), current.b()));
        }
    }

    Queue<Point5d> drawArc(Point5d center, Point5d endpoint, boolean clockwise) {
        double angleB;
        double angleA;
        LinkedList<Point5d> points = new LinkedList<Point5d>();
        Point5d current = this.driver.getCurrentPosition();
        double aX = current.x() - center.x();
        double aY = current.y() - center.y();
        double bX = endpoint.x() - center.x();
        double bY = endpoint.y() - center.y();
        if (clockwise) {
            angleA = Math.atan2(bY, bX);
            angleB = Math.atan2(aY, aX);
        } else {
            angleA = Math.atan2(aY, aX);
            angleB = Math.atan2(bY, bX);
        }
        if (angleB <= angleA) {
            angleB += Math.PI * 2;
        }
        double angle = angleB - angleA;
        double radius = Math.sqrt(aX * aX + aY * aY);
        double length = radius * angle;
        int steps = (int)Math.ceil(Math.max(angle * 2.4, length / this.curveSection));
        Point5d newPoint = new Point5d(current);
        double arcStartZ = current.z();
        for (int s = 1; s <= steps; ++s) {
            int step = !clockwise ? s : steps - s;
            newPoint.setX(center.x() + radius * Math.cos(angleA + angle * ((double)step / (double)steps)));
            newPoint.setY(center.y() + radius * Math.sin(angleA + angle * ((double)step / (double)steps)));
            newPoint.setZ(arcStartZ + (endpoint.z() - arcStartZ) * (double)s / (double)steps);
            points.add(new Point5d(newPoint));
        }
        return points;
    }

    private Queue<Point5d> drawRadius(Point5d endpoint, double r, boolean clockwise) throws GCodeException {
        throw new GCodeException("The drawRadius command is not supported");
    }

    private void setTarget(Point5d p) throws RetryException {
        Point5d current = this.driver.getCurrentPosition();
        if (this.breakoutZMoves && p.z() != current.z()) {
            this.driver.queuePoint(new Point5d(current.x(), current.y(), p.z(), current.a(), current.b()));
        }
        this.driver.queuePoint(new Point5d(p));
        current = new Point5d(p);
    }

    public StopInfo getStops() {
        String message = null;
        if (this.comment.length() > 0) {
            message = this.comment;
        }
        if (this.hasCode(TB_CODE)) {
            this.driver.waitUntilBufferEmpty();
            int mCode = (int)this.getCodeValue(TB_CODE);
            if (mCode == 0) {
                return new StopInfo(message, new JobCancelledException());
            }
            if (mCode == 1) {
                return new StopInfo(message, null, new JobCancelledException());
            }
            if (mCode == 2) {
                return new StopInfo(message, new JobEndException());
            }
            if (mCode == 30) {
                if (message.length() == 0) {
                    message = "Program Rewind";
                }
                return new StopInfo(message, new JobRewindException(), new JobCancelledException());
            }
        }
        return null;
    }

    public void probePoint(Point3d point) {
    }

    public void probeArea(double minX, double minY, double maxX, double maxY, double increment) {
    }

    public void cleanup() {
        this.delta = new Point5d();
        if (this.hasCode("G")) {
            this.lastGCode = (int)this.getCodeValue("G");
        }
        this.codeValues.clear();
        this.seenCodes.clear();
        this.comment = "";
    }

    public class StopInfo {
        private final JobException exception;
        private final JobException cancelException;
        private final String message;
        private final boolean optional;

        public StopInfo(String message, JobException exception) {
            this.message = message;
            this.optional = false;
            this.exception = this.cancelException = exception;
        }

        public StopInfo(String message, JobException exception, JobException cancelException) {
            this.message = message;
            this.optional = true;
            this.exception = exception;
            this.cancelException = cancelException;
        }

        public String getMessage() {
            return this.message;
        }

        public JobException getException() {
            return this.exception;
        }

        public JobException getCancelException() {
            return this.cancelException;
        }

        public boolean isOptional() {
            return this.optional;
        }
    }
}

