/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.stl;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URL;
import org.j3d.loaders.stl.STLASCIIParser2;
import org.j3d.loaders.stl.STLBinaryParser;
import org.j3d.loaders.stl.STLParser;

public class STLFileReader {
    private STLParser itsParser;

    public STLFileReader(File file) throws InterruptedIOException, IOException, FileNotFoundException {
        this(file.toURI().toURL());
    }

    public STLFileReader(String fileName) throws InterruptedIOException, IOException, FileNotFoundException {
        this(new URL(fileName));
    }

    public STLFileReader(URL url) throws IOException, FileNotFoundException {
        STLASCIIParser2 asciiParser = new STLASCIIParser2();
        if (asciiParser.parse(url)) {
            this.itsParser = asciiParser;
        } else {
            STLBinaryParser binParser = new STLBinaryParser();
            binParser.parse(url);
            this.itsParser = binParser;
        }
    }

    public STLFileReader(URL url, Component parentComponent) throws InterruptedIOException, IOException, FileNotFoundException {
        STLASCIIParser2 asciiParser = new STLASCIIParser2();
        if (asciiParser.parse(url, parentComponent)) {
            this.itsParser = asciiParser;
        } else {
            STLBinaryParser binParser = new STLBinaryParser();
            binParser.parse(url, parentComponent);
            this.itsParser = binParser;
        }
    }

    public STLFileReader(File file, Component parentComponent) throws InterruptedIOException, IOException, FileNotFoundException {
        this(file.toURI().toURL(), parentComponent);
    }

    public STLFileReader(String fileName, Component parentComponent) throws InterruptedIOException, IOException, FileNotFoundException {
        this(new URL(fileName), parentComponent);
    }

    public boolean getNextFacet(double[] normal, double[][] vertices) throws InterruptedIOException, IOException {
        return this.itsParser.getNextFacet(normal, vertices);
    }

    public String[] getObjectNames() {
        return this.itsParser.getObjectNames();
    }

    public int[] getNumOfFacets() {
        return this.itsParser.getNumOfFacets();
    }

    public int getNumOfObjects() {
        return this.itsParser.getNumOfObjects();
    }

    public void close() throws IOException {
        if (this.itsParser != null) {
            this.itsParser.close();
        }
    }
}

