//
//  KinectFWTestAppDelegate.m
//  KinectFWTest
//
//  Created by Chatchavan Wacharamanotham on 13/11/2010.
//  Copyright 2010 Media Computing Group, RWTH Aachen. All rights reserved.
//

#import "KinectFWTestAppDelegate.h"

@implementation KinectFWTestAppDelegate

@synthesize window;

-(void)applicationDidFinishLaunching:(NSNotification *)aNotification 
{
	kinect = [[KNKinect alloc] initWithAnyDevice];
	kinect.delegate = self;
	[kinect start];
}

-(void)applicationWillTerminate:(NSNotification *)notification;
{
	[kinect stop];
	kinect.delegate = nil;
	[kinect release];
}

// ---------------------------------------------------------------------------------------------------------------------
#pragma mark -
#pragma mark KNKinectDelegate
// ---------------------------------------------------------------------------------------------------------------------


-(void)didUpdateDepth:(CGImageRef)theDepthImage kinect:(KNKinect *)theKinect;
{
	NSImage *aNSImage = [[NSImage alloc] initWithCGImage:theDepthImage size:NSMakeSize(640.0f, 480.0f)];
	[depthImageView setImage:aNSImage];	
	[aNSImage release];
}

-(void)didUpdateRgb:(CGImageRef)theRgbImage kinect:(KNKinect *)theKinect
{
	NSImage *aNSImage = [[NSImage alloc] initWithCGImage:theRgbImage size:NSMakeSize(640.0f, 480.0f)];
	[rgbImageView setImage:aNSImage];	
	[aNSImage release];
}


@end
