//
//  KNKinect.h
//  KinectTest
//
//  Created by Chatchavan Wacharamanotham on 13/11/2010.
//  Copyright 2010 Media Computing Group, RWTH Aachen. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#include "libusb.h"


@class KNKinect;

// =====================================================================================================================
@protocol KNKinectDelegate <NSObject>
// =====================================================================================================================

@required
-(void)didUpdateDepth:(CGImageRef)theDepthImage kinect:(KNKinect *)theKinect;
-(void)didUpdateRgb:(CGImageRef)theRgbImage kinect:(KNKinect *)theKinect;


@optional
-(void)kinectDidStart:(KNKinect *)theKinect;
-(void)kinectDidStop:(KNKinect *)theKinect;


@end
// =====================================================================================================================



// =====================================================================================================================
@interface KNKinect : NSObject 
// =====================================================================================================================
{	
	libusb_device_handle *device;
	
	id <KNKinectDelegate> delegate;
	
	NSTimer *refreshTimer;
	
	double refreshInterval;
}

@property (assign) id <KNKinectDelegate> delegate;
@property (assign) double refreshInterval;

-(id)initWithAnyDevice;
-(void)start;
-(void)stop;

// TODO: multiple device selection
//+(NSArray *)listDevices;
//-(void)initWithDeviceIndex:(NSInteger)theDeviceIndex;

@end
// =====================================================================================================================