/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.view;

import de.mcp.cutcad.view.Drawable2D;
import de.mcp.cutcad.view.Transformation;
import geomerative.RG;
import geomerative.RPoint;
import java.io.File;
import processing.core.PGraphics;

public class SVGIcon
implements Drawable2D {
    private float scaling;
    private String name;
    private RPoint[][] svgPointPaths;

    public SVGIcon(String name, float scaling) {
        this.name = name;
        this.scaling = scaling;
    }

    @Override
    public void draw2D(PGraphics context, Transformation t) {
        context.beginDraw();
        context.fill(0);
        context.strokeWeight(1.0f);
        if (this.svgPointPaths == null) {
            this.loadSVGPointPaths();
        }
        RPoint[][] rPointArray = this.svgPointPaths;
        int n = this.svgPointPaths.length;
        int n2 = 0;
        while (n2 < n) {
            RPoint[] pointPath = rPointArray[n2];
            if (pointPath != null) {
                this.drawPointPath(pointPath, context);
            }
            ++n2;
        }
        context.endDraw();
    }

    private void loadSVGPointPaths() {
        this.svgPointPaths = RG.loadShape((String)("icons" + File.separator + this.name)).getPointsInPaths();
    }

    private void drawPointPath(RPoint[] pointPath, PGraphics context) {
        context.beginShape();
        RPoint[] rPointArray = pointPath;
        int n = pointPath.length;
        int n2 = 0;
        while (n2 < n) {
            RPoint vertex = rPointArray[n2];
            context.vertex(vertex.x * this.scaling, vertex.y * this.scaling);
            ++n2;
        }
        context.endShape();
    }
}

