/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.printdialog;

import controlP5.Button;
import controlP5.ControlP5;
import controlP5.ControllerGroup;
import controlP5.Group;
import controlP5.ListBox;
import controlP5.Textfield;
import controlP5.Textlabel;
import de.mcp.cutcad.model.primitives.Shape;
import de.mcp.cutcad.printdialog.PrintDialogInstance;
import de.mcp.cutcad.printdialog.PrintInstance;
import de.mcp.cutcad.printdialog.lasercutter.LaserCutter;
import java.util.ArrayList;
import processing.core.PApplet;

class WidgetContainer
extends PApplet {
    private static final long serialVersionUID = -107837967380117539L;
    PrintDialogInstance printDialogInstance;
    ControlP5 printDialogWindowController;
    private Textfield cutterAddress;
    private ListBox unplacedShapesBox;
    private ListBox cutterBox;
    private ListBox dpiBox;
    private Textlabel statusLabel;
    private Textlabel cutterSelected;
    private Textlabel dpiSelected;
    private Textlabel dpiSelectLabel;
    private Textlabel addressEntered;
    private Button lasercutButton;
    private Button exportSVGButton;
    private Button addExtraJobButton;
    private Button confirmPrint;
    private Button declinePrint;
    private Group instanceGroup;
    private ArrayList<Button> instanceButtons;

    WidgetContainer(ControlP5 printDialogWindowController, PrintDialogInstance printDialogInstance) {
        this.printDialogWindowController = printDialogWindowController;
        this.printDialogInstance = printDialogInstance;
    }

    double[] setupButtons(int h, int w, int bedHeight, int bedWidth) {
        this.unplacedShapesBox = (ListBox)((ListBox)((ListBox)this.printDialogWindowController.addListBox("unplacedShapesList").setPosition(10.0f, 320.0f)).setSize(120, 120).setItemHeight(15).setBarHeight(15)).setColorBackground(this.color(128, 128, 128)).setColorForeground(this.color(0, 0, 0)).setColorLabel(this.color(255, 255, 255)).setCaptionLabel("Choose an object");
        this.unplacedShapesBox.getCaptionLabel().getStyle().marginTop = 3;
        this.unplacedShapesBox.getValueLabel().getStyle().marginTop = 3;
        this.updateListBox();
        this.lasercutButton = (Button)((Button)((Button)((Button)((Button)((Button)this.printDialogWindowController.addButton("Start cutting").setPosition(10.0f, (float)(h - 70))).setSize(100, 30)).setColorBackground(this.color(128, 128, 128))).setColorForeground(this.color(0, 0, 0))).setColorCaptionLabel(this.color(255, 255, 255))).setId(0);
        this.exportSVGButton = (Button)((Button)((Button)((Button)((Button)((Button)this.printDialogWindowController.addButton("Export as SVG").setPosition(120.0f, (float)(h - 70))).setSize(80, 30)).setColorBackground(this.color(128, 128, 128))).setColorForeground(this.color(0, 0, 0))).setColorCaptionLabel(this.color(255, 255, 255))).setId(1);
        this.addExtraJobButton = (Button)((Button)((Button)((Button)((Button)((Button)this.printDialogWindowController.addButton("Add extra job").setPosition(10.0f, (float)(h - 140))).setSize(100, 30)).setColorBackground(this.color(128, 128, 128))).setColorForeground(this.color(0, 0, 0))).setColorCaptionLabel(this.color(255, 255, 255))).setId(2);
        this.statusLabel = ((Textlabel)((Textlabel)((Textlabel)this.printDialogWindowController.addTextlabel("statusLabel").setPosition(10.0f, (float)(h - 100))).setSize(120, 30)).setColorValueLabel(-65536)).setFont(this.createFont("Georgia", 12.0f)).setText("");
        this.instanceButtons = new ArrayList();
        this.instanceGroup = (Group)((Group)((Group)((Group)((Group)((Group)((Group)this.printDialogWindowController.addGroup("Jobs").setPosition(140.0f, 320.0f)).setColorBackground(this.color(128, 128, 128))).setColorForeground(this.color(128, 128, 128))).setColorLabel(this.color(255, 255, 255))).hideArrow()).disableCollapse()).setWidth(790);
        this.createButtons();
        this.confirmPrint = (Button)((Button)((Button)((Button)((Button)((Button)this.printDialogWindowController.addButton("yes").setPosition(450.0f, (float)(h - 110))).setSize(30, 30)).setColorBackground(this.color(128, 128, 128))).setColorForeground(this.color(0, 0, 0))).setColorCaptionLabel(this.color(255, 255, 255))).setVisible(false);
        this.declinePrint = (Button)((Button)((Button)((Button)((Button)((Button)this.printDialogWindowController.addButton("no").setPosition(490.0f, (float)(h - 110))).setSize(30, 30)).setColorBackground(this.color(128, 128, 128))).setColorForeground(this.color(0, 0, 0))).setColorCaptionLabel(this.color(255, 255, 255))).setVisible(false);
        this.cutterBox = (ListBox)((ListBox)((ListBox)this.printDialogWindowController.addListBox("cutterBox").setPosition((float)(w - 440), 40.0f)).setSize(120, 120).setItemHeight(15).setBarHeight(15)).setColorBackground(this.color(128, 128, 128)).setColorForeground(this.color(0, 0, 0)).setColorLabel(this.color(255, 255, 255)).setCaptionLabel("Choose an cutter");
        this.cutterBox.getCaptionLabel().getStyle().marginTop = 3;
        this.cutterBox.getValueLabel().getStyle().marginTop = 3;
        this.updateCutters();
        this.cutterAddress = ((Textfield)((Textfield)((Textfield)((Textfield)this.printDialogWindowController.addTextfield("cutterAddress").setPosition((float)(w - 295), 40.0f)).setColorBackground(this.color(128, 128, 128))).setColorForeground(this.color(128, 128, 128))).setSize(120, 30)).setText(this.printDialogInstance.getLaserCutterSettings().getAddress());
        ((Textlabel)((Textlabel)((Textlabel)this.printDialogWindowController.addTextlabel("cutterAddressLabel").setPosition((float)(w - 300), 20.0f)).setSize(150, 30)).setColorValueLabel(0xFFFFFF)).setFont(this.createFont("Georgia", 12.0f)).setText("Address of laser cutter");
        ((Textlabel)((Textlabel)((Textlabel)this.printDialogWindowController.addTextlabel("cutterSelectedLabel").setPosition((float)(w - 460), 200.0f)).setSize(150, 30)).setColorValueLabel(0xFFFFFF)).setFont(this.createFont("Georgia", 12.0f)).setText("Lasercutter selected");
        this.cutterSelected = ((Textlabel)((Textlabel)((Textlabel)this.printDialogWindowController.addTextlabel("cutterSelected").setPosition((float)(w - 460), 220.0f)).setSize(150, 30)).setColorValueLabel(0xFFFFFF)).setFont(this.createFont("Georgia", 12.0f)).setText(this.printDialogInstance.getLaserCutterSettings().getSelectedCutter().returnDevice());
        this.dpiBox = (ListBox)((ListBox)((ListBox)this.printDialogWindowController.addListBox("dpiBox").setPosition((float)(w - 140), 40.0f)).setSize(120, 120).setItemHeight(15).setBarHeight(15)).setColorBackground(this.color(128, 128, 128)).setColorForeground(this.color(0, 0, 0)).setColorLabel(this.color(255, 255, 255)).setCaptionLabel("Choose a dpi setting");
        this.dpiBox.getCaptionLabel().getStyle().marginTop = 3;
        this.dpiBox.getValueLabel().getStyle().marginTop = 3;
        this.dpiSelected = ((Textlabel)((Textlabel)((Textlabel)this.printDialogWindowController.addTextlabel("dpiSelected").setPosition((float)(w - 140), 220.0f)).setSize(150, 30)).setColorValueLabel(0xFFFFFF)).setFont(this.createFont("Georgia", 12.0f)).setText(String.valueOf(Integer.toString(this.printDialogInstance.getLaserCutterSettings().getDPI())) + " DPI");
        this.dpiSelectLabel = ((Textlabel)((Textlabel)((Textlabel)this.printDialogWindowController.addTextlabel("dpiSelectLabel").setPosition((float)(w - 140), 200.0f)).setSize(150, 30)).setColorValueLabel(0xFFFFFF)).setFont(this.createFont("Georgia", 12.0f)).setText("DPI setting selected");
        ((Button)((Button)((Button)((Button)this.printDialogWindowController.addButton("Use address").setPosition((float)(w - 265), 80.0f)).setSize(60, 30)).setColorBackground(this.color(128, 128, 128))).setColorForeground(this.color(0, 0, 0))).setColorCaptionLabel(this.color(255, 255, 255));
        ((Textlabel)((Textlabel)((Textlabel)this.printDialogWindowController.addTextlabel("addressEnteredLabel").setPosition((float)(w - 295), 200.0f)).setSize(150, 30)).setColorValueLabel(0xFFFFFF)).setFont(this.createFont("Georgia", 12.0f)).setText("Address entered");
        this.addressEntered = ((Textlabel)((Textlabel)((Textlabel)this.printDialogWindowController.addTextlabel("addressentered").setPosition((float)(w - 295), 220.0f)).setSize(150, 30)).setColorValueLabel(0xFFFFFF)).setFont(this.createFont("Georgia", 12.0f)).setText(this.printDialogInstance.getLaserCutterSettings().getAddress());
        if (this.printDialogInstance.getLaserCutterSettings().getSelectedCutter().returnDevice().equals("no selected")) {
            this.dpiSelected.setVisible(false);
            this.dpiSelectLabel.setVisible(false);
            this.dpiBox.setVisible(false);
            return new double[0];
        }
        return this.updateDPIBox();
    }

    void updateListBox() {
        this.unplacedShapesBox.clear();
        if (this.printDialogInstance.printInstancesNotEmpty()) {
            ArrayList<Shape> unplacedShapes = this.printDialogInstance.getUnplacedShapes();
            int i = 0;
            while (i < unplacedShapes.size()) {
                this.unplacedShapesBox.addItem(unplacedShapes.get(i).getGShape().getName(), i);
                ++i;
            }
            this.unplacedShapesBox.updateListBoxItems();
        }
    }

    void createButtons() {
        if (this.printDialogInstance.printInstancesNotEmpty()) {
            ArrayList<PrintInstance> printInstances = this.printDialogInstance.getPrintInstances();
            int buttonNumber = 0;
            int i = 0;
            while (i < this.instanceButtons.size()) {
                this.printDialogWindowController.remove((Object)this.instanceButtons.get(i));
                this.instanceButtons.get(i).remove();
                ++i;
            }
            this.instanceButtons = new ArrayList();
            i = 0;
            while (i < printInstances.size()) {
                int j = 0;
                while (j < printInstances.get(i).getNumberOfSubInstances()) {
                    int row = buttonNumber / 5;
                    int collumn = buttonNumber % 5;
                    int name = j + 1;
                    Button newButton = (Button)((Button)((Button)((Button)((Button)((Button)((Button)this.printDialogWindowController.addButton(String.valueOf(printInstances.get(i).getMaterial().getMaterialName()) + " - " + name).setPosition((float)(collumn * 160), (float)(row * 50))).setSize(150, 30)).setId(buttonNumber)).setColorBackground(this.color(128, 128, 128))).setColorForeground(this.color(0, 0, 0))).setColorCaptionLabel(this.color(255, 255, 255))).setGroup((ControllerGroup)this.instanceGroup);
                    this.instanceButtons.add(newButton);
                    ++buttonNumber;
                    ++j;
                }
                ++i;
            }
            this.setActiveButton();
        }
    }

    void updateCutters() {
        this.cutterBox.clear();
        boolean done = false;
        int counter = 0;
        while (!done) {
            LaserCutter cutter = new LaserCutter();
            cutter.setDevice(counter);
            if (!cutter.returnDevice().equals("no selected")) {
                this.cutterBox.addItem(cutter.returnDevice(), counter);
            } else {
                done = true;
            }
            ++counter;
        }
    }

    double[] updateDPIBox() {
        this.dpiBox.clear();
        double[] dpi = this.printDialogInstance.getLaserCutterSettings().getSelectedCutter().returnDPI();
        int i = 0;
        while (i < dpi.length) {
            this.dpiBox.addItem(Double.toString(dpi[i]), i);
            ++i;
        }
        return dpi;
    }

    void activateAll(boolean state) {
        this.lasercutButton.setVisible(state);
        this.exportSVGButton.setVisible(state);
        this.addExtraJobButton.setVisible(state);
    }

    void setActiveButton() {
        this.instanceButtons.get(this.printDialogInstance.activeButtonNumber()).setColorBackground(this.color(0, 0, 0));
    }

    void setButtonUnactive() {
        this.instanceButtons.get(this.printDialogInstance.activeButtonNumber()).setColorBackground(this.color(128, 128, 128));
    }

    double[] showDPIBox() {
        this.dpiBox.setVisible(true);
        this.dpiSelected.setVisible(true);
        this.dpiSelectLabel.setVisible(true);
        this.dpiSelected.setText(String.valueOf(Integer.toString(this.printDialogInstance.getLaserCutterSettings().getDPI())) + " DPI");
        return this.updateDPIBox();
    }

    void setStatusLabelText(String text) {
        this.statusLabel.setText(text);
    }

    void activateConfirm(boolean activation) {
        this.confirmPrint.setVisible(activation);
        this.declinePrint.setVisible(activation);
    }

    void setDPISelected(String text) {
        this.dpiSelected.setText(text);
    }

    void setCutterSelected(String text) {
        this.cutterSelected.setText(text);
    }

    void setAddressEntered(String text) {
        this.addressEntered.setText(text);
    }

    String getCutterAddress() {
        return this.cutterAddress.getText();
    }
}

