/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.printdialog;

import de.mcp.cutcad.printdialog.lasercutter.LaserCutterSettings;
import processing.core.PApplet;
import processing.data.XML;

class SettingsLoader
extends PApplet {
    XML printSettings;
    private static final long serialVersionUID = -4340621454472534519L;

    SettingsLoader() {
    }

    void loadSettingFile() {
        this.printSettings = this.loadXML("printsettings.xml");
    }

    boolean settingsExists() {
        if (this.printSettings != null) {
            System.out.println("settings existent");
            return true;
        }
        System.out.println("no settings existent");
        return false;
    }

    void persistSettings(LaserCutterSettings settingsToSafe) {
        if (!settingsToSafe.getSelectedCutter().returnDevice().equals("no selected")) {
            System.out.println("start persisting");
            String output = "<printsettings><lasercutter>";
            output = String.valueOf(output) + settingsToSafe.getSelectedCutter().returnDevice();
            output = String.valueOf(output) + "</lasercutter>";
            output = String.valueOf(output) + "<address>";
            output = String.valueOf(output) + settingsToSafe.getAddress();
            output = String.valueOf(output) + "</address>";
            output = String.valueOf(output) + "<dpi>";
            output = String.valueOf(output) + settingsToSafe.getDPI();
            output = String.valueOf(output) + "</dpi>";
            output = String.valueOf(output) + "</printsettings>";
            this.printSettings = this.parseXML(output);
            System.out.println(output);
            this.saveXML(this.printSettings, "printsettings.xml");
        } else {
            System.out.println("no settings to safe");
        }
    }

    LaserCutterSettings loadSettings() {
        LaserCutterSettings laserCutterSettings = new LaserCutterSettings();
        laserCutterSettings.getSelectedCutter().setDevice(this.printSettings.getChild("lasercutter").getContent());
        laserCutterSettings.setAddress(this.printSettings.getChild("address").getContent());
        laserCutterSettings.setDPI(this.printSettings.getChild("dpi").getIntContent());
        return laserCutterSettings;
    }
}

