/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.printdialog;

import de.mcp.cutcad.printdialog.PrintConstraintChecker;
import de.mcp.cutcad.printdialog.PrintDialogInstance;
import de.mcp.cutcad.printdialog.PrintInstance;
import de.mcp.cutcad.printdialog.lasercutter.LaserCutterSettings;
import de.mcp.cutcad.printdialog.selectpath.SelectPathDialogInstance;
import java.io.File;
import java.util.ArrayList;

class Printer {
    ArrayList<PrintInstance> toBePrintedInstances;
    LaserCutterSettings laserCutterSettings;
    PrintDialogInstance parent;
    private int printer;
    private int printCounter;
    private int confirmLevel;

    Printer(ArrayList<PrintInstance> toBePrintedInstances, LaserCutterSettings laserCutterSettings, PrintDialogInstance parent) {
        this.toBePrintedInstances = toBePrintedInstances;
        this.parent = parent;
        this.laserCutterSettings = laserCutterSettings;
        this.printCounter = 0;
    }

    private void setLaserCutter() {
        int i = 0;
        while (i < this.toBePrintedInstances.size()) {
            this.toBePrintedInstances.get(i).setLaserCutter(this.laserCutterSettings.getSelectedCutter(), this.laserCutterSettings.getAddress());
            ++i;
        }
    }

    private void setDPI() {
        int i = 0;
        while (i < this.toBePrintedInstances.size()) {
            this.toBePrintedInstances.get(i).setDPI(this.laserCutterSettings.getDPI());
            ++i;
        }
    }

    String print() {
        this.printer = 0;
        PrintConstraintChecker checker = new PrintConstraintChecker(this.toBePrintedInstances, this);
        String result = checker.checkPrintConstraints();
        if (result.equals("passed")) {
            return this.startPrint();
        }
        return result;
    }

    void printNext() {
        ++this.printCounter;
        if (this.printCounter < this.toBePrintedInstances.size()) {
            this.toBePrintedInstances.get(this.printCounter).setPrinter(this);
            this.toBePrintedInstances.get(this.printCounter).print();
        } else {
            this.parent.printComplete();
        }
    }

    String printSVG() {
        this.printer = 1;
        PrintConstraintChecker checker = new PrintConstraintChecker(this.toBePrintedInstances, this);
        String result = checker.checkPrintConstraints();
        if (result.equals("passed")) {
            return this.startPrint();
        }
        return result;
    }

    void confirmationPrint(int confirmLevel) {
        this.confirmLevel = confirmLevel;
        this.parent.confirmationPrint();
    }

    String continuePrint() {
        if (this.confirmLevel == 0) {
            PrintConstraintChecker checker = new PrintConstraintChecker(this.toBePrintedInstances, this);
            String result = checker.checkUnplacedShapes();
            if (result.equals("passed")) {
                return this.startPrint();
            }
            return result;
        }
        if (this.confirmLevel == 1) {
            return this.startPrint();
        }
        return "passed";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String startPrint() {
        if (this.printer == 0) {
            String result = this.laserCutterSettings.checkConstraints();
            if (!result.equals("passed")) return result;
            this.setLaserCutter();
            this.setDPI();
            this.printCounter = 0;
            this.toBePrintedInstances.get(this.printCounter).setPrinter(this);
            this.toBePrintedInstances.get(this.printCounter).print();
            return "passed";
        } else {
            if (this.printer != 1) return "passed";
            SelectPathDialogInstance selectPathInstance = new SelectPathDialogInstance();
            selectPathInstance.showSelectPathDialog();
            this.exportSVG(selectPathInstance.getSelectedPath());
        }
        return "passed";
    }

    private void exportSVG(File thePath) {
        int i = 0;
        while (i < this.toBePrintedInstances.size()) {
            this.toBePrintedInstances.get(i).printSVG(thePath);
            ++i;
        }
    }
}

