/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.printdialog;

import de.mcp.cutcad.model.Material;
import de.mcp.cutcad.model.primitives.Shape;
import de.mcp.cutcad.printdialog.PrintSubInstance;
import de.mcp.cutcad.printdialog.Printer;
import de.mcp.cutcad.printdialog.lasercutter.LaserCutter;
import java.io.File;
import java.util.ArrayList;

class PrintInstance {
    private ArrayList<Shape> shapes = new ArrayList();
    private ArrayList<PrintSubInstance> subInstances;
    private Material material;
    private int selected;
    private int instancesPrinted;
    private Printer printer;

    PrintInstance(Shape shape, Material material) {
        this.shapes.add(shape);
        this.material = material;
        this.subInstances = new ArrayList();
        PrintSubInstance initial = new PrintSubInstance(this);
        this.subInstances.add(initial);
        this.selected = this.getSubInstanceIndex(initial);
    }

    void addShape(Shape shape) {
        this.shapes.add(shape);
    }

    ArrayList<Shape> getUnplacedShapes() {
        return this.shapes;
    }

    ArrayList<Shape> getPlacedShapes() {
        return this.subInstances.get(this.selected).getPlacedShapes();
    }

    Material getMaterial() {
        return this.material;
    }

    void placeShape(Shape shape) {
        this.shapes.remove(shape);
        this.subInstances.get(this.selected).placeShape(shape);
    }

    void unplaceShape(Shape shape) {
        this.subInstances.get(this.selected).unplaceShape(shape);
        this.shapes.add(shape);
    }

    void selectSubInstance(PrintSubInstance selected) {
        this.selected = this.getSubInstanceIndex(selected);
    }

    private int getSubInstanceIndex(PrintSubInstance selected) {
        int i = 0;
        while (i < this.subInstances.size()) {
            if (this.subInstances.get(i) == selected) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void print() {
        this.instancesPrinted = 0;
        if (this.subInstances.get(this.instancesPrinted).getPlacedShapes().size() > 0 && !this.material.getMaterialName().equals("Nothing 0,5 mm")) {
            this.subInstances.get(0).print(String.valueOf(this.material.getMaterialName()) + " - " + "1");
        } else {
            this.printNext();
        }
    }

    void printNext() {
        ++this.instancesPrinted;
        if (this.instancesPrinted < this.subInstances.size()) {
            if (this.subInstances.get(this.instancesPrinted).getPlacedShapes().size() > 0 && !this.material.getMaterialName().equals("Nothing 0,5 mm")) {
                int name = this.instancesPrinted + 1;
                this.subInstances.get(this.instancesPrinted).print(String.valueOf(this.material.getMaterialName()) + " - " + name);
            } else {
                this.printNext();
            }
        } else {
            this.printer.printNext();
        }
    }

    void printSVG(File thePath) {
        int i = 0;
        while (i < this.subInstances.size()) {
            if (this.subInstances.get(i).getPlacedShapes().size() > 0 && !this.material.getMaterialName().equals("Nothing 0,5 mm")) {
                int name = i + 1;
                String exportPath = String.valueOf(thePath.toString()) + this.material.getMaterialName() + " - " + name;
                this.subInstances.get(i).printSVG(exportPath);
            }
            ++i;
        }
    }

    public void setPrinter(Printer printer) {
        this.printer = printer;
    }

    int getNumberOfSubInstances() {
        return this.subInstances.size();
    }

    void addSubInstance() {
        PrintSubInstance newInstance = new PrintSubInstance(this);
        this.subInstances.add(newInstance);
        this.selected = this.getSubInstanceIndex(newInstance);
    }

    void setActiveSubInstance(int index) {
        this.selected = index;
    }

    int getSelectedSubInstance() {
        return this.selected;
    }

    boolean checkPlacedShapes() {
        boolean shapePlaced = false;
        int i = 0;
        while (i < this.subInstances.size()) {
            if (this.subInstances.get(i).getPlacedShapes().size() > 0) {
                shapePlaced = true;
            }
            ++i;
        }
        return shapePlaced;
    }

    String checkOverlap() {
        boolean overlapped = false;
        String result = "";
        int i = 0;
        while (i < this.subInstances.size()) {
            if (this.subInstances.get(i).checkOverlap()) {
                overlapped = true;
                int name = i + 1;
                result = !result.equals("") ? String.valueOf(result) + ", overlap in " + this.material.getMaterialName() + name : String.valueOf(result) + "overlap in " + this.material.getMaterialName() + " - " + name;
            }
            ++i;
        }
        if (overlapped) {
            return result;
        }
        return "no overlap";
    }

    void setLaserCutter(LaserCutter cutter, String ipAddress) {
        int i = 0;
        while (i < this.subInstances.size()) {
            this.subInstances.get(i).setLaserCutter(cutter, ipAddress);
            ++i;
        }
    }

    void setDPI(int dpi) {
        int i = 0;
        while (i < this.subInstances.size()) {
            this.subInstances.get(i).setDPI(dpi);
            ++i;
        }
    }
}

