/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.model;

import de.mcp.cutcad.model.Connection;
import de.mcp.cutcad.model.STLMesh;
import de.mcp.cutcad.model.primitives.Cutout;
import de.mcp.cutcad.model.primitives.Edge;
import de.mcp.cutcad.model.primitives.Shape;
import de.mcp.cutcad.view.Drawable2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class ObjectContainer {
    private List<Drawable2D> objects = new ArrayList<Drawable2D>();
    private STLMesh stlMesh = new STLMesh();
    private boolean unsavedChanges;

    public STLMesh getSTLMesh() {
        return this.stlMesh;
    }

    public List<Drawable2D> allDrawables() {
        ArrayList<Drawable2D> drawables = new ArrayList<Drawable2D>(this.objects);
        return drawables;
    }

    public List<Shape> allShapes() {
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        for (Drawable2D o : this.objects) {
            if (!(o instanceof Shape)) continue;
            shapes.add((Shape)o);
        }
        return shapes;
    }

    public void addShape(Shape shape) {
        this.objects.add(shape);
        this.unsavedChanges = true;
    }

    public void removeShape(Shape shape) {
        this.objects.remove(shape);
        this.unsavedChanges = true;
    }

    public List<Edge> allEdges() {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Shape shape : this.allShapes()) {
            edges.addAll(shape.getGShape().getEdges());
        }
        return edges;
    }

    public List<Connection> allConnections() {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (Drawable2D o : this.objects) {
            if (!(o instanceof Connection)) continue;
            connections.add((Connection)o);
        }
        return connections;
    }

    public void addConnection(Connection connection) {
        this.objects.add(connection);
        this.unsavedChanges = true;
    }

    public void removeConnection(Connection connection) {
        this.objects.remove(connection);
        this.unsavedChanges = true;
    }

    public List<Cutout> allCutouts() {
        ArrayList<Cutout> cutouts = new ArrayList<Cutout>();
        for (Shape s : this.allShapes()) {
            cutouts.addAll(s.getGShape().getCutouts());
        }
        return cutouts;
    }

    public void save(File file) {
        ObjectOutputStream oos = null;
        try {
            try {
                FileOutputStream fos = new FileOutputStream(file);
                oos = new ObjectOutputStream(fos);
                oos.writeObject(this.objects);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    oos.close();
                    this.unsavedChanges = false;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    oos.close();
                    this.unsavedChanges = false;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                oos.close();
                this.unsavedChanges = false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Loose catch block
     */
    public void load(File theFile) {
        ObjectInputStream ois = null;
        try {
            try {
                FileInputStream fis = new FileInputStream(theFile);
                ois = new ObjectInputStream(fis);
                this.objects = (List)ois.readObject();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    ois.close();
                    this.unsavedChanges = false;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    ois.close();
                    this.unsavedChanges = false;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    ois.close();
                    this.unsavedChanges = false;
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
            }
        }
        finally {
            try {
                ois.close();
                this.unsavedChanges = false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void clear() {
        this.objects = new ArrayList<Drawable2D>();
        this.stlMesh = new STLMesh();
        this.unsavedChanges = false;
    }

    public boolean hasUnsavedChanges() {
        return this.unsavedChanges;
    }
}

