/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.algorithm;

import de.mcp.cutcad.model.primitives.Edge;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.model.primitives.Vector3D;
import java.util.ArrayList;

public class CreateTenons {
    private static float tolerance = 0.1f;
    private static int relationTenonToEdge = 4;

    public static void createOutlineOfEdge(Edge edge) {
        ArrayList<Vector2D> basic = new ArrayList<Vector2D>();
        basic.add(edge.getV1());
        basic.add(edge.getV2());
        edge.setTenons(basic);
    }

    private static float safeAngleBetween(Vector3D masterEdgeDirection, Vector3D slaveEdgeDirection) {
        float angle = slaveEdgeDirection.angleBetween(masterEdgeDirection, true);
        if (Float.isNaN(angle)) {
            angle = slaveEdgeDirection.add(masterEdgeDirection).equalsWithTolerance(new Vector3D(0.0f, 0.0f, 0.0f), tolerance) ? (float)Math.PI : 0.0f;
        }
        return angle;
    }

    public static void createOutlineOfEdge(Edge masterEdge, Edge slaveEdge) {
        float slaveTenonHeight;
        float masterTenonHeight;
        Vector3D p1 = masterEdge.getGShape().get3Dperpendicular(masterEdge.getP3D1(), masterEdge.getP3D2());
        Vector3D p2 = slaveEdge.getGShape().get3Dperpendicular(slaveEdge.getP3D1(), slaveEdge.getP3D2());
        float angle = CreateTenons.safeAngleBetween(p1, p2);
        float edgeLength = masterEdge.getV1().distanceTo(masterEdge.getV2());
        int thicknessMaster = masterEdge.getGShape().getThickness();
        int thicknessSlave = slaveEdge.getGShape().getThickness();
        int numberOfTenons = (int)(2.0f * edgeLength / (float)(relationTenonToEdge * (thicknessMaster + thicknessSlave)));
        numberOfTenons = numberOfTenons / 2 * 2;
        float lengthOfATenon = edgeLength / (float)(++numberOfTenons);
        float masterTenonDepth = masterTenonHeight = CreateTenons.getHeight(thicknessMaster, thicknessSlave, angle);
        float slaveTenonDepth = slaveTenonHeight = CreateTenons.getHeight(thicknessSlave, thicknessMaster, angle);
        if (angle > 0.0f && angle < 1.5707964f || angle > (float)Math.PI && angle < 4.712389f) {
            if (masterTenonDepth > (float)(thicknessMaster + thicknessSlave)) {
                masterTenonDepth = thicknessMaster + thicknessSlave;
                slaveTenonHeight = (float)((thicknessMaster + thicknessSlave) / 2) * (float)Math.sin(angle);
            }
            if (slaveTenonDepth > (float)(thicknessMaster + thicknessSlave)) {
                slaveTenonDepth = thicknessMaster + thicknessSlave;
                masterTenonHeight = (float)((thicknessMaster + thicknessSlave) / 2) * (float)Math.sin(angle);
            }
        } else {
            angle -= 1.5707964f;
            if (masterTenonDepth > (float)(thicknessMaster + thicknessSlave)) {
                masterTenonDepth = thicknessMaster + thicknessSlave;
                slaveTenonHeight = (float)((double)masterTenonDepth / Math.sin(angle) + Math.abs((double)((thicknessMaster + thicknessSlave) / 4) / Math.tan(angle)));
            }
            if (slaveTenonDepth > (float)(thicknessMaster + thicknessSlave)) {
                slaveTenonDepth = thicknessMaster + thicknessSlave;
                masterTenonHeight = (float)((double)slaveTenonDepth / Math.sin(angle) + Math.abs((double)((thicknessMaster + thicknessSlave) / 4) / Math.tan(angle)));
            }
        }
        masterEdge.setTenons(CreateTenons.createTenons(masterEdge, lengthOfATenon, masterTenonHeight, masterTenonDepth, numberOfTenons, true));
        slaveEdge.setTenons(CreateTenons.createTenons(slaveEdge, lengthOfATenon, slaveTenonHeight, slaveTenonDepth, numberOfTenons, false));
    }

    private static float getHeight(int thicknessMaster, int thicknessSlave, float angle) {
        if (angle == 0.0f || angle == (float)Math.PI) {
            angle = angle - 0.001f - 1.5707964f;
            return (float)(thicknessSlave / 2) / (float)Math.cos(angle) + (float)(thicknessMaster / 2) * (float)Math.tan(angle);
        }
        if (angle == 1.5707964f || angle == 4.712389f) {
            return thicknessSlave / 2;
        }
        if (angle > 0.0f && angle < 1.5707964f || angle > (float)Math.PI && angle < 4.712389f) {
            return (float)(thicknessSlave / 2) / (float)Math.sin(angle) + (float)(thicknessMaster / 2) / (float)Math.tan(angle);
        }
        return (float)(thicknessSlave / 2) / (float)Math.cos(angle -= 1.5707964f) + (float)(thicknessMaster / 2) * (float)Math.tan(angle);
    }

    private static ArrayList<Vector2D> createTenons(Edge edge, float lengthOfATenon, float tenonHeight, float tenonDepth, int numberOfTenons, boolean beginWithExtrusion) {
        Vector2D edgeDirection = edge.getV2().sub(edge.getV1()).getNormalized();
        Vector2D tenonDirection = edge.getGShape().get2Dperpendicular(edge.getV2(), edge.getV1());
        ArrayList<Vector2D> listTenons = new ArrayList<Vector2D>();
        Vector2D currentTenon = edge.getV1().copy();
        int startExtruded = beginWithExtrusion ? 0 : 1;
        int i = 0;
        while (i < numberOfTenons) {
            float offset = i % 2 == startExtruded ? tenonHeight : tenonDepth * -1.0f;
            currentTenon = currentTenon.add(tenonDirection.scale(offset));
            listTenons.add(currentTenon);
            currentTenon = currentTenon.add(edgeDirection.scale(lengthOfATenon));
            listTenons.add(currentTenon);
            currentTenon = currentTenon.sub(tenonDirection.scale(offset));
            ++i;
        }
        return listTenons;
    }
}

